/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tools;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.tools.Pickaxe;

public class Hammer
extends Pickaxe {
    public static final float DURABILITY_MODIFIER = 2.5f;

    public Hammer() {
        super(PartMaterialType.handle(TinkerTools.toughToolRod), PartMaterialType.head(TinkerTools.hammerHead), PartMaterialType.head(TinkerTools.largePlate), PartMaterialType.head(TinkerTools.largePlate));
        this.addCategory(Category.WEAPON);
    }

    @Override
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        this.addDefaultSubItems((List<ItemStack>)subItems, new Material[0]);
        this.addInfiTool((List<ItemStack>)subItems, "InfiMiner");
    }

    @Override
    public float miningSpeedModifier() {
        return 0.4f;
    }

    @Override
    public float damagePotential() {
        return 1.2f;
    }

    @Override
    public double attackSpeed() {
        return 0.8f;
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        boolean hit;
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            damage += (float)(3 + TConstruct.random.nextInt(4));
        }
        if ((hit = super.dealDamage(stack, player, entity, damage)) && this.readyForSpecialAttack(player)) {
            TinkerTools.proxy.spawnAttackParticle(Particles.HAMMER_ATTACK, (Entity)player, 0.8);
        }
        return hit;
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 3, 3, 1);
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2, 3};
    }

    @Override
    public float getRepairModifierForPart(int index) {
        return index == 1 ? 2.5f : 1.5f;
    }

    @Override
    public ToolNBT buildTagData(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats plate1 = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        HeadMaterialStats plate2 = (HeadMaterialStats)materials.get(3).getStatsOrUnknown("head");
        ToolNBT data = new ToolNBT();
        data.head(head, head, plate1, plate2);
        data.handle(handle);
        data.harvestLevel = head.harvestLevel;
        data.durability = (int)((float)data.durability * 2.5f);
        return data;
    }
}

