/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.ranged.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.crosshair.Crosshairs;
import slimeknights.tconstruct.library.client.crosshair.ICrosshair;
import slimeknights.tconstruct.library.client.crosshair.ICustomCrosshairUser;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ranged.BowCore;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;

public class ShortBow
extends BowCore
implements ICustomCrosshairUser {
    public ShortBow() {
        this(PartMaterialType.bow(TinkerTools.bowLimb), PartMaterialType.bow(TinkerTools.bowLimb), PartMaterialType.bowstring(TinkerTools.bowString));
    }

    public ShortBow(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.func_185043_a(PROPERTY_PULL_PROGRESS, this.pullProgressPropertyGetter);
        this.func_185043_a(PROPERTY_IS_PULLING, this.isPullingPropertyGetter);
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{0, 1};
    }

    @Override
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        this.addDefaultSubItems((List<ItemStack>)subItems, null, null, TinkerMaterials.string);
    }

    @Override
    public float baseProjectileDamage() {
        return 0.0f;
    }

    @Override
    public float damagePotential() {
        return 0.7f;
    }

    @Override
    public double attackSpeed() {
        return 3.0;
    }

    @Override
    protected float baseInaccuracy() {
        return 1.0f;
    }

    @Override
    public float projectileDamageModifier() {
        return 0.8f;
    }

    @Override
    public int getDrawTime() {
        return 12;
    }

    @Override
    protected List<Item> getAmmoItems() {
        return TinkerRangedWeapons.getDiscoveredArrows();
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.preventSlowDown(entityIn, 0.5f);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public ProjectileLauncherNBT buildTagData(List<Material> materials) {
        ProjectileLauncherNBT data = new ProjectileLauncherNBT();
        HeadMaterialStats head1 = (HeadMaterialStats)materials.get(0).getStatsOrUnknown("head");
        HeadMaterialStats head2 = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        BowMaterialStats limb1 = (BowMaterialStats)materials.get(0).getStatsOrUnknown("bow");
        BowMaterialStats limb2 = (BowMaterialStats)materials.get(1).getStatsOrUnknown("bow");
        BowStringMaterialStats bowstring = (BowStringMaterialStats)materials.get(2).getStatsOrUnknown("bowstring");
        data.head(head1, head2);
        data.limb(limb1, limb2);
        data.bowstring(bowstring);
        return data;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICrosshair getCrosshair(ItemStack itemStack, EntityPlayer player) {
        return Crosshairs.SQUARE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getCrosshairState(ItemStack itemStack, EntityPlayer player) {
        return this.getDrawbackProgress(itemStack, (EntityLivingBase)player);
    }
}

