/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.inventory;

import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.IModifyable;
import slimeknights.tconstruct.library.tinkering.IRepairable;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.tools.common.client.GuiToolStation;
import slimeknights.tconstruct.tools.common.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.common.inventory.SlotToolStationIn;
import slimeknights.tconstruct.tools.common.inventory.SlotToolStationOut;
import slimeknights.tconstruct.tools.common.network.ToolStationSelectionPacket;
import slimeknights.tconstruct.tools.common.network.ToolStationTextPacket;
import slimeknights.tconstruct.tools.common.tileentity.TileToolStation;

public class ContainerToolStation
extends ContainerTinkerStation<TileToolStation> {
    protected SlotToolStationOut out;
    protected ToolCore selectedTool;
    protected int activeSlots;
    public String toolName;

    public ContainerToolStation(InventoryPlayer playerInventory, TileToolStation tile) {
        super(tile);
        int i;
        for (i = 0; i < tile.func_70302_i_(); ++i) {
            this.func_75146_a(new SlotToolStationIn((IInventory)tile, i, 0, 0, (Container)this));
        }
        this.out = new SlotToolStationOut(i, 124, 38, this);
        this.func_75146_a(this.out);
        this.addPlayerInventory(playerInventory, 8, 92);
        this.func_75130_a(null);
    }

    public ItemStack getResult() {
        return this.out.func_75211_c();
    }

    protected void syncNewContainer(EntityPlayerMP player) {
        this.activeSlots = ((TileToolStation)this.tile).func_70302_i_();
        TinkerNetwork.sendTo((AbstractPacket)new ToolStationSelectionPacket(null, ((TileToolStation)this.tile).func_70302_i_()), player);
    }

    protected void syncWithOtherContainer(BaseContainer<TileToolStation> otherContainer, EntityPlayerMP player) {
        this.syncWithOtherContainer((ContainerToolStation)otherContainer, player);
    }

    protected void syncWithOtherContainer(ContainerToolStation otherContainer, EntityPlayerMP player) {
        this.setToolSelection(otherContainer.selectedTool, otherContainer.activeSlots);
        this.setToolName(otherContainer.toolName);
        TinkerNetwork.sendTo((AbstractPacket)new ToolStationSelectionPacket(otherContainer.selectedTool, otherContainer.activeSlots), player);
        if (otherContainer.toolName != null && !otherContainer.toolName.isEmpty()) {
            TinkerNetwork.sendTo((AbstractPacket)new ToolStationTextPacket(otherContainer.toolName), player);
        }
    }

    public void setToolSelection(ToolCore tool, int activeSlots) {
        if (activeSlots > ((TileToolStation)this.tile).func_70302_i_()) {
            activeSlots = ((TileToolStation)this.tile).func_70302_i_();
        }
        this.activeSlots = activeSlots;
        this.selectedTool = tool;
        for (int i = 0; i < ((TileToolStation)this.tile).func_70302_i_(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotToolStationIn)) continue;
            SlotToolStationIn slotToolPart = (SlotToolStationIn)slot;
            slotToolPart.setRestriction(null);
            if (i >= activeSlots) {
                slotToolPart.deactivate();
            } else {
                List<PartMaterialType> pmts;
                slotToolPart.activate();
                if (tool != null && i < (pmts = tool.getToolBuildComponents()).size()) {
                    slotToolPart.setRestriction(pmts.get(i));
                }
            }
            if (!this.world.field_72995_K) continue;
            slotToolPart.updateIcon();
        }
    }

    public void setToolName(String name) {
        GuiScreen screen;
        this.toolName = name;
        if (this.world.field_72995_K && (screen = Minecraft.func_71410_x().field_71462_r) instanceof GuiToolStation) {
            ((GuiToolStation)screen).textField.func_146180_a(name);
        }
        if (this.out.func_75216_d()) {
            if (name != null && !name.isEmpty()) {
                this.out.field_75224_c.func_70301_a(0).func_151001_c(name);
            } else {
                this.out.field_75224_c.func_70301_a(0).func_135074_t();
            }
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.updateGUI();
        try {
            ItemStack result = this.repairTool(false);
            if (result.func_190926_b()) {
                result = this.replaceToolParts(false);
            }
            if (result.func_190926_b()) {
                result = this.modifyTool(false);
            }
            if (result.func_190926_b()) {
                result = this.buildTool();
            }
            this.out.field_75224_c.func_70299_a(0, result);
            this.updateGUI();
        }
        catch (TinkerGuiException e) {
            this.out.field_75224_c.func_70299_a(0, ItemStack.field_190927_a);
            this.error(e.getMessage());
        }
        if (!this.world.field_72995_K) {
            WorldServer server = (WorldServer)this.world;
            for (EntityPlayer player : server.field_73010_i) {
                if (player.field_71070_bA == this || !(player.field_71070_bA instanceof ContainerToolStation) || !this.sameGui((BaseContainer)((ContainerToolStation)player.field_71070_bA))) continue;
                ((ContainerToolStation)player.field_71070_bA).out.field_75224_c.func_70299_a(0, this.out.func_75211_c());
            }
        }
    }

    public void onResultTaken(EntityPlayer playerIn, ItemStack stack) {
        boolean resultTaken = false;
        try {
            resultTaken = !this.repairTool(true).func_190926_b() || !this.replaceToolParts(true).func_190926_b() || !this.modifyTool(true).func_190926_b();
        }
        catch (TinkerGuiException e) {
            e.printStackTrace();
        }
        if (resultTaken) {
            this.updateSlotsAfterToolAction();
        } else {
            ItemStack tool = this.buildTool();
            if (!tool.func_190926_b()) {
                for (int i = 0; i < ((TileToolStation)this.tile).func_70302_i_(); ++i) {
                    ((TileToolStation)this.tile).func_70298_a(i, 1);
                }
                this.setToolName("");
            }
        }
        this.func_75130_a(null);
        this.playCraftSound(playerIn);
    }

    protected void playCraftSound(EntityPlayer player) {
        Sounds.playSoundForAll((Entity)player, Sounds.saw, 0.8f, 0.8f + 0.4f * TConstruct.random.nextFloat());
    }

    private ItemStack repairTool(boolean remove) {
        ItemStack repairable = ((Slot)this.field_75151_b.get(0)).func_75211_c();
        if (repairable.func_190926_b() || !(repairable.func_77973_b() instanceof IRepairable)) {
            return ItemStack.field_190927_a;
        }
        return ToolBuilder.tryRepairTool(this.getInputs(), repairable, remove);
    }

    private ItemStack replaceToolParts(boolean remove) throws TinkerGuiException {
        ItemStack tool = ((Slot)this.field_75151_b.get(0)).func_75211_c();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof TinkersItem)) {
            return ItemStack.field_190927_a;
        }
        return ToolBuilder.tryReplaceToolParts(tool, this.getInputs(), remove);
    }

    private ItemStack modifyTool(boolean remove) throws TinkerGuiException {
        ItemStack modifyable = ((Slot)this.field_75151_b.get(0)).func_75211_c();
        if (modifyable.func_190926_b() || !(modifyable.func_77973_b() instanceof IModifyable)) {
            return ItemStack.field_190927_a;
        }
        return ToolBuilder.tryModifyTool(this.getInputs(), modifyable, remove);
    }

    private ItemStack buildTool() {
        ItemStackList input = ItemStackList.withSize((int)((TileToolStation)this.tile).func_70302_i_());
        for (int i = 0; i < input.size(); ++i) {
            input.set(i, (Object)((TileToolStation)this.tile).func_70301_a(i));
        }
        return ToolBuilder.tryBuildTool((NonNullList<ItemStack>)input, this.toolName, this.getBuildableTools());
    }

    protected Set<ToolCore> getBuildableTools() {
        return TinkerRegistry.getToolStationCrafting();
    }

    private void updateSlotsAfterToolAction() {
        ((TileToolStation)this.tile).func_70299_a(0, ItemStack.field_190927_a);
        for (int i = 1; i < ((TileToolStation)this.tile).func_70302_i_(); ++i) {
            if (((TileToolStation)this.tile).func_70301_a(i).func_190926_b() || ((TileToolStation)this.tile).func_70301_a(i).func_190916_E() != 0) continue;
            ((TileToolStation)this.tile).func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    private NonNullList<ItemStack> getInputs() {
        NonNullList input = NonNullList.func_191197_a((int)(((TileToolStation)this.tile).func_70302_i_() - 1), (Object)ItemStack.field_190927_a);
        for (int i = 1; i < ((TileToolStation)this.tile).func_70302_i_(); ++i) {
            input.set(i - 1, (Object)((TileToolStation)this.tile).func_70301_a(i));
        }
        return input;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot != this.out && super.func_94530_a(stack, slot);
    }
}

