/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockSoil
extends EnumBlock<SoilTypes> {
    public static final PropertyEnum<SoilTypes> TYPE = PropertyEnum.func_177709_a((String)"type", SoilTypes.class);

    public BlockSoil() {
        super(Material.field_151595_p, TYPE, SoilTypes.class);
        this.field_149765_K = 0.8f;
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185855_h);
        this.setHarvestLevel("shovel", -1);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabGeneral);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (SoilTypes type : SoilTypes.values()) {
            if (!this.isTypeEnabled(type)) continue;
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    protected boolean isTypeEnabled(SoilTypes type) {
        switch (type) {
            case GROUT: {
                return TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");
            }
            case SLIMY_MUD_BLUE: {
                return TinkerCommons.matSlimeBallBlue != null;
            }
            case SLIMY_MUD_MAGMA: {
                return TinkerCommons.matSlimeBallMagma != null;
            }
            case SLIMY_MUD_GREEN: 
            case GRAVEYARD: 
            case CONSECRATED: {
                return true;
            }
        }
        return false;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        IBlockState state = worldIn.func_180495_p(pos);
        switch ((SoilTypes)((Object)state.func_177229_b(TYPE))) {
            case SLIMY_MUD_BLUE: 
            case SLIMY_MUD_GREEN: {
                this.processSlimyMud(entityIn);
                break;
            }
            case GRAVEYARD: {
                this.processGraveyardSoil(entityIn);
                break;
            }
            case CONSECRATED: {
                this.processConsecratedSoil(entityIn);
            }
        }
    }

    protected void processSlimyMud(Entity entity) {
        entity.field_70159_w *= 0.4;
        entity.field_70179_y *= 0.4;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 1));
        }
    }

    protected void processConsecratedSoil(Entity entity) {
        EntityLivingBase entityLiving;
        if (entity instanceof EntityLiving && (entityLiving = (EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            entityLiving.func_70097_a(DamageSource.field_76376_m, 1.0f);
            entityLiving.func_70015_d(1);
        }
    }

    protected void processGraveyardSoil(Entity entity) {
        EntityLivingBase entityLiving;
        if (entity instanceof EntityLiving && (entityLiving = (EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            entityLiving.func_70691_i(1.0f);
        }
    }

    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, BlockPos pos, @Nonnull EnumFacing direction, IPlantable plantable) {
        SoilTypes type = (SoilTypes)((Object)world.func_180495_p(pos).func_177229_b(TYPE));
        if (type == SoilTypes.SLIMY_MUD_GREEN || type == SoilTypes.SLIMY_MUD_BLUE) {
            return plantable.getPlantType(world, pos) == TinkerWorld.slimePlantType;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public static enum SoilTypes implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        GROUT,
        SLIMY_MUD_GREEN,
        SLIMY_MUD_BLUE,
        GRAVEYARD,
        CONSECRATED,
        SLIMY_MUD_MAGMA;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

