/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.IRepairable;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.ListUtil;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public final class ToolBuilder {
    private static Logger log = Util.getLogger("ToolBuilder");

    private ToolBuilder() {
    }

    @Nonnull
    public static ItemStack tryBuildTool(NonNullList<ItemStack> stacks, String name) {
        return ToolBuilder.tryBuildTool(stacks, name, TinkerRegistry.getTools());
    }

    @Nonnull
    public static ItemStack tryBuildTool(NonNullList<ItemStack> stacks, String name, Collection<ToolCore> possibleTools) {
        int length = -1;
        for (int i = 0; i < stacks.size(); ++i) {
            if (((ItemStack)stacks.get(i)).func_190926_b()) {
                if (length >= 0) continue;
                length = i;
                continue;
            }
            if (length < 0) continue;
            return ItemStack.field_190927_a;
        }
        if (length < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStackList input = ItemStackList.of(stacks);
        for (Item item : possibleTools) {
            ItemStack output;
            if (!(item instanceof ToolCore) || (output = ((ToolCore)item).buildItemFromStacks((NonNullList<ItemStack>)input)).func_190926_b()) continue;
            if (name != null && !name.isEmpty()) {
                output.func_151001_c(name);
            }
            return output;
        }
        return ItemStack.field_190927_a;
    }

    public static void addTrait(NBTTagCompound rootCompound, ITrait trait, int color) {
        if (TinkerRegistry.getTrait(trait.getIdentifier()) == null) {
            log.error("addTrait: Trying to apply unregistered Trait {}", new Object[]{trait.getIdentifier()});
            return;
        }
        IModifier modifier = TinkerRegistry.getModifier(trait.getIdentifier());
        if (modifier == null || !(modifier instanceof AbstractTrait)) {
            log.error("addTrait: No matching modifier for the Trait {} present", new Object[]{trait.getIdentifier()});
            return;
        }
        AbstractTrait traitModifier = (AbstractTrait)modifier;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList tagList = TagUtil.getModifiersTagList(rootCompound);
        int index = TinkerUtil.getIndexInList(tagList, traitModifier.getModifierIdentifier());
        if (index < 0) {
            traitModifier.updateNBTforTrait(tag, color);
            tagList.func_74742_a((NBTBase)tag);
            TagUtil.setModifiersTagList(rootCompound, tagList);
        } else {
            tag = tagList.func_150305_b(index);
        }
        traitModifier.applyEffect(rootCompound, tag);
    }

    @Nonnull
    public static ItemStack tryRepairTool(NonNullList<ItemStack> stacks, ItemStack toolStack, boolean removeItems) {
        if (toolStack == null || !(toolStack.func_77973_b() instanceof IRepairable)) {
            return ItemStack.field_190927_a;
        }
        if (!removeItems) {
            stacks = Util.deepCopyFixedNonNullList(stacks);
        }
        return ((IRepairable)toolStack.func_77973_b()).repair(toolStack, stacks);
    }

    @Nonnull
    public static ItemStack tryModifyTool(NonNullList<ItemStack> input, ItemStack toolStack, boolean removeItems) throws TinkerGuiException {
        int i;
        ItemStack copy = toolStack.func_77946_l();
        NonNullList<ItemStack> stacks = Util.deepCopyFixedNonNullList(input);
        NonNullList<ItemStack> usedStacks = Util.deepCopyFixedNonNullList(input);
        HashSet appliedModifiers = Sets.newHashSet();
        for (IModifier modifier : TinkerRegistry.getAllModifiers()) {
            Optional<RecipeMatch.Match> matchOptional;
            do {
                matchOptional = modifier.matches(stacks);
                ItemStack backup = copy.func_77946_l();
                if (!matchOptional.isPresent()) continue;
                RecipeMatch.Match match = matchOptional.get();
                while (match.amount > 0) {
                    TinkerGuiException caughtException = null;
                    boolean canApply = false;
                    try {
                        canApply = modifier.canApply(copy, toolStack);
                    }
                    catch (TinkerGuiException e) {
                        caughtException = e;
                    }
                    if (canApply) {
                        modifier.apply(copy);
                        appliedModifiers.add(modifier);
                        --match.amount;
                        continue;
                    }
                    if (caughtException != null && !appliedModifiers.contains(modifier)) {
                        throw caughtException;
                    }
                    copy = backup;
                    RecipeMatch.removeMatch(stacks, (RecipeMatch.Match)match);
                    break;
                }
                if (match.amount != 0) continue;
                RecipeMatch.removeMatch(stacks, (RecipeMatch.Match)match);
                RecipeMatch.removeMatch(usedStacks, (RecipeMatch.Match)match);
            } while (matchOptional.isPresent());
        }
        for (i = 0; i < input.size(); ++i) {
            if (((ItemStack)input.get(i)).func_190926_b() || !ItemStack.func_77989_b((ItemStack)((ItemStack)input.get(i)), (ItemStack)((ItemStack)stacks.get(i)))) continue;
            if (!appliedModifiers.isEmpty()) {
                String error = I18n.func_74837_a((String)"gui.error.no_modifier_for_item", (Object[])new Object[]{((ItemStack)input.get(i)).func_82833_r()});
                throw new TinkerGuiException(error);
            }
            return ItemStack.field_190927_a;
        }
        if (removeItems) {
            for (i = 0; i < input.size(); ++i) {
                if (((ItemStack)usedStacks.get(i)).func_190926_b()) {
                    ((ItemStack)input.get(i)).func_190920_e(0);
                    continue;
                }
                ((ItemStack)input.get(i)).func_190920_e(((ItemStack)usedStacks.get(i)).func_190916_E());
            }
        }
        if (!appliedModifiers.isEmpty()) {
            if (copy.func_77973_b() instanceof TinkersItem) {
                NBTTagCompound root = TagUtil.getTagSafe(copy);
                ToolBuilder.rebuildTool(root, (TinkersItem)copy.func_77973_b());
                copy.func_77982_d(root);
            }
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack tryReplaceToolParts(ItemStack toolStack, NonNullList<ItemStack> toolPartsIn, boolean removeItems) throws TinkerGuiException {
        if (toolStack == null || !(toolStack.func_77973_b() instanceof TinkersItem)) {
            return ItemStack.field_190927_a;
        }
        ItemStackList inputItems = ItemStackList.of(Util.deepCopyFixedNonNullList(toolPartsIn));
        if (!TinkerEvent.OnToolPartReplacement.fireEvent((NonNullList<ItemStack>)inputItems, toolStack)) {
            return ItemStack.field_190927_a;
        }
        NonNullList<ItemStack> toolParts = Util.deepCopyFixedNonNullList((NonNullList<ItemStack>)inputItems);
        TIntIntHashMap assigned = new TIntIntHashMap();
        TinkersItem tool = (TinkersItem)toolStack.func_77973_b();
        NBTTagList materialList = TagUtil.getBaseMaterialsTagList(toolStack).func_74737_b();
        for (int i2 = 0; i2 < toolParts.size(); ++i2) {
            ItemStack part = (ItemStack)toolParts.get(i2);
            if (part.func_190926_b()) continue;
            if (!(part.func_77973_b() instanceof IToolPart)) {
                return ItemStack.field_190927_a;
            }
            int candidate = -1;
            List<PartMaterialType> pms = tool.getRequiredComponents();
            for (int j2 = 0; j2 < pms.size(); ++j2) {
                PartMaterialType pmt = pms.get(j2);
                String partMat = ((IToolPart)part.func_77973_b()).getMaterial(part).getIdentifier();
                String currentMat = materialList.func_150307_f(j2);
                if (!pmt.isValid(part) || partMat.equals(currentMat) || assigned.valueCollection().contains(j2)) continue;
                candidate = j2;
                if (i2 <= j2) break;
            }
            if (candidate < 0) {
                return ItemStack.field_190927_a;
            }
            assigned.put(i2, candidate);
        }
        if (assigned.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        assigned.forEachEntry((i, j) -> {
            String mat = ((IToolPart)((ItemStack)toolParts.get(i)).func_77973_b()).getMaterial((ItemStack)toolParts.get(i)).getIdentifier();
            materialList.func_150304_a(j, (NBTBase)new NBTTagString(mat));
            if (removeItems && i < toolPartsIn.size() && !((ItemStack)toolPartsIn.get(i)).func_190926_b()) {
                ((ItemStack)toolPartsIn.get(i)).func_190918_g(1);
            }
            return true;
        });
        TinkersItem tinkersItem = (TinkersItem)toolStack.func_77973_b();
        ItemStack copyToCheck = tinkersItem.buildItem(TinkerUtil.getMaterialsFromTagList(materialList));
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList(toolStack);
        for (int i3 = 0; i3 < modifiers.func_74745_c(); ++i3) {
            String id = modifiers.func_150307_f(i3);
            IModifier mod = TinkerRegistry.getModifier(id);
            if (mod == null || mod.canApply(copyToCheck, copyToCheck)) continue;
            throw new TinkerGuiException();
        }
        ItemStack output = toolStack.func_77946_l();
        TagUtil.setBaseMaterialsTagList(output, materialList);
        NBTTagCompound tag = TagUtil.getTagSafe(output);
        ToolBuilder.rebuildTool(tag, (TinkersItem)output.func_77973_b());
        output.func_77982_d(tag);
        if (output.func_77952_i() > output.func_77958_k()) {
            String error = I18n.func_74837_a((String)"gui.error.not_enough_durability", (Object[])new Object[]{output.func_77952_i() - output.func_77958_k()});
            throw new TinkerGuiException(error);
        }
        return output;
    }

    public static NonNullList<ItemStack> tryBuildToolPart(ItemStack pattern, NonNullList<ItemStack> materialItems, boolean removeItems) throws TinkerGuiException {
        Item itemPart = Pattern.getPartFromTag(pattern);
        if (itemPart == null || !(itemPart instanceof MaterialItem) || !(itemPart instanceof IToolPart)) {
            String error = I18n.func_74837_a((String)"gui.error.invalid_pattern", (Object[])new Object[0]);
            throw new TinkerGuiException(error);
        }
        IToolPart part = (IToolPart)itemPart;
        if (!removeItems) {
            materialItems = Util.deepCopyFixedNonNullList(materialItems);
        }
        Optional match = Optional.empty();
        Material foundMaterial = null;
        for (Material material : TinkerRegistry.getAllMaterials()) {
            Optional newMatch;
            if (!material.isCraftable() || !(newMatch = material.matches(materialItems, part.getCost())).isPresent() || match.isPresent()) continue;
            match = newMatch;
            foundMaterial = material;
        }
        if (!match.isPresent()) {
            return null;
        }
        ItemStack output = ((MaterialItem)itemPart).getItemstackWithMaterial(foundMaterial);
        if (output.func_190926_b()) {
            return null;
        }
        if (output.func_77973_b() instanceof IToolPart && !((IToolPart)output.func_77973_b()).canUseMaterial(foundMaterial)) {
            return null;
        }
        RecipeMatch.removeMatch(materialItems, (RecipeMatch.Match)((RecipeMatch.Match)match.get()));
        ItemStack secondary = ItemStack.field_190927_a;
        int leftover = (((RecipeMatch.Match)match.get()).amount - part.getCost()) / 72;
        if (leftover > 0) {
            secondary = TinkerRegistry.getShard(foundMaterial);
            secondary.func_190920_e(leftover);
        }
        return ListUtil.getListFrom(output, secondary);
    }

    public static void rebuildTool(NBTTagCompound rootNBT, TinkersItem tinkersItem) throws TinkerGuiException {
        boolean broken = TagUtil.getToolTag(rootNBT).func_74767_n("Broken");
        NBTTagList materialTag = TagUtil.getBaseMaterialsTagList(rootNBT);
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(materialTag);
        List<PartMaterialType> pms = tinkersItem.getRequiredComponents();
        while (materials.size() < pms.size()) {
            materials.add(Material.UNKNOWN);
        }
        for (int i = 0; i < pms.size(); ++i) {
            if (pms.get(i).isValidMaterial(materials.get(i))) continue;
            materials.set(i, Material.UNKNOWN);
        }
        NBTTagCompound toolTag = tinkersItem.buildTag(materials);
        TagUtil.setToolTag(rootNBT, toolTag);
        rootNBT.func_74782_a("StatsOriginal", (NBTBase)toolTag.func_74737_b());
        NBTTagList modifiersTagOld = TagUtil.getModifiersTagList(rootNBT);
        rootNBT.func_82580_o("Modifiers");
        rootNBT.func_74782_a("Modifiers", (NBTBase)new NBTTagList());
        rootNBT.func_82580_o("ench");
        rootNBT.func_82580_o("EnchantEffect");
        rootNBT.func_82580_o("Traits");
        tinkersItem.addMaterialTraits(rootNBT, materials);
        TinkerEvent.OnItemBuilding.fireEvent(rootNBT, (ImmutableList<Material>)ImmutableList.copyOf(materials), tinkersItem);
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList(rootNBT);
        NBTTagList modifiersTag = TagUtil.getModifiersTagList(rootNBT);
        for (int i = 0; i < modifiers.func_74745_c(); ++i) {
            String identifier = modifiers.func_150307_f(i);
            IModifier modifier = TinkerRegistry.getModifier(identifier);
            if (modifier == null) {
                log.debug("Missing modifier: {}", new Object[]{identifier});
                continue;
            }
            int index = TinkerUtil.getIndexInList(modifiersTagOld, modifier.getIdentifier());
            NBTTagCompound tag = index >= 0 ? modifiersTagOld.func_150305_b(index) : new NBTTagCompound();
            modifier.applyEffect(rootNBT, tag);
            if (tag.func_82582_d()) continue;
            int indexNew = TinkerUtil.getIndexInList(modifiersTag, modifier.getIdentifier());
            if (indexNew >= 0) {
                modifiersTag.func_150304_a(indexNew, (NBTBase)tag);
                continue;
            }
            modifiersTag.func_74742_a((NBTBase)tag);
        }
        toolTag = TagUtil.getToolTag(rootNBT);
        int freeModifiers = toolTag.func_74762_e("FreeModifiers");
        toolTag.func_74768_a("FreeModifiers", Math.max(0, freeModifiers -= TagUtil.getBaseModifiersUsed(rootNBT)));
        if (broken) {
            toolTag.func_74757_a("Broken", true);
        }
        TagUtil.setToolTag(rootNBT, toolTag);
        if (freeModifiers < 0) {
            throw new TinkerGuiException(Util.translateFormatted("gui.error.not_enough_modifiers", -freeModifiers));
        }
    }

    public static short getEnchantmentLevel(NBTTagCompound rootTag, Enchantment enchantment) {
        NBTTagList enchantments = rootTag.func_150295_c("ench", 10);
        int id = Enchantment.func_185258_b((Enchantment)enchantment);
        for (int i = 0; i < enchantments.func_74745_c(); ++i) {
            if (enchantments.func_150305_b(i).func_74765_d("id") != id) continue;
            return enchantments.func_150305_b(i).func_74765_d("lvl");
        }
        return 0;
    }

    public static void addEnchantment(NBTTagCompound rootTag, Enchantment enchantment) {
        NBTTagList enchantments = rootTag.func_150295_c("ench", 10);
        NBTTagCompound enchTag = new NBTTagCompound();
        int enchId = Enchantment.func_185258_b((Enchantment)enchantment);
        int id = -1;
        for (int i = 0; i < enchantments.func_74745_c(); ++i) {
            if (enchantments.func_150305_b(i).func_74765_d("id") != enchId) continue;
            enchTag = enchantments.func_150305_b(i);
            id = i;
            break;
        }
        int level = enchTag.func_74765_d("lvl") + 1;
        level = Math.min(level, enchantment.func_77325_b());
        enchTag.func_74777_a("id", (short)enchId);
        enchTag.func_74777_a("lvl", (short)level);
        if (id < 0) {
            enchantments.func_74742_a((NBTBase)enchTag);
        } else {
            enchantments.func_150304_a(id, (NBTBase)enchTag);
        }
        rootTag.func_74782_a("ench", (NBTBase)enchantments);
    }
}

