/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tools.ToolNBT;

public final class TagUtil {
    public static int TAG_TYPE_STRING = new NBTTagString().func_74732_a();
    public static int TAG_TYPE_COMPOUND = new NBTTagCompound().func_74732_a();

    private TagUtil() {
    }

    public static NBTTagCompound getTagSafe(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || !stack.func_77942_o()) {
            return new NBTTagCompound();
        }
        return stack.func_77978_p();
    }

    public static NBTTagCompound getTagSafe(NBTTagCompound tag, String key) {
        if (tag == null || !tag.func_74764_b(key)) {
            return new NBTTagCompound();
        }
        return tag.func_74775_l(key);
    }

    public static NBTTagList getTagListSafe(NBTTagCompound tag, String key, int type) {
        if (tag == null || !tag.func_74764_b(key)) {
            return new NBTTagList();
        }
        return tag.func_150295_c(key, type);
    }

    public static NBTTagCompound getBaseTag(ItemStack stack) {
        return TagUtil.getBaseTag(TagUtil.getTagSafe(stack));
    }

    public static NBTTagCompound getBaseTag(NBTTagCompound root) {
        return TagUtil.getTagSafe(root, "TinkerData");
    }

    public static void setBaseTag(ItemStack stack, NBTTagCompound tag) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setBaseTag(root, tag);
        stack.func_77982_d(root);
    }

    public static void setBaseTag(NBTTagCompound root, NBTTagCompound tag) {
        if (root != null) {
            root.func_74782_a("TinkerData", (NBTBase)tag);
        }
    }

    public static NBTTagList getBaseModifiersTagList(ItemStack stack) {
        return TagUtil.getBaseModifiersTagList(TagUtil.getTagSafe(stack));
    }

    public static NBTTagList getBaseModifiersTagList(NBTTagCompound root) {
        return TagUtil.getTagListSafe(TagUtil.getBaseTag(root), "Modifiers", TAG_TYPE_STRING);
    }

    public static void setBaseModifiersTagList(ItemStack stack, NBTTagList tagList) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setBaseModifiersTagList(root, tagList);
        stack.func_77982_d(root);
    }

    public static void setBaseModifiersTagList(NBTTagCompound root, NBTTagList tagList) {
        NBTTagCompound baseTag = TagUtil.getBaseTag(root);
        baseTag.func_74782_a("Modifiers", (NBTBase)tagList);
        TagUtil.setBaseTag(root, baseTag);
    }

    public static NBTTagList getBaseMaterialsTagList(ItemStack stack) {
        return TagUtil.getBaseMaterialsTagList(TagUtil.getTagSafe(stack));
    }

    public static NBTTagList getBaseMaterialsTagList(NBTTagCompound root) {
        return TagUtil.getTagListSafe(TagUtil.getBaseTag(root), "Materials", TAG_TYPE_STRING);
    }

    public static void setBaseMaterialsTagList(ItemStack stack, NBTTagList tagList) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setBaseMaterialsTagList(root, tagList);
        stack.func_77982_d(root);
    }

    public static void setBaseMaterialsTagList(NBTTagCompound root, NBTTagList tagList) {
        TagUtil.getBaseTag(root).func_74782_a("Materials", (NBTBase)tagList);
    }

    public static int getBaseModifiersUsed(NBTTagCompound root) {
        return TagUtil.getBaseTag(root).func_74762_e("UsedModifiers");
    }

    public static void setBaseModifiersUsed(NBTTagCompound root, int count) {
        TagUtil.getBaseTag(root).func_74768_a("UsedModifiers", count);
    }

    public static NBTTagCompound getToolTag(ItemStack stack) {
        return TagUtil.getToolTag(TagUtil.getTagSafe(stack));
    }

    public static NBTTagCompound getToolTag(NBTTagCompound root) {
        return TagUtil.getTagSafe(root, "Stats");
    }

    public static void setToolTag(ItemStack stack, NBTTagCompound tag) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setToolTag(root, tag);
        stack.func_77982_d(root);
    }

    public static void setToolTag(NBTTagCompound root, NBTTagCompound tag) {
        if (root != null) {
            root.func_74782_a("Stats", (NBTBase)tag);
        }
    }

    public static NBTTagList getModifiersTagList(ItemStack stack) {
        return TagUtil.getModifiersTagList(TagUtil.getTagSafe(stack));
    }

    public static NBTTagList getModifiersTagList(NBTTagCompound root) {
        return TagUtil.getTagListSafe(root, "Modifiers", TAG_TYPE_COMPOUND);
    }

    public static void setModifiersTagList(ItemStack stack, NBTTagList tagList) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setModifiersTagList(root, tagList);
        stack.func_77982_d(root);
    }

    public static void setModifiersTagList(NBTTagCompound root, NBTTagList tagList) {
        if (root != null) {
            root.func_74782_a("Modifiers", (NBTBase)tagList);
        }
    }

    public static NBTTagList getTraitsTagList(ItemStack stack) {
        return TagUtil.getTraitsTagList(TagUtil.getTagSafe(stack));
    }

    public static NBTTagList getTraitsTagList(NBTTagCompound root) {
        return TagUtil.getTagListSafe(root, "Traits", TAG_TYPE_STRING);
    }

    public static void setTraitsTagList(ItemStack stack, NBTTagList tagList) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setTraitsTagList(root, tagList);
        stack.func_77982_d(root);
    }

    public static void setTraitsTagList(NBTTagCompound root, NBTTagList tagList) {
        if (root != null) {
            root.func_74782_a("Traits", (NBTBase)tagList);
        }
    }

    public static ToolNBT getToolStats(ItemStack stack) {
        return TagUtil.getToolStats(TagUtil.getTagSafe(stack));
    }

    public static ToolNBT getToolStats(NBTTagCompound root) {
        return new ToolNBT(TagUtil.getToolTag(root));
    }

    public static ToolNBT getOriginalToolStats(ItemStack stack) {
        return TagUtil.getOriginalToolStats(TagUtil.getTagSafe(stack));
    }

    public static ToolNBT getOriginalToolStats(NBTTagCompound root) {
        return new ToolNBT(TagUtil.getTagSafe(root, "StatsOriginal"));
    }

    public static NBTTagCompound getExtraTag(ItemStack stack) {
        return TagUtil.getExtraTag(TagUtil.getTagSafe(stack));
    }

    public static NBTTagCompound getExtraTag(NBTTagCompound root) {
        return TagUtil.getTagSafe(root, "Special");
    }

    public static void setExtraTag(ItemStack stack, NBTTagCompound tag) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setExtraTag(root, tag);
        stack.func_77982_d(root);
    }

    public static void setExtraTag(NBTTagCompound root, NBTTagCompound tag) {
        root.func_74782_a("Special", (NBTBase)tag);
    }

    public static Category[] getCategories(NBTTagCompound root) {
        NBTTagList categories = TagUtil.getTagListSafe(TagUtil.getExtraTag(root), "Categories", 8);
        Category[] out = new Category[categories.func_74745_c()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = Category.categories.get(categories.func_150307_f(i));
        }
        return out;
    }

    public static void setCategories(ItemStack stack, Category[] categories) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setCategories(root, categories);
        stack.func_77982_d(root);
    }

    public static void setCategories(NBTTagCompound root, Category[] categories) {
        NBTTagList list = new NBTTagList();
        for (Category category : categories) {
            list.func_74742_a((NBTBase)new NBTTagString(category.name));
        }
        NBTTagCompound extra = TagUtil.getExtraTag(root);
        extra.func_74782_a("Categories", (NBTBase)list);
        TagUtil.setExtraTag(root, extra);
    }

    public static void setEnchantEffect(ItemStack stack, boolean active) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        TagUtil.setEnchantEffect(root, active);
        stack.func_77982_d(root);
    }

    public static void setEnchantEffect(NBTTagCompound root, boolean active) {
        if (active) {
            root.func_74757_a("EnchantEffect", true);
        } else {
            root.func_82580_o("EnchantEffect");
        }
    }

    public static boolean hasEnchantEffect(ItemStack stack) {
        return TagUtil.hasEnchantEffect(TagUtil.getTagSafe(stack));
    }

    public static boolean hasEnchantEffect(NBTTagCompound root) {
        return root.func_74767_n("EnchantEffect");
    }

    public static void setResetFlag(ItemStack stack, boolean active) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        root.func_74757_a("ResetFlag", active);
        stack.func_77982_d(root);
    }

    public static boolean getResetFlag(ItemStack stack) {
        return TagUtil.getTagSafe(stack).func_74767_n("ResetFlag");
    }

    public static NBTTagCompound writePos(BlockPos pos) {
        NBTTagCompound tag = new NBTTagCompound();
        if (pos != null) {
            tag.func_74768_a("X", pos.func_177958_n());
            tag.func_74768_a("Y", pos.func_177956_o());
            tag.func_74768_a("Z", pos.func_177952_p());
        }
        return tag;
    }

    public static BlockPos readPos(NBTTagCompound tag) {
        if (tag != null) {
            return new BlockPos(tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"));
        }
        return null;
    }
}

