/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import slimeknights.tconstruct.library.client.deserializer.ItemCameraTransformsDeserializer;
import slimeknights.tconstruct.library.client.deserializer.ItemTransformVec3fDeserializer;
import slimeknights.tconstruct.library.client.model.format.AmmoPosition;
import slimeknights.tconstruct.library.client.model.format.ModelTextureDeserializer;
import slimeknights.tconstruct.library.client.model.format.Offset;
import slimeknights.tconstruct.library.client.model.format.ToolModelOverride;
import slimeknights.tconstruct.library.client.model.format.TransformDeserializer;
import slimeknights.tconstruct.shared.client.BakedColoredItemModel;

@SideOnly(value=Side.CLIENT)
public class ModelHelper
extends slimeknights.mantle.client.ModelHelper {
    public static final EnumFacing[] MODEL_SIDES = new EnumFacing[]{null, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ModelTextureDeserializer.TYPE, (Object)ModelTextureDeserializer.INSTANCE).registerTypeAdapter(Offset.OffsetDeserializer.TYPE, (Object)Offset.OffsetDeserializer.INSTANCE).registerTypeAdapter(TransformDeserializer.TYPE, (Object)TransformDeserializer.INSTANCE).registerTypeAdapter(ItemCameraTransforms.class, (Object)ItemCameraTransformsDeserializer.INSTANCE).registerTypeAdapter(ItemTransformVec3f.class, (Object)ItemTransformVec3fDeserializer.INSTANCE).registerTypeAdapter(ToolModelOverride.ToolModelOverrideListDeserializer.TYPE, (Object)ToolModelOverride.ToolModelOverrideListDeserializer.INSTANCE).registerTypeAdapter(AmmoPosition.AmmoPositionDeserializer.TYPE, (Object)AmmoPosition.AmmoPositionDeserializer.INSTANCE).create();

    public static IBakedModel getBakedModelForItem(ItemStack stack, World world, EntityLivingBase entity) {
        Object model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, world, entity);
        model = model == null || model.func_188618_c() ? Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a() : new BakedColoredItemModel(stack, (IBakedModel)model);
        return model;
    }

    public static Reader getReaderForResource(ResourceLocation location) throws IOException {
        return ModelHelper.getReaderForResource(location, Minecraft.func_71410_x().func_110442_L());
    }

    public static Reader getReaderForResource(ResourceLocation location, IResourceManager resourceManager) throws IOException {
        ResourceLocation file = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json");
        IResource iresource = resourceManager.func_110536_a(file);
        return new BufferedReader(new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8));
    }

    public static Map<String, String> loadTexturesFromJson(ResourceLocation location) throws IOException {
        Reader reader = ModelHelper.getReaderForResource(location);
        try {
            Map map = (Map)GSON.fromJson(reader, ModelTextureDeserializer.TYPE);
            return map;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static Offset loadOffsetFromJson(ResourceLocation location) throws IOException {
        Reader reader = ModelHelper.getReaderForResource(location);
        try {
            Offset offset = (Offset)GSON.fromJson(reader, Offset.OffsetDeserializer.TYPE);
            return offset;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static AmmoPosition loadAmmoPositionFromJson(ResourceLocation location) throws IOException {
        Reader reader = ModelHelper.getReaderForResource(location);
        try {
            AmmoPosition ammoPosition = (AmmoPosition)GSON.fromJson(reader, AmmoPosition.AmmoPositionDeserializer.TYPE);
            return ammoPosition;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static ImmutableList<ToolModelOverride> loadToolModelOverridesFromJson(ResourceLocation location) throws IOException {
        Reader reader = ModelHelper.getReaderForResource(location);
        try {
            ImmutableList immutableList = (ImmutableList)GSON.fromJson(reader, ToolModelOverride.ToolModelOverrideListDeserializer.TYPE);
            return immutableList;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> loadTransformFromJson(ResourceLocation location) throws IOException {
        return ModelHelper.loadTransformFromJson(location, "display");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> loadTransformFromJson(ResourceLocation location, String tag) throws IOException {
        Reader reader = ModelHelper.getReaderForResource(location);
        try {
            TransformDeserializer.tag = tag;
            ImmutableMap transforms = (ImmutableMap)GSON.fromJson(reader, TransformDeserializer.TYPE);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : transforms.entrySet()) {
                if (((TRSRTransformation)entry.getValue()).equals((Object)TRSRTransformation.identity())) continue;
                builder.put(entry.getKey(), entry.getValue());
            }
            UnmodifiableIterator unmodifiableIterator = builder.build();
            return unmodifiableIterator;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> loadTransformFromJsonBackup(ResourceLocation location) throws IOException {
        Reader reader = ModelHelper.getReaderForResource(location);
        try {
            ModelBlock modelBlock = ModelBlock.func_178307_a((Reader)reader);
            ItemCameraTransforms itemCameraTransforms = modelBlock.func_181682_g();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
                if (itemCameraTransforms.func_181688_b(type) == ItemTransformVec3f.field_178366_a) continue;
                builder.put((Object)type, (Object)new TRSRTransformation(itemCameraTransforms.func_181688_b(type)));
            }
            ImmutableMap immutableMap = builder.build();
            return immutableMap;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(IPerspectiveAwareModel model) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation transformation = new TRSRTransformation((Matrix4f)model.handlePerspective(type).getRight());
            if (transformation.equals((Object)TRSRTransformation.identity())) continue;
            builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)transformation));
        }
        return builder.build();
    }

    public static ImmutableList<ResourceLocation> loadTextureListFromJson(ResourceLocation location) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String s : ModelHelper.loadTexturesFromJson(location).values()) {
            builder.add((Object)new ResourceLocation(s));
        }
        return builder.build();
    }

    public static Float[] loadLayerRotations(ResourceLocation location) throws IOException {
        JsonReader reader = new JsonReader(ModelHelper.getReaderForResource(location));
        try {
            reader.beginObject();
            while (reader.hasNext()) {
                if ("layerrotation".equals(reader.nextName())) {
                    Float[] floatArray = (Float[])GSON.fromJson(reader, Float[].class);
                    return floatArray;
                }
                reader.skipValue();
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
        return new Float[0];
    }

    public static ResourceLocation getModelLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json");
    }
}

