/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;

public class MaterialIntegration {
    public Material material;
    public Fluid fluid;
    public String oreSuffix;
    public String[] oreRequirement;
    public String representativeItem;
    private boolean integrated;
    private boolean toolforge = false;

    public MaterialIntegration(Material material) {
        this(material, null);
    }

    public MaterialIntegration(Material material, Fluid fluid) {
        this(null, material, fluid, null);
    }

    public MaterialIntegration(Material material, Fluid fluid, String oreSuffix) {
        this("ingot" + oreSuffix, material, fluid, oreSuffix);
    }

    public MaterialIntegration(String oreRequirement, Material material, Fluid fluid, String oreSuffix) {
        this(material, fluid, oreSuffix, oreRequirement);
    }

    public MaterialIntegration(Material material, Fluid fluid, String oreSuffix, String ... oreRequirement) {
        this.material = material;
        this.fluid = fluid;
        this.oreSuffix = oreSuffix;
        this.representativeItem = "ingot" + oreSuffix;
        this.oreRequirement = oreRequirement[0] == null ? new String[]{} : oreRequirement;
        this.integrated = false;
    }

    public MaterialIntegration toolforge() {
        this.toolforge = true;
        return this;
    }

    public MaterialIntegration setRepresentativeItem(String representativeItem) {
        this.representativeItem = representativeItem;
        return this;
    }

    public boolean isIntegrated() {
        return this.integrated;
    }

    public void integrate() {
        if (this.integrated) {
            return;
        }
        if (this.oreRequirement != null && this.oreRequirement.length > 0 && !Config.forceRegisterAll) {
            int found = 0;
            for (String ore : OreDictionary.getOreNames()) {
                for (int i = 0; !(i >= this.oreRequirement.length || this.oreRequirement[i].equals(ore) && ++found == this.oreRequirement.length); ++i) {
                }
            }
            if (found < this.oreRequirement.length) {
                return;
            }
        }
        this.integrated = true;
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            this.fluid = null;
        }
        if (this.fluid != null) {
            Fluid registeredFluid = FluidRegistry.getFluid((String)this.fluid.getName());
            if (registeredFluid == this.fluid && this.fluid.getBlock() == null) {
                this.registerFluidBlock();
            }
            if (!FluidRegistry.getBucketFluids().contains(registeredFluid)) {
                FluidRegistry.addBucketForFluid((Fluid)registeredFluid);
            }
        }
        if (this.material != null) {
            TinkerRegistry.addMaterial(this.material);
            if (this.fluid != null) {
                this.material.setFluid(this.fluid);
                this.material.setCastable(true);
            } else {
                this.material.setCraftable(true);
            }
        }
        if (this.toolforge && this.oreSuffix != null && !this.oreSuffix.isEmpty()) {
            TinkerTools.registerToolForgeBlock("block" + this.oreSuffix);
        }
    }

    public void integrateRecipes() {
        if (!this.integrated) {
            return;
        }
        if (this.fluid != null && this.oreSuffix != null) {
            TinkerSmeltery.registerOredictMeltingCasting(this.fluid, this.oreSuffix);
        }
        if (this.material != null) {
            TinkerSmeltery.registerToolpartMeltingCasting(this.material);
        }
    }

    public void registerRepresentativeItem() {
        NonNullList ore;
        if (this.material != null && this.material.getRepresentativeItem().func_190926_b() && this.representativeItem != null && !this.representativeItem.isEmpty() && !(ore = OreDictionary.getOres((String)this.representativeItem, (boolean)false)).isEmpty()) {
            ItemStack itemStack = ((ItemStack)ore.get(0)).func_77946_l();
            if (itemStack.func_77960_j() == Short.MAX_VALUE) {
                itemStack.func_77964_b(0);
            }
            this.material.setRepresentativeItem(itemStack);
        }
    }

    public void registerFluidBlock() {
        TinkerFluids.registerMoltenBlock(this.fluid);
        TinkerFluids.proxy.registerFluidModels(this.fluid);
    }
}

