/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.debug;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.harvest.TinkerHarvestTools;
import slimeknights.tconstruct.tools.melee.TinkerMeleeWeapons;

public class CompareVanilla
extends CommandBase {
    public int func_82362_a() {
        return 0;
    }

    public String func_71517_b() {
        return "compareVanilla";
    }

    public String func_71518_a(ICommandSender sender) {
        return "";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        ImmutableList woodMaterials = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.wood));
        ImmutableList stoneMaterials = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.stone), (Object)((Object)TinkerMaterials.stone));
        ImmutableList ironMaterials = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.iron), (Object)((Object)TinkerMaterials.iron));
        ImmutableList cobaltMaterials = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.cobalt), (Object)((Object)TinkerMaterials.cobalt));
        ImmutableList manyMaterials = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.manyullyn), (Object)((Object)TinkerMaterials.manyullyn));
        ItemStack wood = TinkerHarvestTools.pickaxe.buildItem((List<Material>)woodMaterials);
        ItemStack stone = TinkerHarvestTools.pickaxe.buildItem((List<Material>)stoneMaterials);
        ItemStack iron = TinkerHarvestTools.pickaxe.buildItem((List<Material>)ironMaterials);
        ItemStack extra = TinkerHarvestTools.pickaxe.buildItem((List<Material>)cobaltMaterials);
        this.testTools(Blocks.field_150347_e, wood, stone, iron, extra, new ItemStack(Items.field_151039_o), new ItemStack(Items.field_151050_s), new ItemStack(Items.field_151035_b), new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151005_D));
        wood = TinkerHarvestTools.shovel.buildItem((List<Material>)woodMaterials);
        stone = TinkerHarvestTools.shovel.buildItem((List<Material>)stoneMaterials);
        iron = TinkerHarvestTools.shovel.buildItem((List<Material>)ironMaterials);
        extra = TinkerHarvestTools.shovel.buildItem((List<Material>)cobaltMaterials);
        this.testTools(Blocks.field_150346_d, wood, stone, iron, extra, new ItemStack(Items.field_151038_n), new ItemStack(Items.field_151051_r), new ItemStack(Items.field_151037_a), new ItemStack(Items.field_151047_v), new ItemStack(Items.field_151011_C));
        wood = TinkerHarvestTools.hatchet.buildItem((List<Material>)woodMaterials);
        stone = TinkerHarvestTools.hatchet.buildItem((List<Material>)stoneMaterials);
        iron = TinkerHarvestTools.hatchet.buildItem((List<Material>)ironMaterials);
        extra = TinkerHarvestTools.hatchet.buildItem((List<Material>)cobaltMaterials);
        this.testTools(Blocks.field_150364_r, wood, stone, iron, extra, new ItemStack(Items.field_151053_p), new ItemStack(Items.field_151049_t), new ItemStack(Items.field_151036_c), new ItemStack(Items.field_151056_x), new ItemStack(Items.field_151006_E));
        wood = TinkerMeleeWeapons.broadSword.buildItem((List<Material>)woodMaterials);
        stone = TinkerMeleeWeapons.broadSword.buildItem((List<Material>)stoneMaterials);
        iron = TinkerMeleeWeapons.broadSword.buildItem((List<Material>)ironMaterials);
        extra = TinkerMeleeWeapons.broadSword.buildItem((List<Material>)manyMaterials);
        this.testTools(Blocks.field_150440_ba, wood, stone, iron, extra, new ItemStack(Items.field_151041_m), new ItemStack(Items.field_151052_q), new ItemStack(Items.field_151040_l), new ItemStack(Items.field_151048_u), new ItemStack(Items.field_151010_B));
    }

    protected void testTools(Block block, ItemStack wood, ItemStack stone, ItemStack iron, ItemStack extra1, ItemStack vanillaWood, ItemStack vanillaStone, ItemStack vanillaIron, ItemStack vanillaDiamond, ItemStack vanillaGold) {
        PrintWriter pw;
        File file = new File("test/" + wood.func_77973_b().getClass().getSimpleName() + ".html");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            pw = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        pw.println("<html>");
        pw.println("<head>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<table border=\"1\">");
        pw.println(this.genSection("Wood", "#806517"));
        this.performToolTests(pw, block, wood, vanillaWood);
        pw.println(this.genSection("Stone", "#837E7C"));
        this.performToolTests(pw, block, stone, vanillaStone);
        pw.println(this.genSection("Iron", "#CECECE"));
        this.performToolTests(pw, block, iron, vanillaIron);
        pw.println(this.genSection("Diamond", "#5CB3FF"));
        this.performToolTests(pw, block, extra1, vanillaDiamond);
        pw.println(this.genSection("Gold", "#EAC117"));
        this.performToolTests(pw, block, extra1, vanillaGold);
        pw.println("</table>");
        pw.println("</body>");
        pw.println("<html>");
        pw.close();
    }

    protected void performToolTests(PrintWriter pw, Block block, ItemStack tinker, ItemStack vanilla) {
        pw.println(this.genHeader("", tinker.func_82833_r(), vanilla.func_82833_r()));
        pw.println(this.genSection("Unmodified", ""));
        pw.println(this.testTool(block, tinker, vanilla));
        pw.println(this.genSection("Haste/Efficiency V", ""));
        ItemStack tinkerModified = this.applyModifier(TinkerModifiers.modHaste, tinker);
        ItemStack vanillaModified = this.applyEnchantment(Enchantments.field_185305_q, vanilla);
        pw.println(this.testToolSpeed(block, tinkerModified, vanillaModified));
        pw.println(this.genSection("Sharpness V", ""));
        tinkerModified = this.applyModifier(TinkerModifiers.modSharpness, tinker);
        vanillaModified = this.applyEnchantment(Enchantments.field_185302_k, vanilla);
        pw.println(this.testToolAttack(tinkerModified, vanillaModified));
    }

    protected ItemStack applyModifier(IModifier modifier, ItemStack tool) {
        tool = tool.func_77946_l();
        try {
            while (modifier.canApply(tool, tool)) {
                modifier.apply(tool);
            }
        }
        catch (TinkerGuiException tinkerGuiException) {
            // empty catch block
        }
        try {
            ToolBuilder.rebuildTool(tool.func_77978_p(), (TinkersItem)tool.func_77973_b());
        }
        catch (TinkerGuiException tinkerGuiException) {
            // empty catch block
        }
        return tool;
    }

    protected ItemStack applyEnchantment(Enchantment enchantment, ItemStack tool) {
        tool = tool.func_77946_l();
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < enchantment.func_77325_b(); ++i) {
            ToolBuilder.addEnchantment(tag, enchantment);
        }
        tool.func_77982_d(tag);
        return tool;
    }

    protected String testTool(Block block, ItemStack tinker, ItemStack vanilla) {
        return this.testToolDurability(tinker, vanilla) + this.testToolSpeed(block, tinker, vanilla) + this.testToolAttack(tinker, vanilla);
    }

    protected String testToolDurability(ItemStack tinker, ItemStack vanilla) {
        int durability1 = tinker.func_77958_k();
        int durability2 = vanilla.func_77958_k();
        return this.genRow("Durability", durability1, durability2);
    }

    protected String testToolSpeed(Block block, ItemStack tinker, ItemStack vanilla) {
        IBlockState state = block.func_176223_P();
        float speed1 = tinker.func_77973_b().func_150893_a(tinker, state);
        float speed2 = vanilla.func_77973_b().func_150893_a(vanilla, state);
        int efficiencyLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)vanilla);
        if (efficiencyLevel > 0) {
            speed2 += (float)(efficiencyLevel * efficiencyLevel + 1);
        }
        return this.genRow("Speed", Float.valueOf(speed1), Float.valueOf(speed2));
    }

    protected String testToolAttack(ItemStack tinker, ItemStack vanilla) {
        float attack1 = ToolHelper.getActualDamage(tinker, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        float attack2 = 1.0f;
        for (AttributeModifier mod : vanilla.func_77973_b().getAttributeModifiers(EntityEquipmentSlot.MAINHAND, vanilla).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
            attack2 = (float)((double)attack2 + mod.func_111164_d());
        }
        return this.genRow("Attack", Float.valueOf(attack1), Float.valueOf(attack2 += EnchantmentHelper.func_152377_a((ItemStack)vanilla, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED)));
    }

    private String genHeader(String desc, Object v1, Object v2) {
        return "<tr><th>" + desc + "</th><th>" + v1 + "</th><th>" + v2 + "</th></tr>";
    }

    private String genSection(String desc, String color) {
        return "<tr><td colspan=\"3\" align=\"center\" bgcolor=\"" + color + "\">" + desc + "</td></tr>";
    }

    private String genRow(String desc, Number v1, Number v2) {
        Number max = v1.floatValue() > v2.floatValue() ? (Number)v1 : (Number)v2;
        String c1 = Integer.toHexString(this.floatToCol(v1.floatValue() / max.floatValue()));
        String c2 = Integer.toHexString(this.floatToCol(v2.floatValue() / max.floatValue()));
        return "<tr><td bgcolor=\"lightgray\">" + desc + "</td><td bgcolor=\"" + c1 + "\">" + v1 + "</td><td bgcolor=\"" + c2 + "\">" + v2 + "</td></tr>";
    }

    private int floatToCol(float f) {
        return Color.HSBtoRGB(f / 3.0f, 0.65f, 0.8f) & 0xFFFFFF;
    }
}

