/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import slimeknights.mantle.block.BlockStairsBase;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.block.EnumBlockSlab;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.item.ItemBlockSlab;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.Util;

public abstract class TinkerPulse {
    protected static boolean isToolsLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerTools");
    }

    protected static boolean isSmelteryLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");
    }

    protected static boolean isWorldLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerWorld");
    }

    protected static boolean isGadgetsLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerGadgets");
    }

    protected static boolean isChiselPluginLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("chiselIntegration");
    }

    protected static <T extends Item> T registerItem(T item, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", name));
        }
        item.func_77655_b(Util.prefix(name));
        item.setRegistryName(Util.getResource(name));
        GameRegistry.register(item);
        return item;
    }

    protected static <T extends Block> T registerBlock(T block, String name) {
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        TinkerPulse.registerBlock(block, (ItemBlock)itemBlock, name);
        return block;
    }

    protected static <T extends EnumBlock<?>> T registerEnumBlock(T block, String name) {
        TinkerPulse.registerBlock(block, (ItemBlock)new ItemBlockMeta(block), name);
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends EnumBlockSlab<?>> T registerEnumBlockSlab(T block, String name) {
        TinkerPulse.registerBlock(block, (ItemBlock)new ItemBlockSlab(block), name);
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockStairsBase registerBlockStairsFrom(EnumBlock<E> block, E value, String name) {
        return TinkerPulse.registerBlock(new BlockStairsBase(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    protected static <T extends Block> T registerBlock(ItemBlock itemBlock, String name) {
        Block block = itemBlock.func_179223_d();
        return (T)TinkerPulse.registerBlock(block, itemBlock, name);
    }

    protected static <T extends Block> T registerBlock(T block, String name, IProperty<?> property) {
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        TinkerPulse.registerBlock(block, (ItemBlock)itemBlock, name);
        ItemBlockMeta.setMappingProperty(block, property);
        return block;
    }

    protected static <T extends Block> T registerBlock(T block, ItemBlock itemBlock, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        block.func_149663_c(prefixedName);
        itemBlock.func_77655_b(prefixedName);
        TinkerPulse.register(block, name);
        TinkerPulse.register(itemBlock, name);
        return block;
    }

    protected static <T extends Block> T registerBlockNoItem(T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        block.func_149663_c(prefixedName);
        TinkerPulse.register(block, name);
        return block;
    }

    protected static <T extends IForgeRegistryEntry<?>> T register(T thing, String name) {
        thing.setRegistryName(Util.getResource(name));
        GameRegistry.register(thing);
        return thing;
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! TE: %s", name));
        }
        GameRegistry.registerTileEntity(teClazz, (String)Util.prefix(name));
    }

    protected static void addSlabRecipe(ItemStack slab, ItemStack input) {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(slab.func_77973_b(), 6, slab.func_77952_i()), (Object[])new Object[]{"BBB", Character.valueOf('B'), input});
    }

    protected static void addStairRecipe(Block stairs, ItemStack input) {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(stairs, 4, 0), (Object[])new Object[]{"B  ", "BB ", "BBB", Character.valueOf('B'), input});
    }

    protected static void addBrickRecipe(Block block, EnumBlock.IEnumMeta out, EnumBlock.IEnumMeta in) {
        ItemStack brickBlockIn = new ItemStack(block, 1, in.getMeta());
        ItemStack brickBlockOut = new ItemStack(block, 1, out.getMeta());
        GameRegistry.addShapelessRecipe((ItemStack)brickBlockOut, (Object[])new Object[]{brickBlockIn});
    }
}

