/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import org.objectweb.asm.Type;

public class ModContainerFactory {
    public static Map<Type, Constructor<? extends ModContainer>> modTypes = Maps.newHashMap();
    private static Pattern modClass = Pattern.compile(".*(\\.|)(mod\\_[^\\s$]+)$");
    private static ModContainerFactory INSTANCE = new ModContainerFactory();

    private ModContainerFactory() {
        this.registerContainerType(Type.getType(Mod.class), FMLModContainer.class);
    }

    public static ModContainerFactory instance() {
        return INSTANCE;
    }

    public void registerContainerType(Type type, Class<? extends ModContainer> container) {
        try {
            Constructor<? extends ModContainer> constructor = container.getConstructor(String.class, ModCandidate.class, Map.class);
            modTypes.put(type, constructor);
        }
        catch (Exception e2) {
            FMLLog.log.error("Critical error : cannot register mod container type {}, it has an invalid constructor", new Object[]{container.getName(), e2});
            Throwables.propagate((Throwable)e2);
        }
    }

    @Nullable
    public ModContainer build(ASMModParser modParser, File modSource, ModCandidate container) {
        String className = modParser.getASMType().getClassName();
        if (modParser.isBaseMod(container.getRememberedBaseMods()) && modClass.matcher(className).find()) {
            FMLLog.log.fatal("Found a BaseMod type mod {}", new Object[]{className});
            FMLLog.log.fatal("This will not be loaded and will be ignored. ModLoader mechanisms are no longer available.");
        } else if (modClass.matcher(className).find()) {
            FMLLog.log.debug("Identified a class {} following modloader naming convention but not directly a BaseMod or currently seen subclass", new Object[]{className});
            container.rememberModCandidateType(modParser);
        } else if (modParser.isBaseMod(container.getRememberedBaseMods())) {
            FMLLog.log.debug("Found a basemod {} of non-standard naming format", new Object[]{className});
            container.rememberBaseModType(className);
        }
        for (ModAnnotation ann2 : modParser.getAnnotations()) {
            if (!modTypes.containsKey(ann2.getASMType())) continue;
            FMLLog.log.debug("Identified a mod of type {} ({}) - loading", new Object[]{ann2.getASMType(), className});
            try {
                ModContainer ret = modTypes.get(ann2.getASMType()).newInstance(className, container, ann2.getValues());
                if (!ret.shouldLoadInEnvironment()) {
                    FMLLog.log.debug("Skipping mod {}, container opted to not load.", new Object[]{className});
                    return null;
                }
                return ret;
            }
            catch (Exception e2) {
                FMLLog.log.error("Unable to construct {} container", new Object[]{ann2.getASMType().getClassName(), e2});
                return null;
            }
        }
        return null;
    }
}

