/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.render.shapes;

import com.github.hexosse.wecuife.render.LineColour;
import com.github.hexosse.wecuife.render.LineInfo;
import com.github.hexosse.wecuife.render.points.PointCube;
import com.github.hexosse.wecuife.util.Vector3;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class RenderCylinderCircles {
    protected LineColour colour;
    protected double radX = 0.0;
    protected double radZ = 0.0;
    protected int minY;
    protected int maxY;
    protected double centreX;
    protected double centreZ;

    public RenderCylinderCircles(LineColour colour, PointCube centre, double radX, double radZ, int minY, int maxY) {
        this.colour = colour;
        this.radX = radX;
        this.radZ = radZ;
        this.minY = minY;
        this.maxY = maxY;
        this.centreX = centre.getPoint().getX() + 0.5;
        this.centreZ = centre.getPoint().getZ() + 0.5;
    }

    public void render(Vector3 cameraPos) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        double xPos = this.centreX - cameraPos.getX();
        double zPos = this.centreZ - cameraPos.getZ();
        for (LineInfo tempColour : this.colour.getColours()) {
            tempColour.prepareRender();
            double twoPi = Math.PI * 2;
            for (int yBlock = this.minY + 1; yBlock <= this.maxY; ++yBlock) {
                vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                tempColour.prepareColour();
                for (int i = 0; i <= 75; ++i) {
                    double tempTheta = (double)i * twoPi / 75.0;
                    double tempX = this.radX * Math.cos(tempTheta);
                    double tempZ = this.radZ * Math.sin(tempTheta);
                    vertexbuffer.func_181662_b(xPos + tempX, (double)yBlock - cameraPos.getY(), zPos + tempZ).func_181675_d();
                }
                tessellator.func_78381_a();
            }
        }
    }
}

