/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.render.shapes;

import com.github.hexosse.wecuife.render.LineColour;
import com.github.hexosse.wecuife.render.LineInfo;
import com.github.hexosse.wecuife.util.BoundingBox;
import com.github.hexosse.wecuife.util.Vector3;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class Render3DGrid {
    protected LineColour colour;
    protected Vector3 first;
    protected Vector3 second;

    public Render3DGrid(LineColour colour, BoundingBox region) {
        this(colour, region.getMin(), region.getMax());
    }

    public Render3DGrid(LineColour colour, Vector3 first, Vector3 second) {
        this.colour = colour;
        this.first = first;
        this.second = second;
    }

    public void render(Vector3 cameraPos) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        double x1 = this.first.getX() - cameraPos.getX();
        double y1 = this.first.getY() - cameraPos.getY();
        double z1 = this.first.getZ() - cameraPos.getZ();
        double x2 = this.second.getX() - cameraPos.getX();
        double y2 = this.second.getY() - cameraPos.getY();
        double z2 = this.second.getZ() - cameraPos.getZ();
        double cullAt = 128.0;
        for (LineInfo tempColour : this.colour.getColours()) {
            tempColour.prepareRender();
            vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            tempColour.prepareColour();
            double offsetSize = 1.0;
            double yoff = 0.0;
            while (yoff + y1 <= y2) {
                double y = y1 + yoff;
                vertexbuffer.func_181662_b(x1, y, z2).func_181675_d();
                vertexbuffer.func_181662_b(x2, y, z2).func_181675_d();
                vertexbuffer.func_181662_b(x1, y, z1).func_181675_d();
                vertexbuffer.func_181662_b(x2, y, z1).func_181675_d();
                vertexbuffer.func_181662_b(x1, y, z1).func_181675_d();
                vertexbuffer.func_181662_b(x1, y, z2).func_181675_d();
                vertexbuffer.func_181662_b(x2, y, z1).func_181675_d();
                vertexbuffer.func_181662_b(x2, y, z2).func_181675_d();
                yoff += offsetSize;
            }
            double xoff = 0.0;
            while (xoff + x1 <= x2) {
                double x = x1 + xoff;
                if (!(x < -cullAt)) {
                    if (x > cullAt) break;
                    vertexbuffer.func_181662_b(x, y1, z1).func_181675_d();
                    vertexbuffer.func_181662_b(x, y2, z1).func_181675_d();
                    vertexbuffer.func_181662_b(x, y1, z2).func_181675_d();
                    vertexbuffer.func_181662_b(x, y2, z2).func_181675_d();
                    vertexbuffer.func_181662_b(x, y2, z1).func_181675_d();
                    vertexbuffer.func_181662_b(x, y2, z2).func_181675_d();
                    vertexbuffer.func_181662_b(x, y1, z1).func_181675_d();
                    vertexbuffer.func_181662_b(x, y1, z2).func_181675_d();
                }
                xoff += offsetSize;
            }
            double zoff = 0.0;
            while (zoff + z1 <= z2) {
                double z = z1 + zoff;
                if (!(z < -cullAt)) {
                    if (z > cullAt) break;
                    vertexbuffer.func_181662_b(x1, y1, z).func_181675_d();
                    vertexbuffer.func_181662_b(x2, y1, z).func_181675_d();
                    vertexbuffer.func_181662_b(x1, y2, z).func_181675_d();
                    vertexbuffer.func_181662_b(x2, y2, z).func_181675_d();
                    vertexbuffer.func_181662_b(x2, y1, z).func_181675_d();
                    vertexbuffer.func_181662_b(x2, y2, z).func_181675_d();
                    vertexbuffer.func_181662_b(x1, y1, z).func_181675_d();
                    vertexbuffer.func_181662_b(x1, y2, z).func_181675_d();
                }
                zoff += offsetSize;
            }
            tessellator.func_78381_a();
        }
    }
}

