/*
 * Decompiled with CFR 0.152.
 */
package com.github.hexosse.wecuife.common.debug;

import com.github.hexosse.wecuife.CUIController;
import com.github.hexosse.wecuife.exceptions.InitialisationException;
import com.github.hexosse.wecuife.util.ConsoleLogFormatter;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;

public class CUIDebug {
    protected File debugFile;
    protected boolean debugMode = false;
    protected static final Logger logger = Logger.getLogger("worldeditcuife");

    public void initialise() throws InitialisationException {
        ConsoleLogFormatter formatter = new ConsoleLogFormatter();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(formatter);
        logger.setUseParentHandlers(false);
        logger.addHandler(handler);
        try {
            this.debugFile = new File(Minecraft.func_71410_x().field_71412_D.toString() + "/" + "worldeditcuife" + ".debug.log");
            this.debugMode = CUIController.isDebugMode();
            if (this.debugMode) {
                FileHandler newHandler = new FileHandler(this.debugFile.getAbsolutePath());
                newHandler.setFormatter(formatter);
                logger.addHandler(newHandler);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new InitialisationException();
        }
    }

    public void debug(String message) {
        if (this.debugMode) {
            logger.info("worldeditcuife Debug - " + message);
        }
    }

    public void info(String message) {
        logger.info(message);
    }

    public void info(String message, Throwable e) {
        logger.log(Level.INFO, message, e);
    }
}

