/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widgets.buttons;

import mcp.mobius.waila.gui.events.MouseEvent;
import mcp.mobius.waila.gui.helpers.UIHelper;
import mcp.mobius.waila.gui.interfaces.IWidget;
import mcp.mobius.waila.gui.interfaces.Signal;
import mcp.mobius.waila.gui.widgets.LabelFixedFont;
import mcp.mobius.waila.gui.widgets.WidgetBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Point;

public abstract class ButtonBase
extends WidgetBase {
    protected boolean mouseOver = false;
    protected static ResourceLocation widgetsTexture = new ResourceLocation("textures/gui/widgets.png");

    public ButtonBase(IWidget parent) {
        super(parent);
    }

    @Override
    public void draw() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (IWidget widget : this.widgets.values()) {
            if (!(widget instanceof LabelFixedFont)) continue;
            if (this.mouseOver) {
                ((LabelFixedFont)widget).setColor(0xFFFFA0);
                continue;
            }
            ((LabelFixedFont)widget).setColor(0xFFFFFF);
        }
        super.draw();
    }

    @Override
    public void draw(Point pos) {
        this.saveGLState();
        int texOffset = 0;
        if (this.mouseOver) {
            texOffset = 1;
        }
        this.mc.func_110434_K().func_110577_a(widgetsTexture);
        UIHelper.drawTexture(this.getPos().getX(), this.getPos().getY(), this.getSize().getX(), this.getSize().getY(), 0, 66 + texOffset * 20, 200, 20);
        this.loadGLState();
    }

    @Override
    public void onMouseEnter(MouseEvent event) {
        this.mouseOver = true;
    }

    @Override
    public void onMouseLeave(MouseEvent event) {
        this.mouseOver = false;
    }

    @Override
    public IWidget getWidgetAtCoordinates(double posX, double posY) {
        return this;
    }

    @Override
    public void onMouseClick(MouseEvent event) {
        if (event.button == 0) {
            this.emit(Signal.CLICKED, event.button);
        }
    }
}

