/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFTreeGenerator;
import twilightforest.world.TFWorld;

public class TFGenLargeWinter
extends TFTreeGenerator {
    public TFGenLargeWinter() {
        this(false);
    }

    public TFGenLargeWinter(boolean par1) {
        super(par1);
        this.treeState = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE);
        this.branchState = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.leafState = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE);
        this.rootState = TFBlocks.root.func_176223_P();
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        Block blockUnder;
        int treeHeight = 35;
        if (random.nextInt(3) == 0) {
            treeHeight += random.nextInt(10);
            if (random.nextInt(8) == 0) {
                treeHeight += random.nextInt(10);
            }
        }
        if ((blockUnder = world.func_180495_p(pos.func_177977_b()).func_177230_c()) != Blocks.field_150349_c && blockUnder != Blocks.field_150346_d || pos.func_177956_o() >= TFWorld.MAXHEIGHT - treeHeight) {
            return false;
        }
        this.buildTrunk(world, pos, treeHeight);
        this.makeLeaves(world, pos, treeHeight);
        int numRoots = 4 + random.nextInt(3);
        float offset = random.nextFloat();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, pos, offset, b);
        }
        return true;
    }

    private void makeLeaves(World world, BlockPos pos, int treeHeight) {
        int offGround = 3;
        int leafType = 1;
        for (int dy = 0; dy < treeHeight; ++dy) {
            int radius = this.leafRadius(treeHeight, dy, leafType);
            TFGenerator.makeLeafCircle2(this, world, pos.func_177981_b(offGround + treeHeight - dy), radius, this.leafState, false);
            this.makePineBranches(world, pos.func_177981_b(offGround + treeHeight - dy), radius);
        }
    }

    private void makePineBranches(World world, BlockPos pos, int radius) {
        int branchLength = radius > 4 ? radius - 1 : radius - 2;
        switch (pos.func_177956_o() % 2) {
            case 0: {
                for (int i = 1; i <= branchLength; ++i) {
                    this.func_175903_a(world, pos.func_177982_a(-i, 0, 0), this.branchState.func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X));
                    this.func_175903_a(world, pos.func_177982_a(0, 0, i + 1), this.branchState.func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z));
                    this.func_175903_a(world, pos.func_177982_a(i + 1, 0, 1), this.branchState.func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X));
                    this.func_175903_a(world, pos.func_177982_a(1, 0, -i), this.branchState.func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z));
                }
                break;
            }
            case 1: {
                for (int i = 1; i <= branchLength; ++i) {
                    this.func_175903_a(world, pos.func_177982_a(-1, 0, 1), this.branchState.func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X));
                    this.func_175903_a(world, pos.func_177982_a(1, 0, i + 1), this.branchState.func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z));
                    this.func_175903_a(world, pos.func_177982_a(i + 1, 0, 0), this.branchState.func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X));
                    this.func_175903_a(world, pos.func_177982_a(0, 0, -i), this.branchState.func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z));
                }
                break;
            }
        }
    }

    private int leafRadius(int treeHeight, int dy, int functionType) {
        switch (functionType) {
            default: {
                return (dy - 1) % 4;
            }
            case 1: {
                return (int)(4.0f * (float)dy / (float)treeHeight + 0.75f * (float)dy % 3.0f);
            }
            case 99: 
        }
        return (treeHeight - dy / 2 - 1) % 4;
    }

    private void buildTrunk(World world, BlockPos pos, int treeHeight) {
        for (int dy = 0; dy < treeHeight; ++dy) {
            this.func_175903_a(world, pos.func_177982_a(0, dy, 0), this.treeState);
            this.func_175903_a(world, pos.func_177982_a(1, dy, 0), this.treeState);
            this.func_175903_a(world, pos.func_177982_a(0, dy, 1), this.treeState);
            this.func_175903_a(world, pos.func_177982_a(1, dy, 1), this.treeState);
        }
    }
}

