/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFWorld;

public class TFGenCaveStalactite
extends TFGenerator {
    public static TFGenCaveStalactite diamond = new TFGenCaveStalactite(Blocks.field_150482_ag, 0.5f, 4, 16);
    public static TFGenCaveStalactite lapis = new TFGenCaveStalactite(Blocks.field_150369_x, 0.8f, 8, 1);
    public static TFGenCaveStalactite emerald = new TFGenCaveStalactite(Blocks.field_150412_bA, 0.5f, 3, 12);
    public static TFGenCaveStalactite gold = new TFGenCaveStalactite(Blocks.field_150352_o, 0.6f, 6, 1);
    public static TFGenCaveStalactite redstone = new TFGenCaveStalactite(Blocks.field_150450_ax, 0.8f, 8, 1);
    public static TFGenCaveStalactite iron = new TFGenCaveStalactite(Blocks.field_150366_p, 0.7f, 8, 1);
    public static TFGenCaveStalactite coal = new TFGenCaveStalactite(Blocks.field_150365_q, 0.8f, 12, 1);
    public static TFGenCaveStalactite glowstone = new TFGenCaveStalactite(Blocks.field_150426_aN, 0.5f, 8, 1);
    public IBlockState blockID;
    public boolean hang;
    public float sizeFactor;
    public int maxLength;
    public int minHeight;

    public TFGenCaveStalactite(Block blockType, float size, boolean down) {
        this.blockID = blockType.func_176223_P();
        this.sizeFactor = size;
        this.maxLength = -1;
        this.minHeight = -1;
        this.hang = down;
    }

    public TFGenCaveStalactite(Block blockType, float size, int maxLength, int minHeight) {
        this.blockID = blockType.func_176223_P();
        this.sizeFactor = size;
        this.maxLength = maxLength;
        this.minHeight = minHeight;
        this.hang = true;
    }

    public static TFGenCaveStalactite makeRandomOreStalactite(Random rand, int hillSize) {
        int s1;
        if (hillSize >= 3 || hillSize >= 2 && rand.nextInt(5) == 0) {
            int s3 = rand.nextInt(13);
            if (s3 == 0 || s3 == 1) {
                return diamond;
            }
            if (s3 == 2 || s3 == 3) {
                return lapis;
            }
            if (s3 == 4) {
                return emerald;
            }
        }
        if (hillSize >= 2 || hillSize >= 1 && rand.nextInt(5) == 0) {
            int s2 = rand.nextInt(6);
            if (s2 == 0) {
                return gold;
            }
            if (s2 == 1 || s2 == 2) {
                return redstone;
            }
        }
        if ((s1 = rand.nextInt(5)) == 0 || s1 == 1) {
            return iron;
        }
        if (s1 == 2 || s1 == 3) {
            return coal;
        }
        return glowstone;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        Material m;
        int ty;
        int ceiling = Integer.MAX_VALUE;
        int floor = -1;
        BlockPos.MutableBlockPos iterPos = new BlockPos.MutableBlockPos(pos);
        for (ty = pos.func_177956_o(); ty < TFWorld.CHUNKHEIGHT; ++ty) {
            iterPos.func_185336_p(ty);
            m = world.func_180495_p((BlockPos)iterPos).func_185904_a();
            if (m == Material.field_151579_a) continue;
            if (m != Material.field_151578_c && m != Material.field_151576_e) {
                return false;
            }
            ceiling = ty;
            break;
        }
        if (ceiling == Integer.MAX_VALUE) {
            return false;
        }
        for (ty = pos.func_177956_o(); ty > 4; --ty) {
            iterPos.func_185336_p(ty);
            m = world.func_180495_p((BlockPos)iterPos).func_185904_a();
            if (m == Material.field_151579_a) continue;
            if (m != Material.field_151578_c && m != Material.field_151576_e && !this.hang && m != Material.field_151586_h && !this.hang && m != Material.field_151587_i) {
                return false;
            }
            floor = ty;
            break;
        }
        int length = (int)((float)(ceiling - floor) * this.sizeFactor * random.nextFloat());
        if (this.maxLength > -1 && length > this.maxLength) {
            length = this.maxLength;
        }
        if (this.minHeight > -1 && ceiling - floor - length < this.minHeight) {
            return false;
        }
        return this.makeSpike(world, random, new BlockPos(pos.func_177958_n(), this.hang ? ceiling : floor, pos.func_177952_p()), length);
    }

    public boolean makeSpike(World world, Random random, BlockPos pos, int maxLength) {
        int diameter = (int)((double)maxLength / 4.5);
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int dir;
                int absx = Math.abs(dx);
                int absz = Math.abs(dz);
                int dist = (int)((double)Math.max(absx, absz) + (double)Math.min(absx, absz) * 0.5);
                int spikeLength = 0;
                if (dist == 0) {
                    spikeLength = maxLength;
                }
                if (dist > 0) {
                    spikeLength = random.nextInt((int)((double)maxLength / ((double)dist + 0.25)));
                }
                int n = dir = this.hang ? -1 : 1;
                if (!world.func_180495_p(pos.func_177982_a(dx, -dir, dz)).func_185904_a().func_76220_a()) {
                    spikeLength = 0;
                }
                for (int dy = 0; dy != spikeLength * dir; dy += dir) {
                    this.func_175903_a(world, pos.func_177982_a(dx, dy, dz), this.blockID);
                }
            }
        }
        return true;
    }
}

