/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import twilightforest.block.BlockTFLog;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenCanopyTree;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFWorld;

public class TFGenCanopyOak
extends TFGenCanopyTree {
    private List<BlockPos> leaves = Lists.newArrayList();

    public TFGenCanopyOak() {
        this(false);
    }

    public TFGenCanopyOak(boolean par1) {
        super(par1);
        this.treeState = TFBlocks.log.func_176223_P();
        this.branchState = this.treeState.func_177226_a((IProperty)BlockTFLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.leafState = TFBlocks.leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.rootState = TFBlocks.root.func_176223_P();
    }

    @Override
    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        Material materialUnder = world.func_180495_p(pos.func_177977_b()).func_185904_a();
        if (materialUnder != Material.field_151577_b && materialUnder != Material.field_151578_c || pos.func_177956_o() >= TFWorld.MAXHEIGHT - 12) {
            return false;
        }
        int treeHeight = this.minHeight;
        if (random.nextInt(this.chanceAddFirstFive) == 0) {
            treeHeight += random.nextInt(5);
            if (random.nextInt(this.chanceAddSecondFive) == 0) {
                treeHeight += random.nextInt(5);
            }
        }
        this.leaves.clear();
        this.buildTrunk(world, pos, treeHeight);
        int numBranches = 12 + random.nextInt(9);
        float bangle = random.nextFloat();
        for (int b = 0; b < numBranches; ++b) {
            float btilt = 0.15f + random.nextFloat() * 0.35f;
            this.buildBranch(world, pos, treeHeight - 10 + b / 2, 5.0, bangle, btilt, false, random);
            bangle += random.nextFloat() * 0.4f;
            if (!(bangle > 1.0f)) continue;
            bangle -= 1.0f;
        }
        for (BlockPos leafPos : this.leaves) {
            this.makeLeafBlob(world, leafPos);
        }
        this.makeRoots(world, random, pos);
        this.makeRoots(world, random, pos.func_177974_f());
        this.makeRoots(world, random, pos.func_177968_d());
        this.makeRoots(world, random, pos.func_177974_f().func_177968_d());
        return true;
    }

    private void makeLeafBlob(World world, BlockPos leafPos) {
        TFGenerator.drawLeafBlob(this, world, leafPos, 2, this.leafState);
    }

    private void makeRoots(World world, Random random, BlockPos pos) {
        if (TFGenerator.hasAirAround(world, pos.func_177977_b())) {
            this.func_175903_a(world, pos.func_177977_b(), this.treeState);
        } else {
            this.func_175903_a(world, pos.func_177977_b(), this.rootState);
        }
        int numRoots = 1 + random.nextInt(2);
        float offset = random.nextFloat();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, pos, offset, b);
        }
    }

    private void buildTrunk(World world, BlockPos pos, int treeHeight) {
        for (int dy = 0; dy < treeHeight; ++dy) {
            this.func_175903_a(world, pos.func_177982_a(0, dy, 0), this.treeState);
            this.func_175903_a(world, pos.func_177982_a(1, dy, 0), this.treeState);
            this.func_175903_a(world, pos.func_177982_a(0, dy, 1), this.treeState);
            this.func_175903_a(world, pos.func_177982_a(1, dy, 1), this.treeState);
        }
        this.leaves.add(pos.func_177982_a(0, treeHeight, 0));
    }

    @Override
    void buildBranch(World world, BlockPos pos, int height, double length, double angle, double tilt, boolean trunk, Random treeRNG) {
        BlockPos src = pos.func_177981_b(height);
        BlockPos dest = TFGenerator.translate(src, length, angle, tilt);
        int limit = 5;
        if (dest.func_177958_n() - pos.func_177958_n() < -limit) {
            dest = new BlockPos(pos.func_177958_n() - limit, dest.func_177956_o(), dest.func_177952_p());
        }
        if (dest.func_177958_n() - pos.func_177958_n() > limit) {
            dest = new BlockPos(pos.func_177958_n() + limit, dest.func_177956_o(), dest.func_177952_p());
        }
        if (dest.func_177952_p() - pos.func_177952_p() < -limit) {
            dest = new BlockPos(dest.func_177958_n(), dest.func_177956_o(), pos.func_177952_p() - limit);
        }
        if (dest.func_177952_p() - pos.func_177952_p() > limit) {
            dest = new BlockPos(dest.func_177958_n(), dest.func_177956_o(), pos.func_177952_p() + limit);
        }
        TFGenerator.drawBresehnam(this, world, src, dest, trunk ? this.treeState : this.branchState);
        this.func_175903_a(world, dest.func_177974_f(), this.branchState);
        this.func_175903_a(world, dest.func_177976_e(), this.branchState);
        this.func_175903_a(world, dest.func_177978_c(), this.branchState);
        this.func_175903_a(world, dest.func_177968_d(), this.branchState);
        this.leaves.add(dest);
    }
}

