/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.minotaurmaze;

import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.minotaurmaze.ComponentTFMazeUpperEntrance;

public class ComponentTFMazeMound
extends StructureTFComponent {
    public static final int DIAMETER = 35;
    private int averageGroundLevel = -1;
    private ComponentTFMazeUpperEntrance mazeAbove;

    public ComponentTFMazeMound() {
    }

    public ComponentTFMazeMound(int i, Random rand, int x, int y, int z) {
        super(i);
        this.func_186164_a(EnumFacing.field_176754_o[rand.nextInt(4)]);
        this.field_74887_e = new StructureBoundingBox(x, y, z, x + 35, y + 8, z + 35);
    }

    public void func_74861_a(StructureComponent structurecomponent, List list, Random random) {
        super.func_74861_a(structurecomponent, list, random);
        this.mazeAbove = new ComponentTFMazeUpperEntrance(3, random, this.field_74887_e.field_78897_a + 10, this.field_74887_e.field_78895_b + 0, this.field_74887_e.field_78896_c + 10);
        list.add(this.mazeAbove);
        this.mazeAbove.func_74861_a(this, list, random);
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.getAverageGroundLevel(world, sbb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            int offset = this.averageGroundLevel - this.field_74887_e.field_78894_e + 8 - 1;
            this.field_74887_e.func_78886_a(0, offset, 0);
            if (this.mazeAbove != null) {
                this.mazeAbove.func_74874_b().func_78886_a(0, offset, 0);
            }
        }
        for (int x = 0; x < 35; ++x) {
            for (int z = 0; z < 35; ++z) {
                int cx = x - 17;
                int cz = z - 17;
                int dist = (int)Math.sqrt(cx * cx + cz * cz);
                int hheight = (int)(Math.cos((double)dist / 35.0 * Math.PI) * 11.0);
                if (cx <= 2 && cx >= -1 && cz <= 2 && cz >= -1 || (cx <= 2 && cx >= -1 || cz <= 2 && cz >= -1) && hheight <= 6) continue;
                this.func_175811_a(world, Blocks.field_150349_c.func_176223_P(), x, hheight, z, sbb);
                if (!(cx <= 2 && cx >= -1 || cz <= 2 && cz >= -1)) {
                    this.func_175811_a(world, Blocks.field_150346_d.func_176223_P(), x, hheight - 1, z, sbb);
                    continue;
                }
                if (hheight <= 6) continue;
                this.func_175804_a(world, sbb, x, 6, z, x, hheight - 1, z, Blocks.field_150346_d.func_176223_P(), AIR, false);
            }
        }
        return true;
    }

    @Override
    protected int getAverageGroundLevel(World par1World, StructureBoundingBox par2StructureBoundingBox) {
        int totalHeight = 0;
        int totalMeasures = 0;
        for (int var5 = this.field_74887_e.field_78896_c; var5 <= this.field_74887_e.field_78892_f; ++var5) {
            for (int var6 = this.field_74887_e.field_78897_a; var6 <= this.field_74887_e.field_78893_d; ++var6) {
                BlockPos pos = new BlockPos(var6, 64, var5);
                if (!par2StructureBoundingBox.func_175898_b((Vec3i)pos)) continue;
                BlockPos topPos = par1World.func_175672_r(pos);
                totalHeight += Math.max(topPos.func_177956_o(), par1World.field_73011_w.func_76557_i());
                ++totalMeasures;
            }
        }
        if (totalMeasures == 0) {
            return -1;
        }
        return totalHeight / totalMeasures;
    }
}

