/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.hollowtree;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.block.TFBlockProperties;
import twilightforest.block.TFBlocks;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeLargeBranch;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeMedBranch;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeRoot;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeSmallBranch;
import twilightforest.structures.hollowtree.StructureTFTreeComponent;
import twilightforest.world.TFGenerator;

public class ComponentTFHollowTreeTrunk
extends StructureTFTreeComponent {
    int radius;
    int height;
    int groundLevel = -1;

    public ComponentTFHollowTreeTrunk() {
    }

    public ComponentTFHollowTreeTrunk(World world, Random rand, int index, int x, int y, int z) {
        super(index);
        this.height = rand.nextInt(64) + 32;
        this.radius = rand.nextInt(4) + 1;
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(x, y, z, x + this.radius * 2 + 2, y + this.height, z + this.radius * 2 + 2);
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("trunkRadius", this.radius);
        par1NBTTagCompound.func_74768_a("trunkHeight", this.height);
        par1NBTTagCompound.func_74768_a("trunkGroundLevel", this.groundLevel);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound, TemplateManager templateManager) {
        super.func_143011_b(par1NBTTagCompound, templateManager);
        this.radius = par1NBTTagCompound.func_74762_e("trunkRadius");
        this.height = par1NBTTagCompound.func_74762_e("trunkHeight");
        this.groundLevel = par1NBTTagCompound.func_74762_e("trunkGroundLevel");
    }

    public void func_74861_a(StructureComponent structurecomponent, List<StructureComponent> list, Random rand) {
        int index = this.func_74877_c();
        int numBranches = rand.nextInt(3) + 3;
        for (int i = 0; i <= numBranches; ++i) {
            int branchHeight = (int)((double)this.height * rand.nextDouble() * 0.5) + this.height / 10;
            double branchRotation = rand.nextDouble();
            this.makeSmallBranch(list, rand, index + i + 1, branchHeight, 4, branchRotation, 0.35, true);
        }
        this.buildFullCrown(list, rand, index + numBranches + 1);
        this.buildBranchRing(list, rand, index, 3, 2, 6, 0.75, 0.1, 3, 5, BranchSize.ROOT, false);
        this.buildBranchRing(list, rand, index, 1, 2, 8, 0.9, 0.1, 3, 5, BranchSize.ROOT, false);
    }

    protected void buildFullCrown(List<StructureComponent> list, Random rand, int index) {
        int crownRadius = this.radius * 4 + 4;
        int minBranches = this.radius + 3;
        index += this.buildBranchRing(list, rand, index, this.height - crownRadius, 4, crownRadius, 0.35, 0.1, minBranches, minBranches + 2, BranchSize.LARGE, true);
        index += this.buildBranchRing(list, rand, index, this.height - crownRadius / 2, 4, (int)((double)crownRadius * 0.8), 0.25, 0.2, minBranches, minBranches + 2, BranchSize.MEDIUM, true);
        index += this.buildBranchRing(list, rand, index, this.height - 2, 2, crownRadius / 2, 0.05, 0.2, minBranches, minBranches + 2, BranchSize.MEDIUM, true);
    }

    protected int buildBranchRing(List<StructureComponent> list, Random rand, int index, int branchHeight, int heightVar, int length, double tilt, double tiltVar, int minBranches, int maxBranches, BranchSize size, boolean leafy) {
        int numBranches = rand.nextInt(maxBranches - minBranches + 1) + minBranches;
        double rotationPerBranch = 1.0 / (double)numBranches;
        double branchOffset = rand.nextDouble();
        double branchTilt = tilt + rand.nextDouble() * tiltVar;
        for (int i = 0; i < numBranches; ++i) {
            double branchRotation;
            int dHeight = branchHeight - heightVar + (heightVar > 0 ? rand.nextInt(2 * heightVar) : 0);
            BlockPos pos = this.getBranchSrc(dHeight, branchRotation = (double)i * rotationPerBranch + branchOffset);
            StructureTFTreeComponent branch = this.branchFor(index, pos, length, branchRotation, branchTilt, leafy, size);
            if (!this.branchIntersectsDungeon(branch, list)) {
                list.add(branch);
                branch.func_74861_a(this, list, rand);
                continue;
            }
            if (size != BranchSize.LARGE && size != BranchSize.MEDIUM || this.branchIntersectsDungeon(branch = this.branchFor(index, pos, length / 2, branchRotation, branchTilt, leafy, BranchSize.MEDIUM), list)) continue;
            list.add(branch);
            branch.func_74861_a(this, list, rand);
        }
        return numBranches;
    }

    public StructureTFTreeComponent branchFor(int index, BlockPos pos, int branchLength, double branchRotation, double branchAngle, boolean leafy, BranchSize size) {
        switch (size) {
            case LARGE: {
                return new ComponentTFHollowTreeLargeBranch(index, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), branchLength, branchRotation, branchAngle, leafy);
            }
            default: {
                return new ComponentTFHollowTreeSmallBranch(index, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), branchLength, branchRotation, branchAngle, leafy);
            }
            case MEDIUM: {
                return new ComponentTFHollowTreeMedBranch(index, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), branchLength, branchRotation, branchAngle, leafy);
            }
            case ROOT: 
        }
        return new ComponentTFHollowTreeRoot(index, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), branchLength, branchRotation, branchAngle, false);
    }

    public void makeSmallBranch(List<StructureComponent> list, Random rand, int index, int branchHeight, int branchLength, double branchRotation, double branchAngle, boolean leafy) {
        BlockPos bSrc = this.getBranchSrc(branchHeight, branchRotation);
        ComponentTFHollowTreeSmallBranch branch = new ComponentTFHollowTreeSmallBranch(index, bSrc.func_177958_n(), bSrc.func_177956_o(), bSrc.func_177952_p(), branchLength, branchRotation, branchAngle, leafy);
        if (!this.branchIntersectsDungeon(branch, list)) {
            list.add(branch);
            branch.func_74861_a(this, list, rand);
        }
    }

    private BlockPos getBranchSrc(int branchHeight, double branchRotation) {
        return TFGenerator.translate(new BlockPos(this.field_74887_e.field_78897_a + this.radius + 1, this.field_74887_e.field_78895_b + branchHeight, this.field_74887_e.field_78896_c + this.radius + 1), this.radius, branchRotation, 0.5);
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox sbb) {
        return this.addComponentParts(world, random, sbb, false);
    }

    @Override
    public boolean addComponentParts(World world, Random random, StructureBoundingBox sbb, boolean drawLeaves) {
        if (this.groundLevel < 0) {
            this.groundLevel = this.getAverageGroundLevel(world, sbb);
            if (this.groundLevel < 0) {
                return true;
            }
            this.height = this.field_74887_e.field_78894_e - this.groundLevel;
            this.field_74887_e.field_78895_b = this.groundLevel;
        }
        int hollow = this.radius / 2;
        for (int dx = 0; dx <= 2 * this.radius; ++dx) {
            for (int dz = 0; dz <= 2 * this.radius; ++dz) {
                int ax = Math.abs(dx - this.radius);
                int az = Math.abs(dz - this.radius);
                int dist = (int)((double)Math.max(ax, az) + (double)Math.min(ax, az) * 0.5);
                for (int dy = 0; dy <= this.height; ++dy) {
                    if (dist > this.radius || dist <= hollow) continue;
                    this.func_175811_a(world, TFBlocks.log.func_176223_P(), dx + 1, dy, dz + 1, sbb);
                }
                if (dist <= this.radius) {
                    this.func_175808_b(world, TFBlocks.log.func_176223_P(), dx + 1, -1, dz + 1, sbb);
                }
                if (dist != hollow || dx != hollow + this.radius) continue;
                this.func_175808_b(world, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)), dx + 1, this.height, dz + 1, sbb);
            }
        }
        int numInsects = random.nextInt(3 * this.radius) + random.nextInt(3 * this.radius) + 10;
        for (int i = 0; i <= numInsects; ++i) {
            int fHeight = (int)((double)this.height * random.nextDouble() * 0.9) + this.height / 10;
            double fAngle = random.nextDouble();
            this.addInsect(world, fHeight, fAngle, random, sbb);
        }
        return true;
    }

    protected void addInsect(World world, int fHeight, double fAngle, Random random, StructureBoundingBox sbb) {
        BlockPos bugSpot = TFGenerator.translate(new BlockPos(this.radius + 1, fHeight, this.radius + 1), this.radius + 1, fAngle, 0.5);
        EnumFacing insectDirection = EnumFacing.DOWN;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            insectDirection = EnumFacing.SOUTH;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            insectDirection = EnumFacing.EAST;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            insectDirection = EnumFacing.NORTH;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            insectDirection = EnumFacing.WEST;
        }
        IBlockState block = (random.nextBoolean() ? TFBlocks.firefly : TFBlocks.cicada).func_176223_P();
        this.addInsect(world, block.func_177226_a((IProperty)TFBlockProperties.FACING, (Comparable)insectDirection), bugSpot.func_177958_n(), bugSpot.func_177956_o(), bugSpot.func_177952_p(), sbb);
    }

    private void addInsect(World world, IBlockState blockState, int posX, int posY, int posZ, StructureBoundingBox sbb) {
        BlockPos pos = this.getBlockPosWithOffset(posX, posY, posZ);
        IBlockState whatsThere = world.func_180495_p(pos);
        if (sbb.func_175898_b((Vec3i)pos) && whatsThere == AIR && blockState.func_177230_c().func_176196_c(world, pos)) {
            world.func_180501_a(pos, blockState, 2);
        }
    }

    static enum BranchSize {
        SMALL,
        MEDIUM,
        LARGE,
        ROOT;

    }
}

