/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TFTreasure;
import twilightforest.entity.EntityTFFireBeetle;
import twilightforest.entity.EntityTFPinchBeetle;
import twilightforest.entity.EntityTFRedcap;
import twilightforest.entity.EntityTFSlimeBeetle;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.entity.EntityTFWraith;
import twilightforest.structures.StructureTFComponent;
import twilightforest.world.TFGenCaveStalactite;

public class ComponentTFHollowHill
extends StructureTFComponent {
    int hillSize;
    int radius;

    public ComponentTFHollowHill() {
    }

    public ComponentTFHollowHill(World world, Random rand, int i, int size, int x, int y, int z) {
        super(i);
        this.func_186164_a(EnumFacing.SOUTH);
        this.hillSize = size;
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.field_74887_e = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -this.radius, -3, -this.radius, this.radius * 2, 10, this.radius * 2, EnumFacing.SOUTH);
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("hillSize", this.hillSize);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound, TemplateManager templateManager) {
        super.func_143011_b(par1NBTTagCompound, templateManager);
        this.hillSize = par1NBTTagCompound.func_74762_e("hillSize");
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        int[] dest;
        int i;
        int[] sna = new int[]{0, 128, 256, 512};
        int sn = sna[this.hillSize];
        int[] mga = new int[]{0, 1, 4, 9};
        int mg = mga[this.hillSize];
        int[] tca = new int[]{0, 2, 6, 12};
        int tc = tca[this.hillSize];
        for (i = 0; i < mg; ++i) {
            dest = this.getCoordsInHill2D(rand);
            ResourceLocation mobID = this.getMobID(rand);
            this.setSpawner(world, dest[0], rand.nextInt(4), dest[1], sbb, mobID);
        }
        for (i = 0; i < tc; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateTreasureChest(world, dest[0], 0, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateOreStalactite(world, dest[0], 1, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateBlockStalactite(world, Blocks.field_150348_b, 1.0f, true, dest[0], 1, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateBlockStalactite(world, Blocks.field_150348_b, 0.9f, false, dest[0], 1, dest[1], sbb);
        }
        if (this.hillSize == 3) {
            // empty if block
        }
        return true;
    }

    protected void generateTreasureChest(World world, int x, int y, int z, StructureBoundingBox sbb) {
        Random chestRNG = new Random(world.func_72905_C() + (long)(x * z));
        this.placeTreasureAtCurrentPosition(world, chestRNG, x, y, z, this.hillSize == 3 ? TFTreasure.hill3 : (this.hillSize == 2 ? TFTreasure.hill2 : TFTreasure.hill1), sbb);
        this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), x, y - 1, z, sbb);
    }

    protected void generateOreStalactite(World world, int x, int y, int z, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150474_ac) {
            Random stalRNG = new Random(world.func_72905_C() + (long)(dx * dz));
            TFGenCaveStalactite stalag = TFGenCaveStalactite.makeRandomOreStalactite(stalRNG, this.hillSize);
            stalag.func_180709_b(world, stalRNG, pos);
        }
    }

    protected void generateBlockStalactite(World world, Block blockToGenerate, float length, boolean up, int x, int y, int z, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150474_ac) {
            Random stalRNG = new Random(world.func_72905_C() + (long)(dx * dz));
            if (this.hillSize == 1) {
                length *= 1.9f;
            }
            new TFGenCaveStalactite(blockToGenerate, length, up).func_180709_b(world, stalRNG, pos);
        }
    }

    boolean isInHill(int cx, int cz) {
        int dx = this.radius - cx;
        int dz = this.radius - cz;
        int dist = (int)Math.sqrt(dx * dx + dz * dz);
        return dist < this.radius;
    }

    boolean isInHill(int mapX, int mapY, int mapZ) {
        int dx = this.field_74887_e.field_78897_a + this.radius - mapX;
        int dy = (this.field_74887_e.field_78895_b - mapY) * 2;
        int dz = this.field_74887_e.field_78896_c + this.radius - mapZ;
        int dist = dx * dx + dy * dy + dz * dz;
        return dist < this.radius * this.radius;
    }

    int[] getCoordsInHill2D(Random rand) {
        return this.getCoordsInHill2D(rand, this.radius);
    }

    int[] getCoordsInHill2D(Random rand, int rad) {
        int rz;
        int rx;
        while (!this.isInHill(rx = rand.nextInt(2 * rad), rz = rand.nextInt(2 * rad))) {
        }
        int[] coords = new int[]{rx, rz};
        return coords;
    }

    protected ResourceLocation getMobID(Random rand) {
        return this.getMobID(rand, this.hillSize);
    }

    protected ResourceLocation getMobID(Random rand, int level) {
        if (level == 1) {
            return this.getLevel1Mob(rand);
        }
        if (level == 2) {
            return this.getLevel2Mob(rand);
        }
        if (level == 3) {
            return this.getLevel3Mob(rand);
        }
        return EntityList.func_191306_a(EntitySpider.class);
    }

    public ResourceLocation getLevel1Mob(Random rand) {
        switch (rand.nextInt(10)) {
            case 0: 
            case 1: 
            case 2: {
                return EntityList.func_191306_a(EntityTFSwarmSpider.class);
            }
            case 3: 
            case 4: 
            case 5: {
                return EntityList.func_191306_a(EntitySpider.class);
            }
            case 6: 
            case 7: {
                return EntityList.func_191306_a(EntityZombie.class);
            }
            case 8: {
                return EntityList.func_191306_a(EntitySilverfish.class);
            }
            case 9: {
                return EntityList.func_191306_a(EntityTFRedcap.class);
            }
        }
        return EntityList.func_191306_a(EntityTFSwarmSpider.class);
    }

    public ResourceLocation getLevel2Mob(Random rand) {
        switch (rand.nextInt(10)) {
            case 0: 
            case 1: 
            case 2: {
                return EntityList.func_191306_a(EntityTFRedcap.class);
            }
            case 3: 
            case 4: 
            case 5: {
                return EntityList.func_191306_a(EntityZombie.class);
            }
            case 6: 
            case 7: {
                return EntityList.func_191306_a(EntitySkeleton.class);
            }
            case 8: {
                return EntityList.func_191306_a(EntityTFSwarmSpider.class);
            }
            case 9: {
                return EntityList.func_191306_a(EntityCaveSpider.class);
            }
        }
        return EntityList.func_191306_a(EntityTFRedcap.class);
    }

    public ResourceLocation getLevel3Mob(Random rand) {
        switch (rand.nextInt(11)) {
            case 0: {
                return EntityList.func_191306_a(EntityTFSlimeBeetle.class);
            }
            case 1: {
                return EntityList.func_191306_a(EntityTFFireBeetle.class);
            }
            case 2: {
                return EntityList.func_191306_a(EntityTFPinchBeetle.class);
            }
            case 3: 
            case 4: 
            case 5: {
                return EntityList.func_191306_a(EntitySkeleton.class);
            }
            case 6: 
            case 7: 
            case 8: {
                return EntityList.func_191306_a(EntityCaveSpider.class);
            }
            case 9: {
                return EntityList.func_191306_a(EntityCreeper.class);
            }
        }
        return EntityList.func_191306_a(EntityTFWraith.class);
    }
}

