/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import twilightforest.TFMagicMapData;
import twilightforest.item.ItemTFMagicMap;

public class PacketMagicMapFeatures
implements IMessage {
    private int mapID;
    private byte[] featureData;

    public PacketMagicMapFeatures() {
    }

    public PacketMagicMapFeatures(int mapID, byte[] featureData) {
        this.mapID = mapID;
        this.featureData = featureData;
    }

    public void fromBytes(ByteBuf buf) {
        this.mapID = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        int len = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.featureData = new byte[len];
        buf.readBytes(this.featureData);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.mapID, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.featureData.length, (int)5);
        buf.writeBytes(this.featureData);
    }

    public static class Handler
    implements IMessageHandler<PacketMagicMapFeatures, IMessage> {
        public IMessage onMessage(final PacketMagicMapFeatures message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TFMagicMapData mapData = ItemTFMagicMap.loadMapData(message.mapID, (World)Minecraft.func_71410_x().field_71441_e);
                    mapData.deserializeFeatures(message.featureData);
                }
            });
            return null;
        }
    }
}

