/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import twilightforest.TFConfig;
import twilightforest.inventory.InventoryTFGoblinInput;
import twilightforest.inventory.InventoryTFGoblinUncrafting;
import twilightforest.inventory.SlotTFGoblinAssembly;
import twilightforest.inventory.SlotTFGoblinCraftResult;
import twilightforest.inventory.SlotTFGoblinUncrafting;

public class ContainerTFUncrafting
extends Container {
    private InventoryTFGoblinUncrafting uncraftingMatrix = new InventoryTFGoblinUncrafting(this);
    private InventoryCrafting assemblyMatrix = new InventoryCrafting((Container)this, 3, 3);
    private InventoryCrafting combineMatrix = new InventoryCrafting((Container)this, 3, 3);
    private IInventory tinkerInput = new InventoryTFGoblinInput(this);
    private IInventory tinkerResult = new InventoryCraftResult();
    private World world;

    public ContainerTFUncrafting(InventoryPlayer inventory, World world, int x, int y, int z) {
        int invY;
        int invX;
        this.world = world;
        this.func_75146_a(new Slot(this.tinkerInput, 0, 13, 35));
        this.func_75146_a((Slot)new SlotTFGoblinCraftResult(inventory.field_70458_d, this.tinkerInput, this.uncraftingMatrix, (IInventory)this.assemblyMatrix, this.tinkerResult, 0, 147, 35));
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.func_75146_a(new SlotTFGoblinUncrafting(inventory.field_70458_d, this.tinkerInput, this.uncraftingMatrix, (IInventory)this.assemblyMatrix, invY + invX * 3, 300000 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.func_75146_a(new SlotTFGoblinAssembly(inventory.field_70458_d, this.tinkerInput, (IInventory)this.assemblyMatrix, this.uncraftingMatrix, invY + invX * 3, 62 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 9; ++invY) {
                this.func_75146_a(new Slot((IInventory)inventory, invY + invX * 9 + 9, 8 + invY * 18, 84 + invX * 18));
            }
        }
        for (invX = 0; invX < 9; ++invX) {
            this.func_75146_a(new Slot((IInventory)inventory, invX, 8 + invX * 18, 142));
        }
        this.func_75130_a((IInventory)this.assemblyMatrix);
    }

    public void func_75130_a(IInventory par1IInventory) {
        if (par1IInventory == this.tinkerInput) {
            ItemStack inputStack = this.tinkerInput.func_70301_a(0);
            IRecipe recipe = this.getRecipeFor(inputStack);
            if (recipe != null) {
                int i;
                int recipeWidth = this.getRecipeWidth(recipe);
                int recipeHeight = this.getRecipeHeight(recipe);
                ItemStack[] recipeItems = this.getIngredients(recipe);
                for (i = 0; i < this.uncraftingMatrix.func_70302_i_(); ++i) {
                    this.uncraftingMatrix.func_70299_a(i, ItemStack.field_190927_a);
                }
                for (int invY = 0; invY < recipeHeight; ++invY) {
                    for (int invX = 0; invX < recipeWidth; ++invX) {
                        ItemStack ingredient = recipeItems[invX + invY * recipeWidth].func_77946_l();
                        if (!ingredient.func_190926_b() && ingredient.func_190916_E() > 1) {
                            ingredient.func_190920_e(1);
                        }
                        if (!ingredient.func_190926_b() && ingredient.func_77952_i() == Short.MAX_VALUE) {
                            ingredient.func_77964_b(0);
                        }
                        this.uncraftingMatrix.func_70299_a(invX + invY * 3, ingredient);
                    }
                }
                if (inputStack.func_77951_h()) {
                    int damagedParts = this.countDamagedParts(inputStack);
                    for (int i2 = 0; i2 < 9 && damagedParts > 0; ++i2) {
                        if (!this.isDamageableComponent(this.uncraftingMatrix.func_70301_a(i2))) continue;
                        this.uncraftingMatrix.func_70301_a(i2).func_190920_e(0);
                        --damagedParts;
                    }
                }
                for (i = 0; i < 9; ++i) {
                    ItemStack ingredient = this.uncraftingMatrix.func_70301_a(i);
                    if (!this.isIngredientProblematic(ingredient)) continue;
                    ingredient.func_190920_e(0);
                }
                this.uncraftingMatrix.numberOfInputItems = recipe.func_77571_b().func_190916_E();
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
                this.uncraftingMatrix.recraftingCost = 0;
            } else {
                for (int i = 0; i < 9; ++i) {
                    this.uncraftingMatrix.func_70299_a(i, ItemStack.field_190927_a);
                }
                this.uncraftingMatrix.numberOfInputItems = 0;
                this.uncraftingMatrix.uncraftingCost = 0;
            }
        }
        if (par1IInventory == this.assemblyMatrix || par1IInventory == this.tinkerInput) {
            if (this.tinkerInput.func_191420_l()) {
                this.tinkerResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.assemblyMatrix, this.world));
                this.uncraftingMatrix.recraftingCost = 0;
            } else {
                this.tinkerResult.func_70299_a(0, ItemStack.field_190927_a);
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
                this.uncraftingMatrix.recraftingCost = 0;
            }
        }
        if (par1IInventory != this.combineMatrix && !this.uncraftingMatrix.func_191420_l() && !this.assemblyMatrix.func_191420_l()) {
            for (int i = 0; i < 9; ++i) {
                if (!this.assemblyMatrix.func_70301_a(i).func_190926_b()) {
                    this.combineMatrix.func_70299_a(i, this.assemblyMatrix.func_70301_a(i));
                    continue;
                }
                if (!this.uncraftingMatrix.func_70301_a(i).func_190926_b() && this.uncraftingMatrix.func_70301_a(i).func_190916_E() > 0) {
                    this.combineMatrix.func_70299_a(i, this.uncraftingMatrix.func_70301_a(i));
                    continue;
                }
                this.combineMatrix.func_70299_a(i, ItemStack.field_190927_a);
            }
            ItemStack result = CraftingManager.func_77594_a().func_82787_a(this.combineMatrix, this.world);
            ItemStack input = this.tinkerInput.func_70301_a(0);
            if (!result.func_190926_b() && this.isValidMatchForInput(input, result)) {
                NBTTagCompound inputTags = null;
                if (input.func_77978_p() != null) {
                    inputTags = input.func_77978_p().func_74737_b();
                }
                Map resultInnateEnchantments = EnchantmentHelper.func_82781_a((ItemStack)result);
                Map inputEnchantments = EnchantmentHelper.func_82781_a((ItemStack)input);
                inputEnchantments.keySet().removeIf(enchantment -> !enchantment.func_92089_a(result));
                if (inputTags != null) {
                    inputTags.func_82580_o("ench");
                    result.func_77982_d(inputTags);
                    EnchantmentHelper.func_82782_a((Map)inputEnchantments, (ItemStack)result);
                }
                this.tinkerResult.func_70299_a(0, result);
                this.uncraftingMatrix.uncraftingCost = 0;
                this.uncraftingMatrix.recraftingCost = this.calculateRecraftingCost();
                if (this.uncraftingMatrix.recraftingCost > 0 && !result.func_82837_s()) {
                    result.func_82841_c(input.func_82838_A() + 2);
                }
                for (Enchantment ench : resultInnateEnchantments.keySet()) {
                    int level = (Integer)resultInnateEnchantments.get(ench);
                    if (EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)result) > level) {
                        level = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)result);
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)result) >= level) continue;
                    result.func_77966_a(ench, level);
                }
            }
        }
    }

    private boolean isIngredientProblematic(ItemStack ingredient) {
        return !ingredient.func_190926_b() && (ingredient.func_77973_b().hasContainerItem(ingredient) || ingredient.func_77977_a().contains("itemMatter"));
    }

    private IRecipe getRecipeFor(ItemStack inputStack) {
        if (!inputStack.func_190926_b()) {
            for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
                if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe) || recipe.func_77571_b().func_77973_b() != inputStack.func_77973_b() || inputStack.func_190916_E() < recipe.func_77571_b().func_190916_E() || recipe.func_77571_b().func_77981_g() && recipe.func_77571_b().func_77952_i() != inputStack.func_77952_i()) continue;
                return recipe;
            }
        }
        return null;
    }

    private boolean isValidMatchForInput(ItemStack inputStack, ItemStack resultStack) {
        if (inputStack.func_77973_b() instanceof ItemPickaxe && resultStack.func_77973_b() instanceof ItemPickaxe) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemAxe && resultStack.func_77973_b() instanceof ItemAxe) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemSpade && resultStack.func_77973_b() instanceof ItemSpade) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemHoe && resultStack.func_77973_b() instanceof ItemHoe) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemSword && resultStack.func_77973_b() instanceof ItemSword) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemBow && resultStack.func_77973_b() instanceof ItemBow) {
            return true;
        }
        if (inputStack.func_77973_b() instanceof ItemArmor && resultStack.func_77973_b() instanceof ItemArmor) {
            ItemArmor inputArmor = (ItemArmor)inputStack.func_77973_b();
            ItemArmor resultArmor = (ItemArmor)resultStack.func_77973_b();
            return inputArmor.field_77881_a == resultArmor.field_77881_a;
        }
        return false;
    }

    public int getUncraftingCost() {
        return this.uncraftingMatrix.uncraftingCost;
    }

    public int getRecraftingCost() {
        return this.uncraftingMatrix.recraftingCost;
    }

    private int calculateUncraftingCost() {
        if (!this.assemblyMatrix.func_191420_l()) {
            return 0;
        }
        return this.countDamageableParts(this.uncraftingMatrix);
    }

    private int calculateRecraftingCost() {
        if (this.tinkerInput.func_70301_a(0).func_190926_b() || !this.tinkerInput.func_70301_a(0).func_77948_v() || this.tinkerResult.func_70301_a(0).func_190926_b()) {
            return 0;
        }
        ItemStack input = this.tinkerInput.func_70301_a(0);
        ItemStack output = this.tinkerResult.func_70301_a(0);
        int cost = 0;
        cost += input.func_82838_A();
        int enchantCost = this.countTotalEnchantmentCost(input);
        cost += enchantCost;
        int damagedCost = (1 + this.countDamagedParts(input)) * EnchantmentHelper.func_82781_a((ItemStack)output).size();
        cost += damagedCost;
        int enchantabilityDifference = input.func_77973_b().func_77619_b() - output.func_77973_b().func_77619_b();
        cost += enchantabilityDifference;
        cost = Math.max(1, cost);
        return cost;
    }

    public int countHighestEnchantmentCost(ItemStack itemStack) {
        int count = 0;
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            int level = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)itemStack);
            if (level <= count) continue;
            count += this.getWeightModifier(ench) * level;
        }
        return count;
    }

    private int countTotalEnchantmentCost(ItemStack itemStack) {
        int count = 0;
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            int level = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)itemStack);
            if (level <= 0) continue;
            count += this.getWeightModifier(ench) * level;
            ++count;
        }
        return count;
    }

    private int getWeightModifier(Enchantment ench) {
        switch (ench.func_77324_c().func_185270_a()) {
            case 1: {
                return 8;
            }
            case 2: {
                return 4;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
        }
        return 1;
    }

    public ItemStack func_184996_a(int slotNum, int mouseButton, ClickType shiftHeld, EntityPlayer par4EntityPlayer) {
        if (slotNum > 0 && par4EntityPlayer.field_71071_by.func_70445_o().func_190926_b() && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.assemblyMatrix && !((Slot)this.field_75151_b.get(slotNum)).func_75216_d() && this.assemblyMatrix.func_191420_l()) {
            slotNum -= 9;
        }
        if (slotNum > 0 && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.tinkerResult && this.calculateRecraftingCost() > par4EntityPlayer.field_71068_ca && !par4EntityPlayer.field_71075_bZ.field_75098_d) {
            return ItemStack.field_190927_a;
        }
        if (slotNum > 0 && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.uncraftingMatrix && this.calculateUncraftingCost() > par4EntityPlayer.field_71068_ca && !par4EntityPlayer.field_71075_bZ.field_75098_d) {
            return ItemStack.field_190927_a;
        }
        if (slotNum > 0 && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.uncraftingMatrix && TFConfig.disableUncrafting) {
            return ItemStack.field_190927_a;
        }
        if (slotNum > 0 && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.uncraftingMatrix && ((Slot)this.field_75151_b.get(slotNum)).func_75211_c().func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = super.func_184996_a(slotNum, mouseButton, shiftHeld, par4EntityPlayer);
        if (slotNum > 0 && ((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c instanceof InventoryTFGoblinInput) {
            this.func_75130_a(this.tinkerInput);
        }
        return ret;
    }

    protected void func_75133_b(int slotNum, int mouseButton, boolean par3, EntityPlayer par4EntityPlayer) {
        if (((Slot)this.field_75151_b.get((int)slotNum)).field_75224_c == this.uncraftingMatrix) {
            slotNum += 9;
        }
        this.func_184996_a(slotNum, mouseButton, ClickType.QUICK_MOVE, par4EntityPlayer);
    }

    private boolean isDamageableComponent(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_77973_b() != Items.field_151055_y;
    }

    private int countDamageableParts(IInventory matrix) {
        int count = 0;
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            if (!this.isDamageableComponent(matrix.func_70301_a(i))) continue;
            ++count;
        }
        return count;
    }

    private int countDamagedParts(ItemStack input) {
        int totalMax4 = Math.max(4, this.countDamageableParts(this.uncraftingMatrix));
        float damage = (float)input.func_77952_i() / (float)input.func_77958_k();
        int damagedParts = (int)Math.ceil((float)totalMax4 * damage);
        return damagedParts;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        ItemStack copyItem = ItemStack.field_190927_a;
        Slot transferSlot = (Slot)this.field_75151_b.get(slotNum);
        if (transferSlot != null && transferSlot.func_75216_d()) {
            ItemStack transferStack = transferSlot.func_75211_c();
            copyItem = transferStack.func_77946_l();
            if (slotNum == 0 || slotNum == 1) {
                if (!this.func_75135_a(transferStack, 20, 56, true)) {
                    return ItemStack.field_190927_a;
                }
                transferSlot.func_75220_a(transferStack, copyItem);
            } else if (slotNum >= 20 && slotNum < 47 ? !this.func_75135_a(transferStack, 47, 56, false) : (slotNum >= 47 && slotNum < 56 ? !this.func_75135_a(transferStack, 20, 47, false) : !this.func_75135_a(transferStack, 20, 56, false))) {
                return ItemStack.field_190927_a;
            }
            if (transferStack.func_190916_E() == 0) {
                transferSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                transferSlot.func_75218_e();
            }
            if (transferStack.func_190916_E() == copyItem.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            return transferSlot.func_190901_a(player, transferStack);
        }
        return copyItem;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.world.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                ItemStack assemblyStack = this.assemblyMatrix.func_70304_b(i);
                if (assemblyStack.func_190926_b()) continue;
                player.func_71019_a(assemblyStack, false);
            }
            ItemStack inputStack = this.tinkerInput.func_70304_b(0);
            if (!inputStack.func_190926_b()) {
                player.func_71019_a(inputStack, false);
            }
        }
    }

    private ItemStack[] getIngredients(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return ((ShapedRecipes)recipe).field_77574_d;
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.getIngredientsOre((ShapedOreRecipe)recipe);
        }
        return null;
    }

    private ItemStack[] getIngredientsOre(ShapedOreRecipe shaped) {
        try {
            Object[] objects = (Object[])ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (String[])new String[]{"input"});
            Object[] items = new ItemStack[objects.length];
            Arrays.fill(items, ItemStack.field_190927_a);
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] instanceof ItemStack) {
                    items[i] = (ItemStack)objects[i];
                }
                if (!(objects[i] instanceof ArrayList) || ((ArrayList)objects[i]).size() <= 0) continue;
                items[i] = (ItemStack)((ArrayList)objects[i]).get(0);
            }
            return items;
        }
        catch (IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    private int getRecipeWidth(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return ((ShapedRecipes)recipe).field_77576_b;
        }
        if (recipe instanceof ShapedOreRecipe) {
            return ((ShapedOreRecipe)recipe).getWidth();
        }
        return -1;
    }

    private int getRecipeHeight(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return ((ShapedRecipes)recipe).field_77577_c;
        }
        if (recipe instanceof ShapedOreRecipe) {
            return ((ShapedOreRecipe)recipe).getHeight();
        }
        return -1;
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }
}

