/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFSounds;
import twilightforest.entity.ai.EntityAITFBirdFly;
import twilightforest.entity.passive.EntityTFBird;

public class EntityTFTinyBird
extends EntityTFBird {
    private static final DataParameter<Byte> DATA_BIRDTYPE = EntityDataManager.func_187226_a(EntityTFTinyBird.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> DATA_BIRDFLAGS = EntityDataManager.func_187226_a(EntityTFTinyBird.class, (DataSerializer)DataSerializers.field_187191_a);
    private BlockPos spawnPosition;
    private int currentFlightTime;

    public EntityTFTinyBird(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 0.9f);
        this.setBirdType(this.field_70146_Z.nextInt(4));
        this.setIsBirdLanded(true);
    }

    protected void func_184651_r() {
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAITFBirdFly(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_151014_N, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_BIRDTYPE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_BIRDFLAGS, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.20000001192092895);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("BirdType", this.getBirdType());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setBirdType(par1NBTTagCompound.func_74762_e("BirdType"));
    }

    public int getBirdType() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_BIRDTYPE)).byteValue();
    }

    public void setBirdType(int par1) {
        this.field_70180_af.func_187227_b(DATA_BIRDTYPE, (Object)((byte)par1));
    }

    protected SoundEvent func_184639_G() {
        return TFSounds.TINYBIRD_CHIRP;
    }

    protected SoundEvent func_184601_bQ() {
        return TFSounds.TINYBIRD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFSounds.TINYBIRD_HURT;
    }

    public float func_70603_bj() {
        return 0.3f;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public float func_180484_a(BlockPos pos) {
        Material underMaterial = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a();
        if (underMaterial == Material.field_151584_j) {
            return 200.0f;
        }
        if (underMaterial == Material.field_151575_d) {
            return 15.0f;
        }
        if (underMaterial == Material.field_151577_b) {
            return 9.0f;
        }
        return this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76364_f() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.func_76364_f()).func_71029_a((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.isBirdLanded()) {
            this.field_70181_x *= (double)0.6f;
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.isBirdLanded()) {
            this.currentFlightTime = 0;
            if (this.field_70146_Z.nextInt(200) == 0 && !this.isLandableBlock(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v))) {
                this.setIsBirdLanded(false);
                this.field_70170_p.func_175718_b(1025, new BlockPos((Entity)this), 0);
                this.field_70181_x = 0.4;
            } else if (this.isSpooked()) {
                this.setIsBirdLanded(false);
                this.field_70170_p.func_175718_b(1025, new BlockPos((Entity)this), 0);
                this.field_70181_x = 0.4;
            }
        } else {
            ++this.currentFlightTime;
            if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_177954_c((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v)) < 4.0) {
                int yTarget = this.currentFlightTime < 100 ? 2 : 4;
                this.spawnPosition = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - yTarget, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
            }
            double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
            double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.field_70163_u;
            double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(d0) * 0.5 - this.field_70159_w) * (double)0.1f;
            this.field_70181_x += (Math.signum(d1) * (double)0.7f - this.field_70181_x) * (double)0.1f;
            this.field_70179_y += (Math.signum(d2) * 0.5 - this.field_70179_y) * (double)0.1f;
            float f = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_70701_bs = 0.5f;
            this.field_70177_z += f1;
            if (this.field_70146_Z.nextInt(100) == 0 && this.isLandableBlock(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v))) {
                this.setIsBirdLanded(true);
                this.field_70181_x = 0.0;
            }
        }
    }

    public boolean isSpooked() {
        EntityPlayer closestPlayer = this.field_70170_p.func_72890_a((Entity)this, 4.0);
        return this.field_70737_aN > 0 || closestPlayer != null && (closestPlayer.field_71071_by.func_70448_g() == null || closestPlayer.field_71071_by.func_70448_g().func_77973_b() != Items.field_151014_N);
    }

    public boolean isLandableBlock(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return false;
        }
        return block.isLeaves(state, (IBlockAccess)this.field_70170_p, pos) || state.isSideSolid((IBlockAccess)this.field_70170_p, pos, EnumFacing.UP);
    }

    @Override
    public boolean isBirdLanded() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_BIRDFLAGS) & 1) != 0;
    }

    public void setIsBirdLanded(boolean par1) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_BIRDFLAGS);
        if (par1) {
            this.field_70180_af.func_187227_b(DATA_BIRDFLAGS, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(DATA_BIRDFLAGS, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity par1Entity) {
    }

    protected void func_85033_bc() {
    }
}

