/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.entity.ai.EntityAITFEatLoose;
import twilightforest.entity.ai.EntityAITFFindLoose;
import twilightforest.item.TFItems;

public class EntityTFQuestRam
extends EntityAnimal {
    private static final DataParameter<Integer> DATA_COLOR = EntityDataManager.func_187226_a(EntityTFQuestRam.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_REWARDED = EntityDataManager.func_187226_a(EntityTFQuestRam.class, (DataSerializer)DataSerializers.field_187198_h);
    private int randomTickDivider;

    public EntityTFQuestRam(World par1World) {
        super(par1World);
        this.func_70105_a(1.25f, 2.9f);
        this.randomTickDivider = 0;
    }

    protected void func_184651_r() {
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, (double)1.38f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Item.func_150898_a((Block)Blocks.field_150325_L), false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITFEatLoose(this, Item.func_150898_a((Block)Blocks.field_150325_L)));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITFFindLoose(this, 1.0f, Item.func_150898_a((Block)Blocks.field_150325_L)));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public EntityAnimal createChild(EntityAgeable entityanimal) {
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(70.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(DATA_REWARDED, (Object)false);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70619_bc() {
        if (--this.randomTickDivider <= 0) {
            int chunkZ;
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            int chunkX = MathHelper.func_76128_c((double)this.field_70165_t) / 16;
            TFFeature nearFeature = TFFeature.getNearestFeature(chunkX, chunkZ = MathHelper.func_76128_c((double)this.field_70161_v) / 16, this.field_70170_p);
            if (nearFeature != TFFeature.questGrove) {
                this.func_110177_bN();
            } else {
                BlockPos cc = TFFeature.getNearestCenterXYZ(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v), this.field_70170_p);
                this.func_175449_a(cc, 13);
            }
            if (this.countColorsSet() > 15 && !this.getRewarded()) {
                this.rewardQuest();
                this.setRewarded(true);
            }
        }
        super.func_70619_bc();
    }

    private void rewardQuest() {
        this.func_145778_a(Item.func_150898_a((Block)Blocks.field_150484_ah), 1, 1.0f);
        this.func_145778_a(Item.func_150898_a((Block)Blocks.field_150339_S), 1, 1.0f);
        this.func_145778_a(Item.func_150898_a((Block)Blocks.field_150475_bE), 1, 1.0f);
        this.func_145778_a(Item.func_150898_a((Block)Blocks.field_150340_R), 1, 1.0f);
        this.func_145778_a(Item.func_150898_a((Block)Blocks.field_150368_y), 1, 1.0f);
        this.func_145778_a(TFItems.crumbleHorn, 1, 1.0f);
        this.rewardNearbyPlayers(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private void rewardNearbyPlayers(World world, double posX, double posY, double posZ) {
        List nearbyPlayers = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(posX, posY, posZ, posX + 1.0, posY + 1.0, posZ + 1.0).func_72314_b(16.0, 16.0, 16.0));
        for (EntityPlayer player : nearbyPlayers) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightQuestRam);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack currentItem = player.func_184586_b(hand);
        if (!currentItem.func_190926_b() && currentItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L) && !this.isColorPresent(EnumDyeColor.func_176764_b((int)currentItem.func_77952_i()))) {
            this.setColorPresent(EnumDyeColor.func_176764_b((int)currentItem.func_77952_i()));
            this.animateAddColor(EnumDyeColor.func_176764_b((int)currentItem.func_77952_i()), 50);
            if (!player.field_71075_bZ.field_75098_d) {
                currentItem.func_190918_g(1);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.checkAndAnimateColors();
    }

    private void checkAndAnimateColors() {
        if (this.countColorsSet() > 15 && !this.getRewarded()) {
            this.animateAddColor(EnumDyeColor.func_176764_b((int)this.field_70146_Z.nextInt(16)), 5);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("ColorFlags", this.getColorFlags());
        par1NBTTagCompound.func_74757_a("Rewarded", this.getRewarded());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setColorFlags(par1NBTTagCompound.func_74762_e("ColorFlags"));
        this.setRewarded(par1NBTTagCompound.func_74767_n("Rewarded"));
    }

    public int getColorFlags() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_COLOR);
    }

    public void setColorFlags(int par1) {
        this.field_70180_af.func_187227_b(DATA_COLOR, (Object)par1);
    }

    public boolean isColorPresent(EnumDyeColor color) {
        return (this.getColorFlags() & 1 << color.func_176765_a()) > 0;
    }

    public void setColorPresent(EnumDyeColor color) {
        this.setColorFlags(this.getColorFlags() | 1 << color.func_176765_a());
    }

    public boolean getRewarded() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_REWARDED);
    }

    public void setRewarded(boolean par1) {
        this.field_70180_af.func_187227_b(DATA_REWARDED, (Object)par1);
    }

    public void animateAddColor(EnumDyeColor color, int iterations) {
        int colorVal = color.func_176768_e().field_76291_p;
        int red = colorVal >>> 16 & 0xFF;
        int green = colorVal >>> 8 & 0xFF;
        int blue = colorVal & 0xFF;
        for (int i = 0; i < iterations; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 1.5, (double)red, (double)green, (double)blue, new int[0]);
        }
        this.func_70642_aH();
    }

    public int countColorsSet() {
        int count = 0;
        for (EnumDyeColor color : EnumDyeColor.values()) {
            if (!this.isColorPresent(color)) continue;
            ++count;
        }
        return count;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.7f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, Block p_145780_4_) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }
}

