/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.client.particle.TFParticleType;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.EntityAITFHoverBeam;
import twilightforest.entity.ai.EntityAITFHoverSummon;
import twilightforest.entity.ai.EntityAITFHoverThenDrop;
import twilightforest.entity.boss.EntityTFIceCrystal;
import twilightforest.entity.boss.EntityTFSnowQueenIceShield;
import twilightforest.util.WorldUtil;
import twilightforest.world.ChunkGeneratorTwilightForest;
import twilightforest.world.TFWorld;

public class EntityTFSnowQueen
extends EntityMob
implements IEntityMultiPart,
IBreathAttacker {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("twilightforest", "entities/snow_queen");
    private static final int MAX_SUMMONS = 6;
    private static final DataParameter<Boolean> BEAM_FLAG = EntityDataManager.func_187226_a(EntityTFSnowQueen.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> PHASE_FLAG = EntityDataManager.func_187226_a(EntityTFSnowQueen.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final int MAX_DAMAGE_WHILE_BEAMING = 25;
    private static final float BREATH_DAMAGE = 4.0f;
    public final Entity[] iceArray = new Entity[7];
    private int summonsRemaining = 0;
    private int successfulDrops;
    private int maxDrops;
    private int damageWhileBeaming;

    public EntityTFSnowQueen(World par1World) {
        super(par1World);
        this.func_70105_a(0.7f, 2.2f);
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i] = new EntityTFSnowQueenIceShield(this);
        }
        this.setCurrentPhase(Phase.SUMMON);
        this.field_70178_ae = true;
        this.field_70728_aV = 317;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITFHoverSummon(this, EntityPlayer.class, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITFHoverThenDrop(this, EntityPlayer.class, 80, 20));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITFHoverBeam(this, EntityPlayer.class, 80, 100));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BEAM_FLAG, (Object)false);
        this.field_70180_af.func_187214_a(PHASE_FLAG, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return TFSounds.ICE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ() {
        return TFSounds.ICE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFSounds.ICE_DEATH;
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public void func_70636_d() {
        float pz;
        float py;
        float px;
        int i;
        super.func_70636_d();
        for (i = 0; i < 3; ++i) {
            px = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
            py = this.func_70047_e() + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.5f;
            pz = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
            TwilightForestMod.proxy.spawnParticle(this.field_70170_p, TFParticleType.SNOW_GUARDIAN, this.field_70142_S + (double)px, this.field_70137_T + (double)py, this.field_70136_U + (double)pz, 0.0, 0.0, 0.0);
        }
        if (this.getCurrentPhase() == Phase.DROP) {
            for (i = 0; i < this.iceArray.length; ++i) {
                px = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.5f;
                py = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.5f;
                pz = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.5f;
                TwilightForestMod.proxy.spawnParticle(this.field_70170_p, TFParticleType.SNOW_WARNING, this.iceArray[i].field_70142_S + (double)px, this.iceArray[i].field_70137_T + (double)py, this.iceArray[i].field_70136_U + (double)pz, 0.0, 0.0, 0.0);
            }
        }
        if (this.isBreathing() && this.func_70089_S()) {
            Vec3d look = this.func_70040_Z();
            double dist = 0.5;
            double px2 = this.field_70165_t + look.field_72450_a * dist;
            double py2 = this.field_70163_u + (double)1.7f + look.field_72448_b * dist;
            double pz2 = this.field_70161_v + look.field_72449_c * dist;
            for (int i2 = 0; i2 < 10; ++i2) {
                double dx = look.field_72450_a;
                double dy = 0.0;
                double dz = look.field_72449_c;
                double spread = 2.0 + this.func_70681_au().nextDouble() * 2.5;
                double velocity = 2.0 + this.func_70681_au().nextDouble() * 0.15;
                dx += this.func_70681_au().nextGaussian() * 0.0075 * spread;
                dy += this.func_70681_au().nextGaussian() * 0.0075 * spread;
                dz += this.func_70681_au().nextGaussian() * 0.0075 * spread;
                TwilightForestMod.proxy.spawnParticle(this.field_70170_p, TFParticleType.ICE_BEAM, px2, py2, pz2, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i].func_70071_h_();
            if (i < this.iceArray.length - 1) {
                Vec3d blockPos = this.getIceShieldPosition(i);
                this.iceArray[i].func_70107_b(blockPos.field_72450_a, blockPos.field_72448_b, blockPos.field_72449_c);
                this.iceArray[i].field_70177_z = this.getIceShieldAngle(i);
            } else {
                this.iceArray[i].func_70107_b(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                this.iceArray[i].field_70177_z = this.getIceShieldAngle(i);
            }
            if (this.field_70170_p.field_72995_K) continue;
            this.applyShieldCollisions(this.iceArray[i]);
        }
        if (this.field_70725_aQ > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                EnumParticleTypes explosionType = this.field_70146_Z.nextBoolean() ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.EXPLOSION_NORMAL;
                this.field_70170_p.func_175688_a(explosionType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
            }
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76364_f() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.func_76364_f()).func_71029_a((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)par1DamageSource.func_76364_f()).func_71029_a((StatBase)TFAchievementPage.twilightProgressGlacier);
        }
        if (!this.field_70170_p.field_72995_K) {
            int dx = MathHelper.func_76128_c((double)this.field_70165_t);
            int dy = MathHelper.func_76128_c((double)this.field_70163_u);
            int dz = MathHelper.func_76128_c((double)this.field_70161_v);
            if (TFWorld.getChunkGenerator(this.field_70170_p) instanceof ChunkGeneratorTwilightForest) {
                ChunkGeneratorTwilightForest generator = (ChunkGeneratorTwilightForest)TFWorld.getChunkGenerator(this.field_70170_p);
                TFFeature nearbyFeature = TFFeature.getFeatureAt(dx, dz, this.field_70170_p);
                if (nearbyFeature == TFFeature.lichTower) {
                    generator.setStructureConquered(dx, dy, dz, true);
                }
            }
        }
    }

    private void applyShieldCollisions(Entity collider) {
        List list = this.field_70170_p.func_72839_b(collider, collider.func_174813_aQ().func_72314_b((double)-0.2f, (double)-0.2f, (double)-0.2f));
        for (Entity collided : list) {
            if (!collided.func_70104_M()) continue;
            this.applyShieldCollision(collider, collided);
        }
    }

    private void applyShieldCollision(Entity collider, Entity collided) {
        if (collided != this) {
            collided.func_70108_f(collider);
            if (collided instanceof EntityLivingBase && super.func_70652_k(collided)) {
                collided.field_70181_x += 0.4;
                this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getCurrentPhase() == Phase.SUMMON && this.getSummonsRemaining() == 0 && this.countMyMinions() <= 0) {
            this.setCurrentPhase(Phase.DROP);
        }
        if (this.getCurrentPhase() == Phase.DROP && this.successfulDrops >= this.maxDrops) {
            this.setCurrentPhase(Phase.BEAM);
        }
        if (this.getCurrentPhase() == Phase.BEAM && this.damageWhileBeaming >= 25) {
            this.setCurrentPhase(Phase.SUMMON);
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float damage) {
        boolean result = super.func_70097_a(par1DamageSource, damage);
        if (result && this.getCurrentPhase() == Phase.BEAM) {
            this.damageWhileBeaming = (int)((float)this.damageWhileBeaming + damage);
        }
        return result;
    }

    private Vec3d getIceShieldPosition(int idx) {
        return this.getIceShieldPosition(this.getIceShieldAngle(idx), 1.0f);
    }

    private float getIceShieldAngle(int idx) {
        return 60.0f * (float)idx + (float)this.field_70173_aa * 5.0f;
    }

    private Vec3d getIceShieldPosition(float angle, float distance) {
        double var1 = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double var3 = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new Vec3d(this.field_70165_t + var1, this.field_70163_u + this.getShieldYOffset(), this.field_70161_v + var3);
    }

    private double getShieldYOffset() {
        return 0.1f;
    }

    public void func_180430_e(float par1, float mult) {
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(EntityDragonPart entitydragonpart, DamageSource damagesource, float i) {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.iceArray;
    }

    public void destroyBlocksInAABB(AxisAlignedBB box) {
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c() != Blocks.field_150432_aD && state.func_177230_c() != Blocks.field_150403_cj) continue;
            this.field_70170_p.func_175655_b(pos, false);
        }
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.field_70180_af.func_187225_a(BEAM_FLAG);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.field_70180_af.func_187227_b(BEAM_FLAG, (Object)flag);
    }

    public Phase getCurrentPhase() {
        return Phase.values()[(Byte)this.field_70180_af.func_187225_a(PHASE_FLAG)];
    }

    public void setCurrentPhase(Phase currentPhase) {
        this.field_70180_af.func_187227_b(PHASE_FLAG, (Object)((byte)currentPhase.ordinal()));
        if (currentPhase == Phase.SUMMON) {
            this.setSummonsRemaining(6);
        }
        if (currentPhase == Phase.DROP) {
            this.successfulDrops = 0;
            this.maxDrops = 2 + this.field_70146_Z.nextInt(3);
        }
        if (currentPhase == Phase.BEAM) {
            this.damageWhileBeaming = 0;
        }
    }

    public int getSummonsRemaining() {
        return this.summonsRemaining;
    }

    public void setSummonsRemaining(int summonsRemaining) {
        this.summonsRemaining = summonsRemaining;
    }

    public void summonMinionAt(EntityLivingBase targetedEntity) {
        double attemptZ;
        double attemptY;
        double attemptX;
        EntityTFIceCrystal minion = new EntityTFIceCrystal(this.field_70170_p);
        minion.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        for (int i = 0; i < 100 && !minion.func_184595_k(attemptX = targetedEntity.field_70165_t + this.field_70146_Z.nextGaussian() * 16.0, attemptY = targetedEntity.field_70163_u + this.field_70146_Z.nextGaussian() * 8.0, attemptZ = targetedEntity.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0); ++i) {
        }
        this.field_70170_p.func_72838_d((Entity)minion);
        minion.func_70624_b(targetedEntity);
        minion.setToDieIn30Seconds();
        --this.summonsRemaining;
    }

    public int countMyMinions() {
        return this.field_70170_p.func_72872_a(EntityTFIceCrystal.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(32.0, 16.0, 32.0)).size();
    }

    public void incrementSuccessfulDrops() {
        ++this.successfulDrops;
    }

    @Override
    public void doBreathAttack(Entity target) {
        target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 4.0f);
    }

    public static enum Phase {
        SUMMON,
        DROP,
        BEAM;

    }
}

