/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TFSounds;
import twilightforest.block.BlockTFBossSpawner;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.BossVariant;
import twilightforest.entity.boss.EntityTFNagaSegment;
import twilightforest.world.ChunkGeneratorTwilightForest;
import twilightforest.world.TFWorld;

public class EntityTFNaga
extends EntityMob
implements IEntityMultiPart {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("twilightforest", "entities/naga");
    private static final int TICKS_BEFORE_HEALING = 600;
    private static final int MAX_SEGMENTS = 12;
    private static final int LEASH_X = 46;
    private static final int LEASH_Y = 7;
    private static final int LEASH_Z = 46;
    private int currentSegmentCount = 0;
    private final float healthPerSegment;
    private final EntityTFNagaSegment[] bodySegments = new EntityTFNagaSegment[12];
    private AIMovementPattern movementAI;
    private int ticksSinceDamaged = 0;
    private final BossInfoServer bossInfo = new BossInfoServer((ITextComponent)new TextComponentTranslation("entity." + EntityList.func_191301_a((Entity)this) + ".name", new Object[0]), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);
    private final AttributeModifier slowSpeed = new AttributeModifier("Naga Slow Speed", 0.25, 0).func_111168_a(false);
    private final AttributeModifier fastSpeed = new AttributeModifier("Naga Fast Speed", 1.25, 0).func_111168_a(false);

    public EntityTFNaga(World world) {
        super(world);
        this.func_70105_a(1.75f, 3.0f);
        this.field_70138_W = 2.0f;
        this.healthPerSegment = this.func_110138_aP() / 10.0f;
        this.setSegmentsPerHealth();
        this.field_70728_aV = 217;
        this.field_70158_ak = true;
        this.goNormal();
    }

    private float getMaxHealthPerDifficulty() {
        switch (this.field_70170_p.func_175659_aa()) {
            case EASY: {
                return 120.0f;
            }
            default: {
                return 200.0f;
            }
            case HARD: 
        }
        return 250.0f;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISmash(this));
        this.movementAI = new AIMovementPattern(this);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.movementAI);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 1){

            public void func_75249_e() {
                EntityTFNaga.this.goNormal();
                super.func_75249_e();
            }

            protected Vec3d func_190864_f() {
                return RandomPositionGenerator.func_75463_a((EntityCreature)this.field_75457_a, (int)30, (int)7);
            }
        });
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70765_h = new NagaMoveHelper((EntityLiving)this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getMaxHealthPerDifficulty());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.75);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(80.0);
    }

    private void setSegmentsPerHealth() {
        int newSegments;
        int oldSegments = this.currentSegmentCount;
        this.currentSegmentCount = newSegments = MathHelper.func_76125_a((int)((int)(this.func_110143_aJ() / this.healthPerSegment + (float)(this.func_110143_aJ() > 0.0f ? 2 : 0))), (int)0, (int)12);
        if (newSegments != oldSegments) {
            if (newSegments < oldSegments) {
                for (int i = newSegments; i < oldSegments; ++i) {
                    if (this.bodySegments[i] == null) continue;
                    this.bodySegments[i].selfDestruct();
                }
            } else {
                this.spawnBodySegments();
            }
        }
    }

    public boolean func_70041_e_() {
        return false;
    }

    public boolean func_180799_ab() {
        return false;
    }

    public void func_70071_h_() {
        this.despawnIfPeaceful();
        if (this.field_70725_aQ > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                EnumParticleTypes explosionType = this.field_70146_Z.nextBoolean() ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.EXPLOSION_NORMAL;
                this.field_70170_p.func_175688_a(explosionType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
            }
        }
        ++this.ticksSinceDamaged;
        if (!this.field_70170_p.field_72995_K && this.ticksSinceDamaged > 600 && this.ticksSinceDamaged % 20 == 0) {
            this.func_70691_i(1.0f);
        }
        this.setSegmentsPerHealth();
        super.func_70071_h_();
        for (EntityTFNagaSegment segment : this.bodySegments) {
            if (segment == null) continue;
            this.field_70170_p.func_72866_a((Entity)segment, true);
        }
        this.moveSegments();
    }

    protected void func_70619_bc() {
        Vec3d vec3d;
        super.func_70619_bc();
        if (this.func_70638_az() != null && (this.func_70068_e((Entity)this.func_70638_az()) > 6400.0 || !this.isEntityWithinHomeArea((Entity)this.func_70638_az()))) {
            this.func_70624_b(null);
        }
        double d = this.field_70130_N * 4.0f;
        Vec3d vec3d2 = vec3d = this.func_70781_l() ? this.func_70661_as().func_75505_d().func_75878_a((Entity)this) : null;
        while (vec3d != null && vec3d.func_186679_c(this.field_70165_t, vec3d.field_72448_b, this.field_70161_v) < d * d) {
            this.func_70661_as().func_75505_d().func_75875_a();
            if (this.func_70661_as().func_75505_d().func_75879_b()) {
                vec3d = null;
                continue;
            }
            vec3d = this.func_70661_as().func_75505_d().func_75878_a((Entity)this);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    protected SoundEvent func_184639_G() {
        return TFSounds.NAGA_HISS;
    }

    protected SoundEvent func_184601_bQ() {
        return TFSounds.NAGA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFSounds.NAGA_HURT;
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    private void crumbleBelowTarget(int range) {
        int targetY = (int)this.func_70638_az().func_174813_aQ().field_72338_b;
        int floor = (int)this.func_174813_aQ().field_72338_b;
        if (targetY > floor) {
            BlockPos pos;
            int dx = (int)this.func_70638_az().field_70165_t + this.field_70146_Z.nextInt(range) - this.field_70146_Z.nextInt(range);
            int dz = (int)this.func_70638_az().field_70161_v + this.field_70146_Z.nextInt(range) - this.field_70146_Z.nextInt(range);
            int dy = targetY - this.field_70146_Z.nextInt(range) + this.field_70146_Z.nextInt(range > 1 ? range - 1 : range);
            if (dy <= floor) {
                dy = targetY;
            }
            if (!this.field_70170_p.func_175623_d(pos = new BlockPos(dx, dy, dz))) {
                this.field_70170_p.func_175655_b(pos, true);
                for (int k = 0; k < 20; ++k) {
                    double d = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
    }

    private void goSlow() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.slowSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.fastSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.slowSpeed);
    }

    private void goNormal() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.slowSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.fastSpeed);
    }

    private void goFast() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.slowSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.fastSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.fastSpeed);
    }

    public boolean func_70104_M() {
        return false;
    }

    private BlockPos findCirclePoint(boolean clockwise, double radius, double rotation) {
        EntityLivingBase toCircle = this.func_70638_az();
        double vecx = this.field_70165_t - toCircle.field_70165_t;
        double vecz = this.field_70161_v - toCircle.field_70161_v;
        float rangle = (float)Math.atan2(vecz, vecx);
        rangle = (float)((double)rangle + (clockwise ? rotation : -rotation));
        double dx = (double)MathHelper.func_76134_b((float)rangle) * radius;
        double dz = (double)MathHelper.func_76126_a((float)rangle) * radius;
        double dy = Math.min(this.func_174813_aQ().field_72338_b, toCircle.field_70163_u);
        return new BlockPos(toCircle.field_70165_t + dx, dy, toCircle.field_70161_v + dz);
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (damagesource.func_76364_f() != null && !this.isEntityWithinHomeArea(damagesource.func_76364_f()) || damagesource.func_76346_g() != null && !this.isEntityWithinHomeArea(damagesource.func_76346_g())) {
            return false;
        }
        if (super.func_70097_a(damagesource, i)) {
            this.setSegmentsPerHealth();
            this.ticksSinceDamaged = 0;
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity toAttack) {
        boolean result = super.func_70652_k(toAttack);
        if (result) {
            toAttack.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * 3.141593f / 180.0f)) * 2.0f), (double)0.4f, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * 3.141593f / 180.0f)) * 2.0f));
            this.func_174815_a((EntityLivingBase)this, toAttack);
        }
        return result;
    }

    public float func_180484_a(BlockPos pos) {
        if (!this.func_180485_d(pos)) {
            return Float.MIN_VALUE;
        }
        return 0.0f;
    }

    private void despawnIfPeaceful() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            if (this.func_110175_bO()) {
                BlockPos home = this.func_180486_cf();
                this.field_70170_p.func_175656_a(home, TFBlocks.bossSpawner.func_176223_P().func_177226_a(BlockTFBossSpawner.VARIANT, (Comparable)((Object)BossVariant.NAGA)));
            }
            this.func_70106_y();
        }
    }

    public boolean func_180485_d(BlockPos pos) {
        if (this.func_110174_bM() == -1.0f) {
            return true;
        }
        int distX = Math.abs(this.func_180486_cf().func_177958_n() - pos.func_177958_n());
        int distY = Math.abs(this.func_180486_cf().func_177956_o() - pos.func_177956_o());
        int distZ = Math.abs(this.func_180486_cf().func_177952_p() - pos.func_177952_p());
        return distX <= 46 && distY <= 7 && distZ <= 46;
    }

    private boolean isEntityWithinHomeArea(Entity entity) {
        return this.func_180485_d(new BlockPos(entity));
    }

    private void spawnBodySegments() {
        for (int i = 0; i < this.currentSegmentCount; ++i) {
            if (this.bodySegments[i] != null && !this.bodySegments[i].field_70128_L) continue;
            this.bodySegments[i] = new EntityTFNagaSegment(this, i);
            this.bodySegments[i].func_70012_b(this.field_70165_t + 0.1 * (double)i, this.field_70163_u + 0.5, this.field_70161_v + 0.1 * (double)i, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            if (this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_72838_d((Entity)this.bodySegments[i]);
        }
    }

    private void moveSegments() {
        for (int i = 0; i < this.currentSegmentCount; ++i) {
            EntityTFNaga leader = i == 0 ? this : this.bodySegments[i - 1];
            double followX = ((Entity)leader).field_70165_t;
            double followY = ((Entity)leader).field_70163_u;
            double followZ = ((Entity)leader).field_70161_v;
            float angle = (((Entity)leader).field_70177_z + 180.0f) * 3.141593f / 180.0f;
            double straightenForce = 0.05 + 1.0 / (double)(i + 1) * 0.5;
            double idealX = (double)(-MathHelper.func_76126_a((float)angle)) * straightenForce;
            double idealZ = (double)MathHelper.func_76134_b((float)angle) * straightenForce;
            Vec3d diff = new Vec3d(this.bodySegments[i].field_70165_t - followX, this.bodySegments[i].field_70163_u - followY, this.bodySegments[i].field_70161_v - followZ);
            diff = diff.func_72432_b();
            diff = diff.func_72441_c(idealX, 0.0, idealZ).func_72432_b();
            double f = 2.0;
            double destX = followX + f * diff.field_72450_a;
            double destY = followY + f * diff.field_72448_b;
            double destZ = followZ + f * diff.field_72449_c;
            this.bodySegments[i].func_70107_b(destX, destY, destZ);
            double distance = MathHelper.func_76133_a((double)(diff.field_72450_a * diff.field_72450_a + diff.field_72449_c * diff.field_72449_c));
            if (i == 0) {
                diff = diff.func_72441_c(0.0, -0.15, 0.0);
            }
            this.bodySegments[i].func_70101_b((float)(Math.atan2(diff.field_72449_c, diff.field_72450_a) * 180.0 / Math.PI) + 90.0f, -((float)(Math.atan2(diff.field_72448_b, distance) * 180.0 / Math.PI)));
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        if (this.func_110175_bO()) {
            BlockPos home = this.func_180486_cf();
            nbttagcompound.func_74782_a("Home", (NBTBase)new NBTTagIntArray(new int[]{home.func_177958_n(), home.func_177956_o(), home.func_177952_p()}));
        }
        super.func_70014_b(nbttagcompound);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_150297_b("Home", 11)) {
            int[] home = nbttagcompound.func_74759_k("Home");
            this.func_175449_a(new BlockPos(home[0], home[1], home[2]), 20);
        } else {
            this.func_110177_bN();
        }
        this.setSegmentsPerHealth();
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.func_76346_g()).func_71029_a((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)par1DamageSource.func_76346_g()).func_71029_a((StatBase)TFAchievementPage.twilightKillNaga);
        }
        if (!this.field_70170_p.field_72995_K && TFWorld.getChunkGenerator(this.field_70170_p) instanceof ChunkGeneratorTwilightForest) {
            int dx = MathHelper.func_76128_c((double)this.field_70165_t);
            int dy = MathHelper.func_76128_c((double)this.field_70163_u);
            int dz = MathHelper.func_76128_c((double)this.field_70161_v);
            ChunkGeneratorTwilightForest generator = (ChunkGeneratorTwilightForest)TFWorld.getChunkGenerator(this.field_70170_p);
            TFFeature nearbyFeature = TFFeature.getFeatureAt(dx, dz, this.field_70170_p);
            if (nearbyFeature == TFFeature.nagaCourtyard) {
                generator.setStructureConquered(dx, dy, dz, true);
            }
        }
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(EntityDragonPart entitydragonpart, DamageSource damagesource, float i) {
        return false;
    }

    public Entity[] func_70021_al() {
        return (Entity[])Arrays.stream(this.bodySegments).filter(Objects::nonNull).toArray(Entity[]::new);
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    static class NagaMoveHelper
    extends EntityMoveHelper {
        public NagaMoveHelper(EntityLiving naga) {
            super(naga);
        }

        public void func_75641_c() {
            MovementState currentState = ((EntityTFNaga)this.field_75648_a).movementAI.movementState;
            this.field_75648_a.field_70702_br = currentState != MovementState.CHARGE && currentState != MovementState.INTIMIDATE ? MathHelper.func_76134_b((float)((float)this.field_75648_a.field_70173_aa * 0.3f)) * 0.6f : (this.field_75648_a.field_70702_br *= 0.8f);
            super.func_75641_c();
        }
    }

    static class AIMovementPattern
    extends EntityAIBase {
        private final EntityTFNaga taskOwner;
        private MovementState movementState;
        private int stateCounter;
        private boolean clockwise;

        AIMovementPattern(EntityTFNaga taskOwner) {
            this.taskOwner = taskOwner;
            this.func_75248_a(3);
            this.func_75251_c();
        }

        public boolean func_75250_a() {
            return this.taskOwner.func_70638_az() != null;
        }

        public void func_75251_c() {
            this.movementState = MovementState.CIRCLE;
            this.stateCounter = 15;
            this.clockwise = false;
        }

        public void func_75246_d() {
            if (!this.taskOwner.func_70661_as().func_75500_f()) {
                return;
            }
            switch (this.movementState) {
                case INTIMIDATE: {
                    this.taskOwner.func_70661_as().func_75499_g();
                    this.taskOwner.func_70671_ap().func_75651_a((Entity)this.taskOwner.func_70638_az(), 30.0f, 30.0f);
                    this.taskOwner.func_70625_a((Entity)this.taskOwner.func_70638_az(), 30.0f, 30.0f);
                    this.taskOwner.field_70701_bs = 0.1f;
                    break;
                }
                case CRUMBLE: {
                    this.taskOwner.func_70661_as().func_75499_g();
                    this.taskOwner.crumbleBelowTarget(2);
                    this.taskOwner.crumbleBelowTarget(3);
                    break;
                }
                case CHARGE: {
                    BlockPos tpoint = this.taskOwner.findCirclePoint(this.clockwise, 14.0, Math.PI);
                    this.taskOwner.func_70661_as().func_75492_a((double)tpoint.func_177958_n(), (double)tpoint.func_177956_o(), (double)tpoint.func_177952_p(), 1.0);
                    break;
                }
                case CIRCLE: {
                    double radius = this.stateCounter % 2 == 0 ? 12.0 : 14.0;
                    double rotation = 1.0;
                    if (this.stateCounter > 1 && this.stateCounter < 3) {
                        radius = 16.0;
                    }
                    if (this.stateCounter == 1) {
                        rotation = 0.1;
                    }
                    BlockPos tpoint = this.taskOwner.findCirclePoint(this.clockwise, radius, rotation);
                    this.taskOwner.func_70661_as().func_75492_a((double)tpoint.func_177958_n(), (double)tpoint.func_177956_o(), (double)tpoint.func_177952_p(), 1.0);
                    break;
                }
            }
            --this.stateCounter;
            if (this.stateCounter <= 0) {
                this.transitionState();
            }
        }

        private void transitionState() {
            switch (this.movementState) {
                case INTIMIDATE: {
                    boolean bl = this.clockwise = !this.clockwise;
                    if (this.taskOwner.func_70638_az().func_174813_aQ().field_72338_b > this.taskOwner.func_174813_aQ().field_72337_e) {
                        this.doCrumblePlayer();
                        break;
                    }
                    this.doCharge();
                    break;
                }
                case CRUMBLE: {
                    this.doCharge();
                    break;
                }
                case CHARGE: {
                    this.doCircle();
                    break;
                }
                case CIRCLE: {
                    this.doIntimidate();
                }
            }
        }

        private void doCircle() {
            this.movementState = MovementState.CIRCLE;
            this.stateCounter += 10 + this.taskOwner.field_70146_Z.nextInt(10);
            this.taskOwner.goNormal();
        }

        private void doCrumblePlayer() {
            this.movementState = MovementState.CRUMBLE;
            this.stateCounter = 20 + this.taskOwner.field_70146_Z.nextInt(20);
            this.taskOwner.goSlow();
        }

        private void doCharge() {
            this.movementState = MovementState.CHARGE;
            this.stateCounter = 3;
            this.taskOwner.goFast();
        }

        private void doIntimidate() {
            this.movementState = MovementState.INTIMIDATE;
            this.taskOwner.func_184185_a(TFSounds.NAGA_RATTLE, this.taskOwner.func_70599_aP() * 4.0f, this.taskOwner.func_70647_i());
            this.stateCounter += 15 + this.taskOwner.field_70146_Z.nextInt(10);
            this.taskOwner.goSlow();
        }
    }

    static enum MovementState {
        INTIMIDATE,
        CRUMBLE,
        CHARGE,
        CIRCLE;

    }

    static class AISmash
    extends EntityAIBase {
        private final EntityTFNaga taskOwner;

        AISmash(EntityTFNaga taskOwner) {
            this.taskOwner = taskOwner;
        }

        public boolean func_75250_a() {
            return this.taskOwner.func_70638_az() != null && this.taskOwner.field_70123_F;
        }

        public void func_75249_e() {
            AxisAlignedBB bb = this.taskOwner.func_174813_aQ();
            int minx = MathHelper.func_76128_c((double)(bb.field_72340_a - 0.5));
            int miny = MathHelper.func_76128_c((double)(bb.field_72338_b + 1.01));
            int minz = MathHelper.func_76128_c((double)(bb.field_72339_c - 0.5));
            int maxx = MathHelper.func_76128_c((double)(bb.field_72336_d + 0.5));
            int maxy = MathHelper.func_76128_c((double)(bb.field_72337_e + 0.001));
            int maxz = MathHelper.func_76128_c((double)(bb.field_72334_f + 0.5));
            if (this.taskOwner.func_82194_d().func_175707_a(new BlockPos(minx, miny, minz), new BlockPos(maxx, maxy, maxz))) {
                for (int dx = minx; dx <= maxx; ++dx) {
                    for (int dy = miny; dy <= maxy; ++dy) {
                        for (int dz = minz; dz <= maxz; ++dz) {
                            this.taskOwner.func_82194_d().func_175655_b(new BlockPos(dx, dy, dz), true);
                        }
                    }
                }
            }
        }
    }

    static class AIAttack
    extends EntityAIBase {
        private final EntityTFNaga taskOwner;
        private int attackTick = 20;

        AIAttack(EntityTFNaga taskOwner) {
            this.taskOwner = taskOwner;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.taskOwner.func_70638_az();
            return target != null && target.func_174813_aQ().field_72337_e > this.taskOwner.func_174813_aQ().field_72338_b - 2.5 && target.func_174813_aQ().field_72338_b < this.taskOwner.func_174813_aQ().field_72337_e + 2.5 && this.taskOwner.func_70068_e((Entity)target) <= 16.0 && this.taskOwner.func_70635_at().func_75522_a((Entity)target);
        }

        public void func_75246_d() {
            if (this.attackTick > 0) {
                --this.attackTick;
            }
        }

        public void func_75251_c() {
            this.attackTick = 20;
        }

        public void func_75249_e() {
            this.taskOwner.func_70652_k((Entity)this.taskOwner.func_70638_az());
            this.attackTick = 20;
        }
    }
}

