/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import twilightforest.entity.IBreathAttacker;

public class EntityAITFBreathAttack
extends EntityAIBase {
    private EntityLiving entityHost;
    private EntityLivingBase attackTarget;
    private double breathX;
    private double breathY;
    private double breathZ;
    private int maxDuration;
    private float attackChance;
    private float breathRange;
    private int durationLeft;

    public EntityAITFBreathAttack(EntityLiving par1EntityLiving, float speed, float range, int time, float chance) {
        this.entityHost = par1EntityLiving;
        this.breathRange = range;
        this.maxDuration = time;
        this.attackChance = chance;
        this.func_75248_a(7);
    }

    public boolean func_75250_a() {
        this.attackTarget = this.entityHost.func_70638_az();
        if (this.attackTarget == null || this.entityHost.func_70032_d((Entity)this.attackTarget) > this.breathRange || !this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget)) {
            return false;
        }
        this.breathX = this.attackTarget.field_70165_t;
        this.breathY = this.attackTarget.field_70163_u + (double)this.attackTarget.func_70047_e();
        this.breathZ = this.attackTarget.field_70161_v;
        return this.entityHost.func_70681_au().nextFloat() < this.attackChance;
    }

    public void func_75249_e() {
        this.durationLeft = this.maxDuration;
        if (this.entityHost instanceof IBreathAttacker) {
            ((IBreathAttacker)this.entityHost).setBreathing(true);
        }
    }

    public boolean func_75253_b() {
        return this.durationLeft > 0 && !this.entityHost.field_70128_L && !this.attackTarget.field_70128_L && this.entityHost.func_70032_d((Entity)this.attackTarget) <= this.breathRange && this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
    }

    public void func_75246_d() {
        Entity target;
        --this.durationLeft;
        this.entityHost.func_70671_ap().func_75650_a(this.breathX, this.breathY, this.breathZ, 100.0f, 100.0f);
        this.faceVec(this.breathX, this.breathY, this.breathZ, 100.0f, 100.0f);
        if (this.maxDuration - this.durationLeft > 5 && (target = this.getHeadLookTarget()) != null) {
            ((IBreathAttacker)this.entityHost).doBreathAttack(target);
        }
    }

    public void func_75251_c() {
        this.durationLeft = 0;
        if (this.entityHost instanceof IBreathAttacker) {
            ((IBreathAttacker)this.entityHost).setBreathing(false);
        }
    }

    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 30.0;
        Vec3d srcVec = new Vec3d(this.entityHost.field_70165_t, this.entityHost.field_70163_u + 0.25, this.entityHost.field_70161_v);
        Vec3d lookVec = this.entityHost.func_70676_i(1.0f);
        Vec3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        float var9 = 3.0f;
        List possibleList = this.entityHost.field_70170_p.func_72839_b((Entity)this.entityHost, this.entityHost.func_174813_aQ().func_72321_a(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range).func_72314_b((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.func_70067_L() || possibleEntity == this.entityHost) continue;
            float borderSize = possibleEntity.func_70111_Y();
            AxisAlignedBB collisionBB = possibleEntity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            RayTraceResult interceptPos = collisionBB.func_72327_a(srcVec, destVec);
            if (collisionBB.func_72318_a(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (interceptPos == null || !((possibleDist = srcVec.func_72438_d(interceptPos.field_72307_f)) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void faceVec(double xCoord, double yCoord, double zCoord, float yawConstraint, float pitchConstraint) {
        double xOffset = xCoord - this.entityHost.field_70165_t;
        double zOffset = zCoord - this.entityHost.field_70161_v;
        double yOffset = this.entityHost.field_70163_u + 0.25 - yCoord;
        double distance = MathHelper.func_76133_a((double)(xOffset * xOffset + zOffset * zOffset));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        this.entityHost.field_70125_A = -this.updateRotation(this.entityHost.field_70125_A, zdAngle, pitchConstraint);
        this.entityHost.field_70177_z = this.updateRotation(this.entityHost.field_70177_z, xyAngle, yawConstraint);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float var4 = MathHelper.func_76142_g((float)(par2 - par1));
        if (var4 > par3) {
            var4 = par3;
        }
        if (var4 < -par3) {
            var4 = -par3;
        }
        return par1 + var4;
    }
}

