/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.item.TFItems;

public class BlockTFTrollSteinn
extends Block
implements ModelRegisterCallback {
    public static final PropertyBool DOWN_LIT = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool UP_LIT = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool NORTH_LIT = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH_LIT = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST_LIT = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST_LIT = PropertyBool.func_177716_a((String)"east");
    private static final Map<EnumFacing, PropertyBool> PROPS = ImmutableMap.builder().put((Object)EnumFacing.DOWN, (Object)DOWN_LIT).put((Object)EnumFacing.UP, (Object)UP_LIT).put((Object)EnumFacing.NORTH, (Object)NORTH_LIT).put((Object)EnumFacing.SOUTH, (Object)SOUTH_LIT).put((Object)EnumFacing.WEST, (Object)WEST_LIT).put((Object)EnumFacing.EAST, (Object)EAST_LIT).build();
    private static final int LIGHT_THRESHHOLD = 7;

    protected BlockTFTrollSteinn() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DOWN_LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP_LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH_LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH_LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST_LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST_LIT, (Comparable)Boolean.valueOf(false)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN_LIT, UP_LIT, NORTH_LIT, SOUTH_LIT, WEST_LIT, EAST_LIT});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing e : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)PROPS.get(e), (Comparable)Boolean.valueOf(this.isBlockLit(world, pos.func_177972_a(e))));
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(2) == 0) {
            this.sparkle(world, pos, rand);
        }
    }

    private void sparkle(World world, BlockPos pos, Random rand) {
        Random random = rand;
        double pixel = 0.0625;
        int threshhold = 7;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            double rx = (float)pos.func_177958_n() + random.nextFloat();
            double ry = (float)pos.func_177956_o() + random.nextFloat();
            double rz = (float)pos.func_177952_p() + random.nextFloat();
            if (side == EnumFacing.DOWN && !world.func_180495_p(pos.func_177977_b()).func_185914_p() && world.func_175699_k(pos.func_177977_b()) <= threshhold) {
                ry = (double)(pos.func_177956_o() + 0) - pixel;
            }
            if (side == EnumFacing.UP && !world.func_180495_p(pos.func_177984_a()).func_185914_p() && world.func_175699_k(pos.func_177984_a()) <= threshhold) {
                ry = (double)(pos.func_177956_o() + 1) + pixel;
            }
            if (side == EnumFacing.NORTH && !world.func_180495_p(pos.func_177978_c()).func_185914_p() && world.func_175699_k(pos.func_177978_c()) <= threshhold) {
                rz = (double)(pos.func_177952_p() + 1) + pixel;
            }
            if (side == EnumFacing.SOUTH && !world.func_180495_p(pos.func_177968_d()).func_185914_p() && world.func_175699_k(pos.func_177968_d()) <= threshhold) {
                rz = (double)(pos.func_177952_p() + 0) - pixel;
            }
            if (side == EnumFacing.WEST && !world.func_180495_p(pos.func_177976_e()).func_185914_p() && world.func_175699_k(pos.func_177976_e()) <= threshhold) {
                rx = (double)(pos.func_177958_n() + 1) + pixel;
            }
            if (side == EnumFacing.EAST && !world.func_180495_p(pos.func_177974_f()).func_185914_p() && world.func_175699_k(pos.func_177974_f()) <= threshhold) {
                rx = (double)(pos.func_177958_n() + 0) - pixel;
            }
            if (!(rx < (double)pos.func_177958_n() || rx > (double)(pos.func_177958_n() + 1) || ry < 0.0 || ry > (double)(pos.func_177956_o() + 1) || rz < (double)pos.func_177952_p()) && !(rz > (double)(pos.func_177952_p() + 1))) continue;
            world.func_175688_a(EnumParticleTypes.REDSTONE, rx, ry, rz, 0.25, -1.0, 0.5, new int[0]);
        }
    }

    private boolean isBlockLit(IBlockAccess world, BlockPos pos) {
        int threshhold = 112;
        if (world.func_180495_p(pos).func_185914_p()) {
            return false;
        }
        int light = world.func_175626_b(pos, 0);
        int sky = light % 65536;
        int block = light / 65536;
        return sky > threshhold || block > threshhold;
    }
}

