/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.enums.SaplingVariant;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.item.TFItems;
import twilightforest.world.IBlockSettable;
import twilightforest.world.TFGenCanopyTree;
import twilightforest.world.TFGenDarkCanopyTree;
import twilightforest.world.TFGenHollowTree;
import twilightforest.world.TFGenLargeRainboak;
import twilightforest.world.TFGenMangroveTree;
import twilightforest.world.TFGenMinersTree;
import twilightforest.world.TFGenSmallRainboak;
import twilightforest.world.TFGenSmallTwilightOak;
import twilightforest.world.TFGenSortingTree;
import twilightforest.world.TFGenTreeOfTime;
import twilightforest.world.TFGenTreeOfTransformation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockTFSapling
extends BlockBush
implements IGrowable,
ModelRegisterCallback {
    public static final PropertyEnum<SaplingVariant> TF_TYPE = PropertyEnum.func_177709_a((String)"tf_type", SaplingVariant.class);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    protected BlockTFSapling() {
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TF_TYPE, (Comparable)((Object)SaplingVariant.OAK)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TF_TYPE});
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        IBlockSettable treeGenerator;
        switch ((SaplingVariant)((Object)state.func_177229_b(TF_TYPE))) {
            case CANOPY: {
                treeGenerator = new TFGenCanopyTree(true);
                break;
            }
            case MANGROVE: {
                treeGenerator = new TFGenMangroveTree(true);
                break;
            }
            case DARKWOOD: {
                treeGenerator = new TFGenDarkCanopyTree(true);
                break;
            }
            case HOLLOW_OAK: {
                treeGenerator = new TFGenHollowTree(true);
                break;
            }
            case TIME: {
                treeGenerator = new TFGenTreeOfTime(true);
                break;
            }
            case TRANSFORMATION: {
                treeGenerator = new TFGenTreeOfTransformation(true);
                break;
            }
            case MINING: {
                treeGenerator = new TFGenMinersTree(true);
                break;
            }
            case SORTING: {
                treeGenerator = new TFGenSortingTree(true);
                break;
            }
            case RAINBOW: {
                treeGenerator = rand.nextInt(7) == 0 ? new TFGenLargeRainboak(true) : new TFGenSmallRainboak(true);
                break;
            }
            default: {
                treeGenerator = new TFGenSmallTwilightOak(true);
            }
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        if (!treeGenerator.func_180709_b(world, rand, pos)) {
            world.func_180501_a(pos, state, 4);
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        par3List.add((Object)new ItemStack(par1, 1, 0));
        par3List.add((Object)new ItemStack(par1, 1, 1));
        par3List.add((Object)new ItemStack(par1, 1, 2));
        par3List.add((Object)new ItemStack(par1, 1, 3));
        par3List.add((Object)new ItemStack(par1, 1, 4));
        par3List.add((Object)new ItemStack(par1, 1, 5));
        par3List.add((Object)new ItemStack(par1, 1, 6));
        par3List.add((Object)new ItemStack(par1, 1, 7));
        par3List.add((Object)new ItemStack(par1, 1, 8));
        par3List.add((Object)new ItemStack(par1, 1, 9));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public String func_149732_F() {
        return I18n.func_135052_a((String)(this.func_149739_a() + "." + BlockPlanks.EnumType.OAK.func_176840_c() + ".name"), (Object[])new Object[0]);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public int func_176201_c(IBlockState state) {
        return ((SaplingVariant)((Object)state.func_177229_b(TF_TYPE))).ordinal();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TF_TYPE, (Comparable)((Object)SaplingVariant.values()[meta % SaplingVariant.values().length]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        for (int i = 0; i < SaplingVariant.values().length; ++i) {
            String variant = "inventory_" + SaplingVariant.values()[i].func_176610_l();
            ModelResourceLocation mrl = new ModelResourceLocation(this.getRegistryName(), variant);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)mrl);
        }
    }
}

