/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.item.TFItems;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockTFForceField
extends BlockPane
implements ModelRegisterCallback {
    public static final List<EnumDyeColor> VALID_COLORS = ImmutableList.of((Object)EnumDyeColor.PURPLE, (Object)EnumDyeColor.PINK, (Object)EnumDyeColor.ORANGE, (Object)EnumDyeColor.GREEN, (Object)EnumDyeColor.BLUE);
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177707_a((String)"color", EnumDyeColor.class, VALID_COLORS);

    protected BlockTFForceField() {
        super(Material.field_151577_b, false);
        this.func_149715_a(0.13333334f);
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176241_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176243_N, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176244_O, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176242_M, (Comparable)Boolean.valueOf(false)).func_177226_a(COLOR, (Comparable)EnumDyeColor.PURPLE));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176241_b, field_176243_N, field_176244_O, field_176242_M, COLOR});
    }

    public int func_176201_c(IBlockState state) {
        return VALID_COLORS.indexOf(state.func_177229_b(COLOR));
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)VALID_COLORS.get(meta));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        for (int i = 0; i < COLOR.func_177700_c().size(); ++i) {
            par3List.add((Object)new ItemStack(par1, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity, boolean useActualState) {
        if (((Boolean)state.func_177229_b((IProperty)field_176241_b)).booleanValue() && (Boolean)state.func_177229_b((IProperty)field_176243_N) & (Boolean)state.func_177229_b((IProperty)field_176244_O) && ((Boolean)state.func_177229_b((IProperty)field_176242_M)).booleanValue()) {
            BlockTFForceField.func_185492_a((BlockPos)pos, (AxisAlignedBB)aabb, list, (AxisAlignedBB)field_185505_j);
        } else {
            super.func_185477_a(state, world, pos, aabb, list, entity, useActualState);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        for (int i = 0; i < VALID_COLORS.size(); ++i) {
            String variant = "inventory_" + VALID_COLORS.get(i).func_176610_l();
            ModelResourceLocation mrl = new ModelResourceLocation(this.getRegistryName(), variant);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)mrl);
        }
    }
}

