/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.passive.EntityTFBighorn;
import twilightforest.entity.passive.EntityTFBoar;
import twilightforest.entity.passive.EntityTFBunny;
import twilightforest.entity.passive.EntityTFDeer;
import twilightforest.entity.passive.EntityTFMobileFirefly;
import twilightforest.entity.passive.EntityTFRaven;
import twilightforest.entity.passive.EntityTFSquirrel;
import twilightforest.entity.passive.EntityTFTinyBird;
import twilightforest.world.TFWorld;

public class TFBiomeBase
extends Biome {
    protected WorldGenBigMushroom bigMushroomGen = new WorldGenBigMushroom();
    protected WorldGenBirchTree birchGen = new WorldGenBirchTree(false, false);
    protected List<Biome.SpawnListEntry> undergroundMonsterList;

    public TFBiomeBase(Biome.BiomeProperties props) {
        super(props);
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFBighorn.class, 12, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFBoar.class, 10, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFDeer.class, 15, 4, 5));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 5, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFTinyBird.class, 15, 4, 8));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFSquirrel.class, 10, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFBunny.class, 10, 4, 5));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFRaven.class, 10, 1, 2));
        this.undergroundMonsterList = new ArrayList<Biome.SpawnListEntry>();
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntitySpider.class, 10, 4, 4));
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntityZombie.class, 10, 4, 4));
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntitySkeleton.class, 10, 4, 4));
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntityCreeper.class, 1, 4, 4));
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntitySlime.class, 10, 4, 4));
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntityEnderman.class, 1, 1, 4));
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntityTFKobold.class, 10, 4, 8));
        this.field_82914_M.clear();
        this.field_82914_M.add(new Biome.SpawnListEntry(EntityBat.class, 10, 8, 8));
        this.field_82914_M.add(new Biome.SpawnListEntry(EntityTFMobileFirefly.class, 10, 8, 8));
        this.getTFBiomeDecorator().setTreesPerChunk(10);
        this.getTFBiomeDecorator().setGrassPerChunk(2);
    }

    public float func_76741_f() {
        return 0.12f;
    }

    public BiomeDecorator func_76729_a() {
        return new TFBiomeDecorator();
    }

    protected TFBiomeDecorator getTFBiomeDecorator() {
        return (TFBiomeDecorator)this.field_76760_I;
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(5) == 0) {
            return this.birchGen;
        }
        if (random.nextInt(10) == 0) {
            return new WorldGenBigTree(false);
        }
        return field_76757_N;
    }

    public WorldGenerator func_76730_b(Random par1Random) {
        if (par1Random.nextInt(4) == 0) {
            return new WorldGenTallGrass(BlockTallGrass.EnumType.FERN);
        }
        return new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noiseVal) {
        this.genTwilightBiomeTerrain(world, rand, primer, x, z, noiseVal);
    }

    protected void genTwilightBiomeTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = TFWorld.SEALEVEL;
        IBlockState iblockstate = this.field_76752_A;
        IBlockState iblockstate1 = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(i1, j1, l, field_185367_c);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a || iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
            if (this.getStoneReplacementState() != null) {
                chunkPrimerIn.func_177855_a(i1, j1, l, this.getStoneReplacementState());
            }
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.field_76752_A;
                    iblockstate1 = this.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = this.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? field_185371_g : field_185372_h;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                    chunkPrimerIn.func_177855_a(i1, j1, l, field_185368_d);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? field_185369_e : field_185370_f;
        }
    }

    public IBlockState getStoneReplacementState() {
        return null;
    }

    public boolean doesPlayerHaveRequiredAchievement(EntityPlayer player) {
        if (this.getRequiredAchievement() != null && player instanceof EntityPlayerMP && ((EntityPlayerMP)player).func_147099_x() != null) {
            StatisticsManagerServer stats = ((EntityPlayerMP)player).func_147099_x();
            return stats.func_77443_a(this.getRequiredAchievement());
        }
        if (this.getRequiredAchievement() != null && player instanceof EntityPlayerSP && ((EntityPlayerSP)player).func_146107_m() != null) {
            StatisticsManager stats = ((EntityPlayerSP)player).func_146107_m();
            return stats.func_77443_a(this.getRequiredAchievement());
        }
        return true;
    }

    protected Achievement getRequiredAchievement() {
        return null;
    }

    public void enforceProgession(EntityPlayer player, World world) {
    }

    public List<Biome.SpawnListEntry> getUndergroundSpawnableList() {
        return this.undergroundMonsterList;
    }
}

