/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFBiomeClearing;
import twilightforest.biomes.TFBiomeDarkForest;
import twilightforest.biomes.TFBiomeDarkForestCenter;
import twilightforest.biomes.TFBiomeDeepMushrooms;
import twilightforest.biomes.TFBiomeEnchantedForest;
import twilightforest.biomes.TFBiomeFinalPlateau;
import twilightforest.biomes.TFBiomeFireSwamp;
import twilightforest.biomes.TFBiomeFireflyForest;
import twilightforest.biomes.TFBiomeGlacier;
import twilightforest.biomes.TFBiomeHighlands;
import twilightforest.biomes.TFBiomeMushrooms;
import twilightforest.biomes.TFBiomeOakSavanna;
import twilightforest.biomes.TFBiomeSnow;
import twilightforest.biomes.TFBiomeStream;
import twilightforest.biomes.TFBiomeSwamp;
import twilightforest.biomes.TFBiomeThornlands;
import twilightforest.biomes.TFBiomeTwilightForestVariant;
import twilightforest.biomes.TFBiomeTwilightLake;

@Mod.EventBusSubscriber
public final class RegistryBiomeEvent {
    @SubscribeEvent
    public static void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
        BiomeRegistry biomes = new BiomeRegistry((IForgeRegistry<Biome>)event.getRegistry());
        biomes.register("twilight_lake", new TFBiomeTwilightLake(new Biome.BiomeProperties("Twilight Lake").func_185410_a(0.66f).func_185395_b(1.0f).func_185398_c(-1.8f).func_185400_d(0.1f)), BiomeDictionary.Type.OCEAN);
        biomes.register("twilight_forest", new TFBiomeBase(new Biome.BiomeProperties("Twilight Forest")), BiomeDictionary.Type.FOREST);
        biomes.register("dense_twilight_forest", new TFBiomeTwilightForestVariant(new Biome.BiomeProperties("Dense Twilight Forest").func_185402_a(21794).func_185410_a(0.7f).func_185395_b(0.8f).func_185398_c(0.2f).func_185400_d(0.2f)), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        biomes.register("twilight_highlands", new TFBiomeHighlands(new Biome.BiomeProperties("Twilight Highlands").func_185410_a(0.4f).func_185395_b(0.7f).func_185398_c(3.5f).func_185400_d(0.05f)), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS);
        biomes.register("mushroom_forest", new TFBiomeMushrooms(new Biome.BiomeProperties("Mushroom Forest").func_185410_a(0.8f).func_185395_b(0.8f)), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM);
        biomes.register("twilight_swamp", new TFBiomeSwamp(new Biome.BiomeProperties("Twilight Swamp").func_185410_a(0.8f).func_185395_b(0.9f).func_185398_c(-0.125f).func_185400_d(0.125f).func_185402_a(14745518)), BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET);
        biomes.register("twilight_stream", new TFBiomeStream(new Biome.BiomeProperties("Twilight Stream").func_185410_a(0.5f).func_185395_b(0.1f).func_185398_c(-0.5f).func_185400_d(0.0f)), BiomeDictionary.Type.RIVER);
        biomes.register("snowy_forest", new TFBiomeSnow(new Biome.BiomeProperties("Snowy Forest").func_185410_a(0.09f).func_185395_b(0.9f).func_185398_c(0.2f).func_185400_d(0.2f)), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS);
        biomes.register("twilight_glacier", new TFBiomeGlacier(new Biome.BiomeProperties("Twilight Glacier").func_185410_a(0.0f).func_185395_b(0.1f)), BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND);
        biomes.register("twilight_clearing", new TFBiomeClearing(new Biome.BiomeProperties("Twilight Clearing").func_185410_a(0.8f).func_185395_b(0.4f).func_185398_c(0.125f).func_185400_d(0.05f)), BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        biomes.register("oak_savannah", new TFBiomeOakSavanna(new Biome.BiomeProperties("Oak Savanna").func_185410_a(0.9f).func_185395_b(0.0f).func_185398_c(0.2f).func_185400_d(0.2f)), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE);
        biomes.register("firefly_forest", new TFBiomeFireflyForest(new Biome.BiomeProperties("Firefly Forest").func_185410_a(0.5f).func_185395_b(1.0f).func_185398_c(0.125f).func_185400_d(0.05f)), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH);
        biomes.register("deep_mushroom_forest", new TFBiomeDeepMushrooms(new Biome.BiomeProperties("Deep Mushroom Forest").func_185410_a(0.8f).func_185395_b(1.0f).func_185398_c(0.125f).func_185400_d(0.05f)), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM);
        biomes.register("dark_forest", new TFBiomeDarkForest(new Biome.BiomeProperties("Dark Forest").func_185410_a(0.7f).func_185395_b(0.8f).func_185398_c(0.125f).func_185400_d(0.05f)), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY);
        biomes.register("enchanted_forest", new TFBiomeEnchantedForest(new Biome.BiomeProperties("Enchanted Forest")), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL);
        biomes.register("fire_swamp", new TFBiomeFireSwamp(new Biome.BiomeProperties("Fire Swamp").func_185410_a(1.0f).func_185395_b(0.4f).func_185402_a(0x6C2C2C).func_185398_c(0.1f).func_185400_d(0.2f)), BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HOT);
        biomes.register("dark_forest_center", new TFBiomeDarkForestCenter(new Biome.BiomeProperties("Dark Forest Center").func_185398_c(0.125f).func_185400_d(0.05f)), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.MAGICAL);
        biomes.register("highlands_center", new TFBiomeFinalPlateau(new Biome.BiomeProperties("Highlands Center").func_185410_a(0.3f).func_185395_b(0.2f).func_185398_c(10.5f).func_185400_d(0.025f)), BiomeDictionary.Type.MESA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND);
        biomes.register("thornlands", new TFBiomeThornlands(new Biome.BiomeProperties("Thornlands").func_185410_a(0.3f).func_185395_b(0.2f).func_185398_c(6.0f).func_185400_d(0.1f)), BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND);
    }

    private static class BiomeRegistry {
        private final IForgeRegistry<Biome> registry;

        BiomeRegistry(IForgeRegistry<Biome> registry) {
            this.registry = registry;
        }

        public void register(String registryName, Biome biome, BiomeDictionary.Type ... biomeTypes) {
            biome.setRegistryName("twilightforest", registryName);
            this.registry.register((IForgeRegistryEntry)biome);
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])biomeTypes);
        }
    }
}

