/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandGameRule;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import twilightforest.TFAchievementPage;
import twilightforest.TFConfig;
import twilightforest.TFPacketHandler;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFGiantBlock;
import twilightforest.block.TFBlocks;
import twilightforest.enchantment.TFEnchantment;
import twilightforest.entity.EntityTFCharmEffect;
import twilightforest.entity.EntityTFPinchBeetle;
import twilightforest.entity.EntityTFYeti;
import twilightforest.item.TFItems;
import twilightforest.network.PacketAreaProtection;
import twilightforest.network.PacketEnforceProgressionStatus;
import twilightforest.util.TFItemStackUtils;
import twilightforest.world.WorldProviderTwilightForest;

@Mod.EventBusSubscriber
public class TFEventListener {
    private static Map<UUID, InventoryPlayer> playerKeepsMap = new HashMap<UUID, InventoryPlayer>();
    private static boolean isBreakingWithGiantPick = false;
    private static boolean shouldMakeGiantCobble = false;
    private static int amountOfCobbleToReplace = 0;
    private static long lastSpawnedHintMonsterTime;

    @SubscribeEvent
    public static void pickupItem(EntityItemPickupEvent event) {
        Item item = event.getItem().func_92059_d().func_77973_b();
        if (item == TFItems.scepterTwilight || item == TFItems.scepterLifeDrain || item == TFItems.scepterZombie) {
            TFEventListener.checkPlayerForScepterMastery(event.getEntityPlayer(), item);
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightProgressLich);
        }
        if (item == TFItems.nagaScale) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightProgressNaga);
        }
        if (item == TFItems.trophy && event.getItem().func_92059_d().func_77952_i() == 2) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightKillHydra);
        }
        if (item == TFItems.trophy && event.getItem().func_92059_d().func_77952_i() == 0) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightKillNaga);
        }
        if (item == TFItems.trophy && event.getItem().func_92059_d().func_77952_i() == 1) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightKillLich);
        }
        if (item == TFItems.trophy && event.getItem().func_92059_d().func_77952_i() == 3) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightProgressUrghast);
        }
        if (item == TFItems.trophy && event.getItem().func_92059_d().func_77952_i() == 5) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightProgressGlacier);
        }
        if (item == TFItems.mazebreakerPick) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightMazebreaker);
        }
        if (item == TFItems.meefStroganoff || item == TFItems.minotaurAxe) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightProgressLabyrinth);
        }
        if (item == TFItems.fieryBlood) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightProgressHydra);
        }
        if (item == TFItems.phantomHelm || item == TFItems.phantomPlate) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightProgressKnights);
        }
        if (item == TFItems.fieryTears) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightProgressUrghast);
        }
        if (item == TFItems.alphaFur || item == TFItems.yetiBoots || item == TFItems.yetiHelm || item == TFItems.yetiPlate || item == TFItems.yetiLegs) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightProgressYeti);
        }
        if (item == TFItems.lampOfCinders) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightProgressTroll);
        }
    }

    private static void checkPlayerForScepterMastery(EntityPlayer player, Item item) {
        boolean scepterTwilight = item == TFItems.scepterTwilight;
        boolean scepterLifeDrain = item == TFItems.scepterLifeDrain;
        boolean scepterZombie = item == TFItems.scepterZombie;
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!stack.func_190926_b() && stack.func_77973_b() == TFItems.scepterTwilight) {
                scepterTwilight = true;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() == TFItems.scepterLifeDrain) {
                scepterLifeDrain = true;
            }
            if (stack.func_190926_b() || stack.func_77973_b() != TFItems.scepterZombie) continue;
            scepterZombie = true;
        }
        if (scepterTwilight && scepterLifeDrain && scepterZombie) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightLichScepters);
        }
    }

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.crafting;
        EntityPlayer player = event.player;
        if (itemStack.func_77973_b() == TFItems.plateNaga || itemStack.func_77973_b() == TFItems.legsNaga) {
            TFEventListener.checkPlayerForNagaArmorer(player, itemStack.func_77973_b());
        }
        if (itemStack.func_77973_b() == TFItems.magicMapFocus) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightMagicMapFocus);
        }
        if (itemStack.func_77973_b() == TFItems.emptyMagicMap) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightMagicMap);
        }
        if (itemStack.func_77973_b() == TFItems.emptyMazeMap) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightMazeMap);
        }
        if (itemStack.func_77973_b() == TFItems.emptyOreMap) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightOreMap);
        }
        if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150344_f) && itemStack.func_190916_E() == 64 && TFEventListener.doesCraftMatrixHaveGiantLog(event.craftMatrix)) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150344_f, 64));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150344_f, 64));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150344_f, 64));
        }
    }

    private static boolean doesCraftMatrixHaveGiantLog(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != Item.func_150898_a((Block)TFBlocks.giantLog)) continue;
            return true;
        }
        return false;
    }

    private static void checkPlayerForNagaArmorer(EntityPlayer player, Item item) {
        boolean plateNaga = item == TFItems.plateNaga;
        boolean legsNaga = item == TFItems.legsNaga;
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!stack.func_190926_b() && stack.func_77973_b() == TFItems.plateNaga) {
                plateNaga = true;
            }
            if (stack.func_190926_b() || stack.func_77973_b() != TFItems.legsNaga) continue;
            legsNaga = true;
        }
        if (plateNaga && legsNaga) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightNagaArmors);
        }
    }

    @SubscribeEvent
    public static void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (shouldMakeGiantCobble && event.getDrops().size() > 0 && ((ItemStack)event.getDrops().get(0)).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e)) {
            event.getDrops().remove(0);
            if (amountOfCobbleToReplace == 64) {
                event.getDrops().add(new ItemStack(TFBlocks.giantCobble));
            }
            if (--amountOfCobbleToReplace <= 0) {
                shouldMakeGiantCobble = false;
            }
        }
    }

    @SubscribeEvent
    public static void entityHurts(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && event.getSource().field_76373_n.equals("mob") && event.getSource().func_76346_g() != null) {
            player = (EntityPlayer)event.getEntityLiving();
            int fireLevel = TFEnchantment.getFieryAuraLevel(player.field_71071_by, event.getSource());
            if (fireLevel > 0 && player.func_70681_au().nextInt(25) < fireLevel) {
                event.getSource().func_76346_g().func_70015_d(fireLevel / 2);
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer && event.getSource().field_76373_n.equals("mob") && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            player = (EntityPlayer)event.getEntityLiving();
            int chillLevel = TFEnchantment.getChillAuraLevel(player.field_71071_by, event.getSource());
            if (chillLevel > 0) {
                ((EntityLivingBase)event.getSource().func_76346_g()).func_70690_d(new PotionEffect(MobEffects.field_76421_d, chillLevel * 5 + 5, chillLevel));
            }
        }
        if (event.getSource().field_76373_n.equals("arrow") && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer && (!(player = (EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == TFItems.tripleBow || !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() == TFItems.tripleBow)) {
            event.getEntityLiving().field_70172_ad = 0;
        }
        if (event.getSource().field_76373_n.equals("arrow") && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer && (!(player = (EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == TFItems.enderBow || !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() == TFItems.enderBow)) {
            double sourceX = player.field_70165_t;
            double sourceY = player.field_70163_u;
            double sourceZ = player.field_70161_v;
            float sourceYaw = player.field_70177_z;
            float sourcePitch = player.field_70125_A;
            player.field_70177_z = event.getEntityLiving().field_70177_z;
            player.field_70125_A = event.getEntityLiving().field_70125_A;
            player.func_70634_a(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v);
            player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            event.getEntityLiving().func_70080_a(sourceX, sourceY, sourceZ, sourceYaw, sourcePitch);
            event.getEntityLiving().func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        if (event.getEntityLiving() instanceof EntityPlayer && TFEventListener.willEntityDie(event)) {
            player = (EntityPlayer)event.getEntityLiving();
            boolean charm1 = false;
            boolean charm2 = TFItemStackUtils.consumeInventoryItem(player, s -> !s.func_190926_b() && s.func_77973_b() == TFItems.charmOfLife2, 1);
            if (!charm2) {
                charm1 = TFItemStackUtils.consumeInventoryItem(player, s -> !s.func_190926_b() && s.func_77973_b() == TFItems.charmOfLife1, 1);
            }
            if (charm2 || charm1) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                event.setAmount(0.0f);
                if (charm1) {
                    player.func_70606_j(8.0f);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 0));
                }
                if (charm2) {
                    player.func_70606_j((float)player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600, 3));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 600, 0));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 600, 0));
                }
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, charm1 ? TFItems.charmOfLife1 : TFItems.charmOfLife2);
                player.field_70170_p.func_72838_d((Entity)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, charm1 ? TFItems.charmOfLife1 : TFItems.charmOfLife2);
                effect2.offset = (float)Math.PI;
                player.field_70170_p.func_72838_d((Entity)effect2);
                player.field_70170_p.func_72960_a((Entity)player, (byte)35);
            }
        }
    }

    private static boolean willEntityDie(LivingHurtEvent event) {
        float amount = event.getAmount();
        DamageSource source = event.getSource();
        EntityLivingBase living = event.getEntityLiving();
        if (!source.func_76363_c()) {
            int armor = 25 - living.func_70658_aO();
            amount = amount * (float)armor / 25.0f;
        }
        if (living.func_70644_a(MobEffects.field_76429_m)) {
            int resistance = 25 - (living.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
            amount = amount * (float)resistance / 25.0f;
        }
        return Math.ceil(amount) >= Math.floor(living.func_110143_aJ());
    }

    @SubscribeEvent
    public static void livingDies(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            int i;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            boolean tier3 = TFItemStackUtils.consumeInventoryItem(player, s -> !s.func_190926_b() && s.func_77973_b() == TFItems.charmOfKeeping3, 1);
            boolean tier2 = tier3 || TFItemStackUtils.consumeInventoryItem(player, s -> !s.func_190926_b() && s.func_77973_b() == TFItems.charmOfKeeping2, 1);
            boolean tier1 = tier2 || TFItemStackUtils.consumeInventoryItem(player, s -> !s.func_190926_b() && s.func_77973_b() == TFItems.charmOfKeeping1, 1);
            InventoryPlayer keepInventory = new InventoryPlayer(null);
            if (tier1) {
                TFEventListener.keepAllArmor(player, keepInventory);
                if (!player.field_71071_by.func_70448_g().func_190926_b()) {
                    keepInventory.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(player.field_71071_by.field_70461_c)).func_77946_l());
                    player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
                }
            }
            if (tier2) {
                for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                    player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                }
            }
            if (tier3) {
                for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                    player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                }
            }
            for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || ((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77973_b() != TFItems.towerKey) continue;
                keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            playerKeepsMap.put(player.func_110124_au(), keepInventory);
        }
    }

    private static void keepAllArmor(EntityPlayer player, InventoryPlayer keepInventory) {
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            keepInventory.field_70460_b.set(i, (Object)((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77946_l());
            player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        InventoryPlayer keepInventory = playerKeepsMap.remove(player.func_110124_au());
        if (keepInventory != null) {
            int i;
            TwilightForestMod.LOGGER.debug("Player {} respawned and received items held in storage", new Object[]{player.func_70005_c_()});
            for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
                if (((ItemStack)keepInventory.field_70460_b.get(i)).func_190926_b()) continue;
                player.field_71071_by.field_70460_b.set(i, keepInventory.field_70460_b.get(i));
            }
            for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                if (((ItemStack)keepInventory.field_70462_a.get(i)).func_190926_b()) continue;
                player.field_71071_by.field_70462_a.set(i, keepInventory.field_70462_a.get(i));
            }
            if (!keepInventory.func_70445_o().func_190926_b()) {
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, keepInventory.func_70445_o().func_77973_b());
                player.field_70170_p.func_72838_d((Entity)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, keepInventory.func_70445_o().func_77973_b());
                effect2.offset = (float)Math.PI;
                player.field_70170_p.func_72838_d((Entity)effect2);
                player.field_70170_p.func_184134_a(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, SoundEvents.field_187941_ho, SoundCategory.HOSTILE, 1.5f, 1.0f, true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        InventoryPlayer keepInventory = playerKeepsMap.remove(player.func_110124_au());
        if (keepInventory != null) {
            TwilightForestMod.LOGGER.warn("Mod was keeping inventory items in reserve for player %s but they logged out!  Items are being dropped.", new Object[]{player.func_70005_c_()});
            keepInventory.field_70458_d = player;
            keepInventory.func_70436_m();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static boolean preOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTHMOUNT && TFEventListener.isRidingUnfriendly((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public static boolean livingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().func_70093_af() && TFEventListener.isRidingUnfriendly(event.getEntityLiving())) {
            event.getEntityLiving().func_70095_a(false);
        }
        return true;
    }

    private static boolean isRidingUnfriendly(EntityLivingBase entity) {
        return entity.func_184218_aH() && (entity.func_184187_bx() instanceof EntityTFPinchBeetle || entity.func_184187_bx() instanceof EntityTFYeti);
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().field_71075_bZ.field_75098_d && TFEventListener.isAreaProtected(event.getWorld(), event.getPlayer(), event.getPos()) && TFEventListener.isBlockProtectedFromBreaking(event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        } else if (!isBreakingWithGiantPick && !event.getPlayer().func_184614_ca().func_190926_b() && event.getPlayer().func_184614_ca().func_77973_b() == TFItems.giantPick && event.getPlayer().func_184614_ca().func_77973_b().canHarvestBlock(event.getState(), event.getPlayer().func_184614_ca())) {
            BlockPos dPos;
            int dz;
            int dy;
            int dx;
            isBreakingWithGiantPick = true;
            BlockPos bPos = BlockTFGiantBlock.roundCoords(event.getPos());
            boolean allCobble = event.getState().func_177230_c().func_180660_a(event.getState(), event.getWorld().field_73012_v, 0) == Item.func_150898_a((Block)Blocks.field_150347_e);
            for (dx = 0; dx < 4; ++dx) {
                for (dy = 0; dy < 4; ++dy) {
                    for (dz = 0; dz < 4; ++dz) {
                        dPos = bPos.func_177982_a(dx, dy, dz);
                        IBlockState stateThere = event.getWorld().func_180495_p(dPos);
                        Block blockThere = stateThere.func_177230_c();
                        allCobble &= blockThere.func_180660_a(stateThere, event.getWorld().field_73012_v, 0) == Item.func_150898_a((Block)Blocks.field_150347_e);
                    }
                }
            }
            if (allCobble && !event.getPlayer().field_71075_bZ.field_75098_d) {
                shouldMakeGiantCobble = true;
                amountOfCobbleToReplace = 64;
            } else {
                shouldMakeGiantCobble = false;
                amountOfCobbleToReplace = 0;
            }
            for (dx = 0; dx < 4; ++dx) {
                for (dy = 0; dy < 4; ++dy) {
                    for (dz = 0; dz < 4; ++dz) {
                        dPos = bPos.func_177982_a(dx, dy, dz);
                        if (dPos.equals((Object)event.getPos()) || event.getState() != event.getWorld().func_180495_p(dPos) || !(event.getPlayer() instanceof EntityPlayerMP)) continue;
                        EntityPlayerMP playerMP = (EntityPlayerMP)event.getPlayer();
                        playerMP.field_71134_c.func_180237_b(dPos);
                    }
                }
            }
            isBreakingWithGiantPick = false;
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack currentItem = event.getEntityPlayer().field_71071_by.func_70448_g();
        if (!currentItem.func_190926_b() && (currentItem.func_77973_b() == TFItems.fierySword || currentItem.func_77973_b() == TFItems.fieryPick) && TFEventListener.checkPlayerForFieryArmor(event.getEntityPlayer())) {
            event.getEntityPlayer().func_71029_a((StatBase)TFAchievementPage.twilightFierySet);
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().field_70170_p.field_73011_w instanceof WorldProviderTwilightForest && !event.getEntityPlayer().field_71075_bZ.field_75098_d) {
            World world = event.getEntityPlayer().field_70170_p;
            EntityPlayer player = event.getEntityPlayer();
            if (!world.field_72995_K && TFEventListener.isBlockProtectedFromInteraction(world, event.getPos()) && TFEventListener.isAreaProtected(world, player, event.getPos())) {
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }

    private static boolean isBlockProtectedFromInteraction(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == TFBlocks.towerDevice || block == Blocks.field_150486_ae || block == Blocks.field_150447_bR || block == Blocks.field_150430_aB || block == Blocks.field_150471_bO || block == Blocks.field_150442_at;
    }

    private static boolean isBlockProtectedFromBreaking(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_177230_c().getRegistryName().func_110623_a().contains("grave");
    }

    private static boolean checkPlayerForFieryArmor(EntityPlayer player) {
        ItemStack feet = player.func_184582_a(EntityEquipmentSlot.FEET);
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return !feet.func_190926_b() && feet.func_77973_b() == TFItems.fieryBoots || !legs.func_190926_b() && legs.func_77973_b() == TFItems.fieryLegs || !chest.func_190926_b() && chest.func_77973_b() == TFItems.fieryPlate || !head.func_190926_b() && head.func_77973_b() == TFItems.fieryHelm;
    }

    private static boolean isAreaProtected(World world, EntityPlayer player, BlockPos pos) {
        return false;
    }

    private void sendAreaProtectionPacket(World world, BlockPos pos, StructureBoundingBox sbb) {
        PacketAreaProtection message = new PacketAreaProtection(sbb, pos);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0);
        TFPacketHandler.CHANNEL.sendToAllAround((IMessage)message, targetPoint);
    }

    @SubscribeEvent
    public static void livingAttack(LivingAttackEvent event) {
    }

    @SubscribeEvent
    public static void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            TFEventListener.sendEnforcedProgressionStatus((EntityPlayerMP)event.player, event.player.field_70170_p.func_82736_K().func_82766_b("tfEnforcedProgression"));
        }
    }

    @SubscribeEvent
    public static void playerPortals(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP && event.toDim == TFConfig.dimension.dimensionID) {
            TFEventListener.sendEnforcedProgressionStatus((EntityPlayerMP)event.player, event.player.field_70170_p.func_82736_K().func_82766_b("tfEnforcedProgression"));
        }
    }

    private static void sendEnforcedProgressionStatus(EntityPlayerMP player, boolean isEnforced) {
        TFPacketHandler.CHANNEL.sendTo((IMessage)new PacketEnforceProgressionStatus(isEnforced), player);
    }

    @SubscribeEvent
    public static void worldLoaded(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && !event.getWorld().func_82736_K().func_82765_e("tfEnforcedProgression")) {
            TwilightForestMod.LOGGER.info("Loaded a world with the tfEnforcedProgression game rule not defined.  Defining it.");
            event.getWorld().func_82736_K().func_180262_a("tfEnforcedProgression", "true", GameRules.ValueType.BOOLEAN_VALUE);
        }
    }

    @SubscribeEvent
    public static void commandSent(CommandEvent event) {
        if (event.getCommand() instanceof CommandGameRule && event.getParameters().length > 1 && "tfEnforcedProgression".equals(event.getParameters()[0])) {
            boolean isEnforced = Boolean.valueOf(event.getParameters()[1]);
            TFPacketHandler.CHANNEL.sendToAll((IMessage)new PacketEnforceProgressionStatus(isEnforced));
        }
    }
}

