/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.capabilities;

import cofh.api.fluid.IFluidContainerItem;
import cofh.lib.util.helpers.FluidHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidContainerItemWrapper
implements ICapabilityProvider {
    final ItemStack stack;
    final IFluidContainerItem container;

    public FluidContainerItemWrapper(ItemStack stackIn, IFluidContainerItem containerIn) {
        this.stack = stackIn;
        this.container = containerIn;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing from) {
        if (!this.hasCapability(capability, from)) {
            return null;
        }
        return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)new IFluidHandlerItem(){

            public IFluidTankProperties[] getTankProperties() {
                return new IFluidTankProperties[]{new FluidTankProperties(FluidContainerItemWrapper.this.container.getFluid(FluidContainerItemWrapper.this.stack), FluidContainerItemWrapper.this.container.getCapacity(FluidContainerItemWrapper.this.stack), true, false)};
            }

            public int fill(FluidStack resource, boolean doFill) {
                return FluidContainerItemWrapper.this.container.fill(FluidContainerItemWrapper.this.stack, resource, doFill);
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                if (FluidHelper.isFluidEqual(resource, FluidContainerItemWrapper.this.container.getFluid(FluidContainerItemWrapper.this.stack))) {
                    return FluidContainerItemWrapper.this.container.drain(FluidContainerItemWrapper.this.stack, resource.amount, doDrain);
                }
                return null;
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                return FluidContainerItemWrapper.this.container.drain(FluidContainerItemWrapper.this.stack, maxDrain, doDrain);
            }

            @Nonnull
            public ItemStack getContainer() {
                return FluidContainerItemWrapper.this.stack;
            }
        });
    }
}

