/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.util.ComparableItem;
import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ComparableItemStack
extends ComparableItem {
    public int stackSize = -1;
    public int oreID = -1;

    public static ComparableItemStack fromItemStack(ItemStack stack) {
        return new ComparableItemStack(stack);
    }

    protected static ItemStack getOre(String oreName) {
        if (ItemHelper.oreNameExists(oreName)) {
            return ItemHelper.oreProxy.getOre(oreName);
        }
        return ItemStack.field_190927_a;
    }

    public ComparableItemStack(String oreName) {
        this(ComparableItemStack.getOre(oreName));
    }

    public ComparableItemStack(ItemStack stack) {
        super(stack);
        if (!stack.func_190926_b()) {
            this.stackSize = stack.func_190916_E();
            this.oreID = ItemHelper.oreProxy.getOreID(stack);
        }
    }

    public ComparableItemStack(Item item, int damage, int stackSize) {
        super(item, damage);
        this.stackSize = stackSize;
        this.oreID = ItemHelper.oreProxy.getOreID(this.toItemStack());
    }

    public ComparableItemStack(ComparableItemStack stack) {
        super(stack.item, stack.metadata);
        this.stackSize = stack.stackSize;
        this.oreID = stack.oreID;
    }

    @Override
    public ComparableItemStack set(ItemStack stack) {
        if (!stack.func_190926_b()) {
            this.item = stack.func_77973_b();
            this.metadata = ItemHelper.getItemDamage(stack);
            this.stackSize = stack.func_190916_E();
            this.oreID = ItemHelper.oreProxy.getOreID(stack);
        } else {
            this.item = Items.field_190931_a;
            this.metadata = -1;
            this.stackSize = -1;
            this.oreID = -1;
        }
        return this;
    }

    public ComparableItemStack set(ComparableItemStack stack) {
        if (stack != null) {
            this.item = stack.item;
            this.metadata = stack.metadata;
            this.stackSize = stack.stackSize;
            this.oreID = stack.oreID;
        } else {
            this.item = Items.field_190931_a;
            this.metadata = -1;
            this.stackSize = -1;
            this.oreID = -1;
        }
        return this;
    }

    public boolean isItemEqual(ComparableItemStack other) {
        return other != null && (this.oreID != -1 && this.oreID == other.oreID || this.isEqual(other));
    }

    public boolean isStackEqual(ComparableItemStack other) {
        return this.isItemEqual(other) && this.stackSize == other.stackSize;
    }

    public boolean isStackValid() {
        return this.item != Items.field_190931_a;
    }

    public ItemStack toItemStack() {
        return this.item != Items.field_190931_a ? new ItemStack(this.item, this.stackSize, this.metadata) : ItemStack.field_190927_a;
    }

    @Override
    public ComparableItemStack clone() {
        return new ComparableItemStack(this);
    }

    @Override
    public int hashCode() {
        return this.oreID != -1 ? this.oreID : super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ComparableItemStack && this.isItemEqual((ComparableItemStack)o);
    }
}

