/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.feature;

import cofh.core.world.FeatureParser;
import cofh.core.world.feature.UniformParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.numbers.INumberProvider;
import cofh.lib.world.feature.FeatureBase;
import cofh.lib.world.feature.FeatureGenSurface;
import cofh.lib.world.feature.FeatureGenTopBlock;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class SurfaceParser
extends UniformParser {
    @Override
    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.field_150348_b, -1), new WeightedRandomBlock(Blocks.field_150346_d, -1), new WeightedRandomBlock((Block)Blocks.field_150349_c, -1), new WeightedRandomBlock((Block)Blocks.field_150354_m, -1), new WeightedRandomBlock(Blocks.field_150351_n, -1), new WeightedRandomBlock(Blocks.field_150433_aE, -1), new WeightedRandomBlock(Blocks.field_150350_a, -1), new WeightedRandomBlock((Block)Blocks.field_150355_j, -1));
    }

    @Override
    protected FeatureBase getFeature(String featureName, Config genObject, WorldGenerator gen, INumberProvider numClusters, FeatureBase.GenRestriction biomeRes, boolean retrogen, FeatureBase.GenRestriction dimRes, Logger log) {
        List<WeightedRandomBlock> matList = this.defaultMaterial;
        if (genObject.hasPath("material")) {
            matList = new ArrayList<WeightedRandomBlock>();
            if (!FeatureParser.parseResList(genObject.root().get((Object)"material"), matList, false)) {
                log.warn("Invalid material list! Using default list.");
                matList = this.defaultMaterial;
            }
        }
        if (genObject.hasPath("follow-terrain") && genObject.getBoolean("follow-terrain")) {
            return new FeatureGenTopBlock(featureName, gen, matList, numClusters, biomeRes, retrogen, dimRes);
        }
        return new FeatureGenSurface(featureName, gen, matList, numClusters, biomeRes, retrogen, dimRes);
    }
}

