/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.oredict;

import cofh.core.util.oredict.OreDictionaryArbiterProxy;
import cofh.lib.util.ItemWrapper;
import cofh.lib.util.helpers.ItemHelper;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryArbiter {
    private static BiMap<String, Integer> oreIDs = HashBiMap.create((int)32);
    private static TMap<Integer, ArrayList<ItemStack>> oreStacks = new THashMap(128);
    private static TMap<ItemWrapper, ArrayList<Integer>> stackIDs = new THashMap(128);
    private static TMap<ItemWrapper, ArrayList<String>> stackNames = new THashMap(128);
    private static String[] oreNames = new String[0];
    public static final String UNKNOWN = "Unknown";
    public static final int UNKNOWN_ID = -1;
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initialize() {
        oreIDs = HashBiMap.create((int)oreIDs.size());
        oreStacks = new THashMap(oreStacks.size());
        stackIDs = new THashMap(stackIDs.size());
        stackNames = new THashMap(stackNames.size());
        oreNames = OreDictionary.getOreNames();
        for (String name : oreNames) {
            NonNullList ores = OreDictionary.getOres((String)name, (boolean)false);
            for (ItemStack ore : ores) {
                OreDictionaryArbiter.registerOreDictionaryEntry(ore, name);
            }
        }
        for (ItemWrapper wrapper : stackIDs.keySet()) {
            ItemWrapper wildItem;
            if (wrapper.metadata == Short.MAX_VALUE || !stackIDs.containsKey((Object)(wildItem = new ItemWrapper(wrapper.item, Short.MAX_VALUE)))) continue;
            ((ArrayList)stackIDs.get((Object)wrapper)).addAll((Collection)stackIDs.get((Object)wildItem));
            ((ArrayList)stackNames.get((Object)wrapper)).addAll((Collection)stackNames.get((Object)wildItem));
        }
        ItemHelper.oreProxy = new OreDictionaryArbiterProxy();
    }

    public static void refresh() {
        OreDictionaryArbiter.initialize();
    }

    public static void registerOreDictionaryEntry(ItemStack stack, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return;
        }
        int id = OreDictionary.getOreID((String)name);
        oreIDs.put((Object)name, (Object)id);
        if (!oreStacks.containsKey((Object)id)) {
            oreStacks.put((Object)id, new ArrayList());
        }
        ((ArrayList)oreStacks.get((Object)id)).add(stack);
        ItemWrapper item = ItemWrapper.fromItemStack(stack);
        if (!stackIDs.containsKey((Object)item)) {
            stackIDs.put((Object)item, new ArrayList());
            stackNames.put((Object)item, new ArrayList());
        }
        ((ArrayList)stackIDs.get((Object)item)).add(id);
        ((ArrayList)stackNames.get((Object)item)).add(name);
    }

    public static int getOreID(String name) {
        Integer id = (Integer)oreIDs.get((Object)name);
        return id == null ? -1 : id;
    }

    public static int getOreID(ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        ArrayList ids = (ArrayList)stackIDs.get((Object)new ItemWrapper(stack));
        if (ids == null) {
            ids = (ArrayList)stackIDs.get((Object)new ItemWrapper(stack.func_77973_b(), Short.MAX_VALUE));
        }
        return ids == null ? -1 : (Integer)ids.get(0);
    }

    public static ArrayList<Integer> getAllOreIDs(ItemStack stack) {
        ArrayList ids = (ArrayList)stackIDs.get((Object)new ItemWrapper(stack));
        return ids == null ? (ArrayList)stackIDs.get((Object)new ItemWrapper(stack.func_77973_b(), Short.MAX_VALUE)) : ids;
    }

    public static String getOreName(int id) {
        String oreName = (String)oreIDs.inverse().get((Object)id);
        return oreName == null ? UNKNOWN : oreName;
    }

    public static String getOreName(ItemStack stack) {
        int id = OreDictionaryArbiter.getOreID(stack);
        return id == -1 ? UNKNOWN : OreDictionaryArbiter.getOreName(id);
    }

    public static ArrayList<String> getAllOreNames(ItemStack stack) {
        ArrayList names = (ArrayList)stackNames.get((Object)new ItemWrapper(stack));
        return names == null ? (ArrayList)stackNames.get((Object)new ItemWrapper(stack.func_77973_b(), Short.MAX_VALUE)) : names;
    }

    public static ArrayList<ItemStack> getOres(ItemStack stack) {
        return (ArrayList)oreStacks.get((Object)OreDictionaryArbiter.getOreID(stack));
    }

    public static ArrayList<ItemStack> getOres(String name) {
        return (ArrayList)oreStacks.get((Object)OreDictionaryArbiter.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreNames;
    }

    private OreDictionaryArbiter() {
        throw new IllegalArgumentException();
    }
}

