/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network;

import cofh.core.network.PacketBase;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public abstract class PacketCoFHBase
extends PacketBase {
    private ByteArrayOutputStream arrayout;
    private DataOutputStream dataout;
    public DataInputStream datain;

    public PacketCoFHBase() {
        this.arrayout = new ByteArrayOutputStream();
        this.dataout = new DataOutputStream(this.arrayout);
    }

    public PacketCoFHBase(byte[] data) {
        this.datain = new DataInputStream(new ByteArrayInputStream(data));
    }

    public PacketCoFHBase addString(String theString) {
        try {
            this.dataout.writeUTF(theString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addUUID(UUID theUUID) {
        try {
            this.dataout.writeLong(theUUID.getMostSignificantBits());
            this.dataout.writeLong(theUUID.getLeastSignificantBits());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addLong(long theLong) {
        try {
            this.dataout.writeLong(theLong);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addInt(int theInteger) {
        try {
            this.dataout.writeInt(theInteger);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addVarInt(int theInteger) {
        try {
            int v = 0;
            if (theInteger < 0) {
                v |= 0x40;
                theInteger ^= 0xFFFFFFFF;
            }
            if ((theInteger & 0xFFFFFFC0) != 0) {
                v |= 0x80;
            }
            this.dataout.writeByte(v | theInteger & 0x3F);
            theInteger >>>= 6;
            while (theInteger != 0) {
                this.dataout.writeByte(theInteger & 0x7F | ((theInteger & 0xFFFFFF80) != 0 ? 128 : 0));
                theInteger >>>= 7;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addBool(boolean theBoolean) {
        try {
            this.dataout.writeBoolean(theBoolean);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addByte(byte theByte) {
        try {
            this.dataout.writeByte(theByte);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addByte(int theByte) {
        return this.addByte((byte)theByte);
    }

    public PacketCoFHBase addShort(short theShort) {
        try {
            this.dataout.writeShort(theShort);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addShort(int theShort) {
        return this.addShort((short)theShort);
    }

    public PacketCoFHBase addByteArray(byte[] theByteArray) {
        try {
            this.dataout.write(theByteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addFloat(float theFloat) {
        try {
            this.dataout.writeFloat(theFloat);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addItemStack(ItemStack theStack) {
        try {
            this.writeItemStack(theStack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addFluidStack(FluidStack theStack) {
        try {
            FluidHelper.writeFluidStackToPacket(theStack, this.dataout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addCoords(TileEntity theTile) {
        this.addInt(theTile.func_174877_v().func_177958_n());
        this.addInt(theTile.func_174877_v().func_177956_o());
        return this.addInt(theTile.func_174877_v().func_177952_p());
    }

    public PacketCoFHBase addCoords(int x, int y, int z) {
        this.addInt(x);
        this.addInt(y);
        return this.addInt(z);
    }

    public String getString() {
        try {
            return this.datain.readUTF();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public UUID getUUID() {
        try {
            long msb = this.datain.readLong();
            long lsb = this.datain.readLong();
            return new UUID(msb, lsb);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getLong() {
        try {
            return this.datain.readLong();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public int getInt() {
        try {
            return this.datain.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getVarInt() {
        try {
            byte v = this.datain.readByte();
            int r = v & 0x3F;
            boolean n = (v & 0x40) != 0;
            int i = 6;
            while ((v & 0x80) != 0) {
                v = this.datain.readByte();
                r |= (v & 0x7F) << i;
                i += 7;
            }
            return n ? ~r : r;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean getBool() {
        try {
            return this.datain.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte getByte() {
        try {
            return this.datain.readByte();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public short getShort() {
        try {
            return this.datain.readShort();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void getByteArray(byte[] theByteArray) {
        try {
            this.datain.readFully(theByteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public float getFloat() {
        try {
            return this.datain.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public ItemStack getItemStack() {
        try {
            return this.readItemStack();
        }
        catch (IOException e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    public FluidStack getFluidStack() {
        try {
            return FluidHelper.readFluidStackFromPacket(this.datain);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BlockPos getCoords() {
        return new BlockPos(this.getInt(), this.getInt(), this.getInt());
    }

    private void writeItemStack(ItemStack theStack) throws IOException {
        if (theStack.func_190926_b()) {
            this.addShort(-1);
        } else {
            this.addShort(Item.func_150891_b((Item)theStack.func_77973_b()));
            this.addByte(theStack.func_190916_E());
            this.addShort(ItemHelper.getItemDamage(theStack));
            this.writeNBT(theStack.func_77978_p());
        }
    }

    public ItemStack readItemStack() throws IOException {
        ItemStack stack = ItemStack.field_190927_a;
        short itemID = this.getShort();
        if (itemID >= 0) {
            byte stackSize = this.getByte();
            short damage = this.getShort();
            stack = new ItemStack(Item.func_150899_d((int)itemID), (int)stackSize, (int)damage);
            stack.func_77982_d(this.readNBT());
        }
        return stack;
    }

    public void writeNBT(NBTTagCompound nbt) throws IOException {
        if (nbt == null) {
            this.addShort(-1);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)byteArrayOutputStream);
            byte[] abyte = byteArrayOutputStream.toByteArray();
            this.addShort((short)abyte.length);
            this.addByteArray(abyte);
        }
    }

    public NBTTagCompound readNBT() throws IOException {
        short nbtLength = this.getShort();
        if (nbtLength < 0) {
            return null;
        }
        byte[] abyte = new byte[nbtLength];
        this.getByteArray(abyte);
        return CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(abyte));
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeBytes(this.arrayout.toByteArray());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.datain = new DataInputStream(new ByteArrayInputStream(buffer.array()));
        try {
            this.datain.skipBytes(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (player == null) {
            return;
        }
        this.handlePacket(player, false);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (player == null) {
            return;
        }
        this.handlePacket(player, true);
    }

    public abstract void handlePacket(EntityPlayer var1, boolean var2);
}

