/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.lib.util.helpers.ItemHelper;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TLinkedHashSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemToolCore
extends ItemTool {
    private final TLinkedHashSet<String> toolClasses = new TLinkedHashSet();
    private final Set<String> immutableClasses = Collections.unmodifiableSet(this.toolClasses);
    protected String repairIngot = "";
    protected THashSet<Block> field_150914_c = new THashSet();
    protected THashSet<Material> effectiveMaterials = new THashSet();
    protected int harvestLevel = -1;
    protected boolean showInCreative = true;

    public ItemToolCore(float baseDamage, float attackSpeed, Item.ToolMaterial toolMaterial) {
        super(baseDamage, attackSpeed, toolMaterial, null);
    }

    public ItemToolCore setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
        return this;
    }

    public ItemToolCore setRepairIngot(String repairIngot) {
        this.repairIngot = repairIngot;
        return this;
    }

    public ItemToolCore setShowInCreative(boolean showInCreative) {
        this.showInCreative = showInCreative;
        return this;
    }

    protected ItemToolCore addToolClass(String string) {
        this.toolClasses.add((Object)string);
        return this;
    }

    protected boolean harvestBlock(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!this.toolClasses.contains((Object)state.func_177230_c().getHarvestTool(state)) && !this.canHarvestBlock(state, player.func_184614_ca())) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        int xpToDrop = 0;
        if (playerMP != null && (xpToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos)) == -1) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                if (block.removedByPlayer(state, world, pos, player, false)) {
                    block.func_176206_d(world, pos, state);
                }
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            } else {
                if (block.removedByPlayer(state, world, pos, player, false)) {
                    block.func_176206_d(world, pos, state);
                }
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
            }
        }
        if (!world.field_72995_K) {
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
                if (xpToDrop > 0) {
                    block.func_180637_b(world, pos, xpToDrop);
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        return true;
    }

    protected float getEfficiency(ItemStack stack) {
        return this.field_77864_a;
    }

    protected THashSet<Block> getEffectiveBlocks(ItemStack stack) {
        return this.field_150914_c;
    }

    protected THashSet<Material> getEffectiveMaterials(ItemStack stack) {
        return this.effectiveMaterials;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.showInCreative) {
            list.add((Object)new ItemStack(item, 1, 0));
        }
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.func_150893_a(stack, state) > 1.0f;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return ItemHelper.isOreNameEqual(stack, this.repairIngot);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (this.harvestLevel != -1) {
            return this.harvestLevel;
        }
        if (!this.getToolClasses(stack).contains(toolClass)) {
            return -1;
        }
        return this.field_77862_b.func_77996_d();
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.getEffectiveMaterials(stack).contains((Object)state.func_185904_a()) || this.getEffectiveBlocks(stack).contains((Object)state) ? this.getEfficiency(stack) : 1.0f;
    }

    public String func_77861_e() {
        return super.func_77861_e().contains(":") ? super.func_77861_e().split(":", 2)[1] : super.func_77861_e();
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.toolClasses.isEmpty() ? super.getToolClasses(stack) : this.immutableClasses;
    }
}

