/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.api.core.ISecurable;
import cofh.core.init.CoreTextures;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.GlStateManager;

public class TabSecurity
extends TabBase {
    public static int defaultSide = 0;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0;
    public static int defaultBackgroundColor = 0x888888;
    private ISecurable myContainer;
    private UUID myPlayer;

    public TabSecurity(GuiBase gui, ISecurable container, UUID playerName) {
        this(gui, defaultSide, container, playerName);
    }

    public TabSecurity(GuiBase gui, int side, ISecurable container, UUID playerName) {
        super(gui, side);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.myContainer = container;
        this.myPlayer = playerName;
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize("info.cofh.owner") + ": " + this.myContainer.getOwnerName());
            return;
        }
        int x = this.gui.getMouseX() - this.currentShiftX;
        int y = this.gui.getMouseY() - this.currentShiftY;
        if (28 <= x && x < 44 && 20 <= y && y < 36) {
            list.add(StringHelper.localize("info.cofh.accessPublic"));
        } else if (48 <= x && x < 64 && 20 <= y && y < 36) {
            list.add(StringHelper.localize("info.cofh.accessRestricted"));
        } else if (68 <= x && x < 84 && 20 <= y && y < 36) {
            list.add(StringHelper.localize("info.cofh.accessPrivate"));
        }
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        if (!this.myPlayer.equals(this.myContainer.getOwner().getId())) {
            return true;
        }
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == 0) {
            mouseX += this.currentWidth;
        }
        if ((mouseX -= this.currentShiftX) < 24 || mouseX >= 88 || (mouseY -= this.currentShiftY) < 16 || mouseY >= 40) {
            return false;
        }
        if (28 <= mouseX && mouseX < 44 && 20 <= mouseY && mouseY < 36) {
            if (!this.myContainer.getAccess().isPublic()) {
                this.myContainer.setAccess(ISecurable.AccessMode.PUBLIC);
                GuiBase.playClickSound(1.0f, 0.4f);
            }
        } else if (48 <= mouseX && mouseX < 64 && 20 <= mouseY && mouseY < 36) {
            if (!this.myContainer.getAccess().isFriendsOnly()) {
                this.myContainer.setAccess(ISecurable.AccessMode.FRIENDS);
                GuiBase.playClickSound(1.0f, 0.6f);
            }
        } else if (68 <= mouseX && mouseX < 84 && 20 <= mouseY && mouseY < 36 && !this.myContainer.getAccess().isPrivate()) {
            this.myContainer.setAccess(ISecurable.AccessMode.PRIVATE);
            GuiBase.playClickSound(1.0f, 0.8f);
        }
        return true;
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GlStateManager.func_179131_c((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.func_73729_b(this.posX() + 24, this.posY + 16, 16, 20, 64, 24);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawForeground() {
        if (this.myContainer.getAccess().isPublic()) {
            this.drawTabIcon(CoreTextures.ICON_ACCESS_PUBLIC);
        } else if (this.myContainer.getAccess().isFriendsOnly()) {
            this.drawTabIcon(CoreTextures.ICON_ACCESS_FRIENDS);
        } else if (this.myContainer.getAccess().isPrivate()) {
            this.drawTabIcon(CoreTextures.ICON_ACCESS_PRIVATE);
        }
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.security"), (float)(this.posXOffset() + 18), (float)(this.posY + 6), this.headerColor);
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.access") + ":", (float)(this.posXOffset() + 6), (float)(this.posY + 42), this.subheaderColor);
        if (this.myContainer.getAccess().isPublic()) {
            this.gui.drawButton(CoreTextures.ICON_ACCESS_PUBLIC, this.posX() + 28, this.posY + 20, 1);
            this.gui.drawButton(CoreTextures.ICON_ACCESS_FRIENDS, this.posX() + 48, this.posY + 20, 0);
            this.gui.drawButton(CoreTextures.ICON_ACCESS_PRIVATE, this.posX() + 68, this.posY + 20, 0);
            this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.accessPublic"), this.posXOffset() + 14, this.posY + 54, this.textColor);
        } else if (this.myContainer.getAccess().isFriendsOnly()) {
            this.gui.drawButton(CoreTextures.ICON_ACCESS_PUBLIC, this.posX() + 28, this.posY + 20, 0);
            this.gui.drawButton(CoreTextures.ICON_ACCESS_FRIENDS, this.posX() + 48, this.posY + 20, 1);
            this.gui.drawButton(CoreTextures.ICON_ACCESS_PRIVATE, this.posX() + 68, this.posY + 20, 0);
            this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.accessRestricted"), this.posXOffset() + 14, this.posY + 54, this.textColor);
        } else if (this.myContainer.getAccess().isPrivate()) {
            this.gui.drawButton(CoreTextures.ICON_ACCESS_PUBLIC, this.posX() + 28, this.posY + 20, 0);
            this.gui.drawButton(CoreTextures.ICON_ACCESS_FRIENDS, this.posX() + 48, this.posY + 20, 0);
            this.gui.drawButton(CoreTextures.ICON_ACCESS_PRIVATE, this.posX() + 68, this.posY + 20, 1);
            this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.accessPrivate"), this.posXOffset() + 14, this.posY + 54, this.textColor);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void setFullyOpen() {
        if (!this.myPlayer.equals(this.myContainer.getOwner().getId())) {
            return;
        }
        super.setFullyOpen();
    }
}

