/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.core.init.CoreTextures;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.container.IAugmentableContainer;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class TabAugment
extends TabBase {
    public static int defaultSide = 1;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0;
    public static int defaultBackgroundColor = 564812;
    public static ResourceLocation GRID_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/slot_grid_augment.png");
    IAugmentableContainer myContainer;
    private int numAugments = 0;
    private int slotsBorderX1 = 18;
    private int slotsBorderX2 = this.slotsBorderX1 + 60;
    private int slotsBorderY1 = 20;
    private int slotsBorderY2 = this.slotsBorderY1 + 42;

    public TabAugment(GuiBase gui, IAugmentableContainer container) {
        this(gui, defaultSide, container);
    }

    public TabAugment(GuiBase gui, int side, IAugmentableContainer container) {
        super(gui, side);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.myContainer = container;
        this.numAugments = this.myContainer.getAugmentSlots().length;
        if (this.numAugments > 0) {
            for (int i = 0; i < this.numAugments; ++i) {
                this.myContainer.getAugmentSlots()[i].field_75223_e = -gui.getGuiLeft() - 16;
                this.myContainer.getAugmentSlots()[i].field_75221_f = -gui.getGuiTop() - 16;
            }
            switch (this.numAugments) {
                case 4: {
                    this.slotsBorderX1 += 9;
                }
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    this.slotsBorderX1 += 9 * (3 - this.numAugments);
                    this.slotsBorderX2 = this.slotsBorderX1 + 18 * this.numAugments + 6;
                    this.slotsBorderY1 += 9;
                    this.slotsBorderY2 -= 9;
                }
            }
        }
        this.myContainer.setAugmentLock(true);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize("info.cofh.augmentation"));
            if (this.numAugments == 0) {
                list.add("\u00a7e" + StringHelper.localize("info.cofh.upgradeRequired"));
            }
        }
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        if (this.numAugments == 0) {
            return true;
        }
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == 0) {
            mouseX += this.currentWidth;
        }
        return (mouseX -= this.currentShiftX) >= this.slotsBorderX1 + this.sideOffset() && mouseX < this.slotsBorderX2 + this.sideOffset() && (mouseY -= this.currentShiftY) >= this.slotsBorderY1 && mouseY < this.slotsBorderY2;
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GlStateManager.func_179131_c((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        if (this.numAugments > 0) {
            if (this.numAugments > 3) {
                this.gui.func_73729_b(this.posXOffset() + this.slotsBorderX1, this.posY + this.slotsBorderY1, 16, 20, (this.numAugments > 4 ? 54 : 36) + 6, 42);
            } else {
                this.gui.func_73729_b(this.posXOffset() + this.slotsBorderX1, this.posY + this.slotsBorderY1, 16, 20, 18 * this.numAugments + 6, 24);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.bindTexture(GRID_TEXTURE);
            switch (this.numAugments) {
                case 4: {
                    this.drawSlots(0, 0, 2);
                    this.drawSlots(0, 1, 2);
                    break;
                }
                case 5: {
                    this.drawSlots(0, 0, 3);
                    this.drawSlots(1, 1, 2);
                    break;
                }
                case 6: {
                    this.drawSlots(0, 0, 3);
                    this.drawSlots(0, 1, 3);
                    break;
                }
                default: {
                    this.drawSlots(0, 0, this.numAugments);
                }
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawForeground() {
        this.drawTabIcon(CoreTextures.ICON_AUGMENT);
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.augmentation"), (float)(this.posXOffset() + 18), (float)(this.posY + 6), this.headerColor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void setFullyOpen() {
        if (this.numAugments == 0) {
            return;
        }
        super.setFullyOpen();
        switch (this.numAugments) {
            case 4: {
                for (int i = 0; i < this.numAugments; ++i) {
                    this.myContainer.getAugmentSlots()[i].field_75223_e = this.posXOffset() + this.slotsBorderX1 + 4 + 18 * (i % 2);
                    this.myContainer.getAugmentSlots()[i].field_75221_f = this.posY + this.slotsBorderY1 + 4 + 18 * (i / 2);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.numAugments; ++i) {
                    this.myContainer.getAugmentSlots()[i].field_75223_e = this.posXOffset() + this.slotsBorderX1 + 4 + 18 * (i % 3) + 9 * (i / 3);
                    this.myContainer.getAugmentSlots()[i].field_75221_f = this.posY + this.slotsBorderY1 + 4 + 18 * (i / 3);
                }
                break;
            }
            default: {
                for (int i = 0; i < this.numAugments; ++i) {
                    this.myContainer.getAugmentSlots()[i].field_75223_e = this.posXOffset() + this.slotsBorderX1 + 4 + 18 * (i % 3);
                    this.myContainer.getAugmentSlots()[i].field_75221_f = this.posY + this.slotsBorderY1 + 4 + 18 * (i / 3);
                }
            }
        }
        this.myContainer.setAugmentLock(false);
    }

    @Override
    public void toggleOpen() {
        if (this.open) {
            for (int i = 0; i < this.numAugments; ++i) {
                this.myContainer.getAugmentSlots()[i].field_75223_e = -this.gui.getGuiLeft() - 16;
                this.myContainer.getAugmentSlots()[i].field_75221_f = -this.gui.getGuiTop() - 16;
            }
            this.myContainer.setAugmentLock(true);
        }
        super.toggleOpen();
    }

    private void drawSlots(int xOffset, int yOffset, int slots) {
        this.gui.drawSizedTexturedModalRect(this.posXOffset() + this.slotsBorderX1 + 3 + 9 * xOffset, this.posY + this.slotsBorderY1 + 3 + 18 * yOffset, 0, 0, 18 * slots, 18, 96.0f, 32.0f);
    }
}

