/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.CoFHAccessTransformer;
import cofh.asm.CoFHClassTransformer;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.Level;

@IFMLLoadingPlugin.TransformerExclusions(value={"cofh.asm."})
@IFMLLoadingPlugin.SortingIndex(value=1001)
@IFMLLoadingPlugin.Name(value="CoFH Loading Plugin")
public class LoadingPlugin
implements IFMLLoadingPlugin {
    public static final String MC_VERSION = "[1.10.2]";
    public static boolean runtimeDeobfEnabled = false;
    public static ASMDataTable ASM_DATA = null;
    public static LaunchClassLoader loader = null;
    public static final String currentMcVersion;
    public static final File minecraftDir;
    public static final boolean obfuscated;
    public File myLocation;

    public String getAccessTransformerClass() {
        return CoFHAccessTransformer.class.getName();
    }

    public String[] getASMTransformerClass() {
        return new String[]{"cofh.asm.CoFHClassTransformer", "cofh.asm.repack.codechicken.lib.asm.ClassHierarchyManager"};
    }

    public String getModContainerClass() {
        return CoFHDummyContainer.class.getName();
    }

    public String getSetupClass() {
        return CallHook.class.getName();
    }

    public void injectData(Map<String, Object> data) {
        loader = (LaunchClassLoader)data.get("classLoader");
        runtimeDeobfEnabled = (Boolean)data.get("runtimeDeobfuscationEnabled");
        if (data.containsKey("coremodLocation")) {
            this.myLocation = (File)data.get("coremodLocation");
        }
    }

    static {
        boolean obf = true;
        try {
            obf = Launch.classLoader.getClassBytes("net.minecraft.world.World") == null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        obfuscated = obf;
        currentMcVersion = (String)FMLInjectionData.data()[4];
        minecraftDir = (File)FMLInjectionData.data()[6];
        loader = Launch.classLoader;
    }

    public static class CallHook
    implements IFMLCallHook {
        public void injectData(Map<String, Object> data) {
            loader = (LaunchClassLoader)data.get("classLoader");
        }

        public Void call() throws Exception {
            this.scanMods();
            return null;
        }

        private void scanMods() {
            File modsDir = new File(minecraftDir, "mods");
            for (File file : modsDir.listFiles()) {
                this.scanMod(file);
            }
            File versionModsDir = new File(minecraftDir, "mods/" + currentMcVersion);
            if (versionModsDir.exists()) {
                for (File file : versionModsDir.listFiles()) {
                    this.scanMod(file);
                }
            }
        }

        private void scanMod(File file) {
            String name = file.getName().toLowerCase();
            if (file.isDirectory() || !name.endsWith(".jar") && !name.endsWith(".zip")) {
                return;
            }
            try (JarFile jar = new JarFile(file);){
                Manifest manifest = jar.getManifest();
                if (manifest == null) {
                } else {
                    Attributes attr = manifest.getMainAttributes();
                    if (attr == null) {
                    } else {
                        String transformers = attr.getValue("CoFHAT");
                        if (transformers != null) {
                            for (String t : transformers.split(" ")) {
                                ZipEntry at = jar.getEntry("META-INF/" + t);
                                if (at == null) continue;
                                FMLLog.log((String)"CoFHASM", (Level)Level.DEBUG, (String)("Adding CoFHAT: " + t + " from: " + file.getName()), (Object[])new Object[0]);
                                CoFHAccessTransformer.processATFile(new InputStreamReader(jar.getInputStream(at)));
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class CoFHDummyContainer
    extends DummyModContainer {
        public CoFHDummyContainer() {
            super(new ModMetadata());
            ModMetadata md = this.getMetadata();
            md.autogenerated = true;
            md.modId = "<CoFH ASM>";
            md.description = "CoFH ASM";
            md.name = "CoFH ASM";
            md.parent = "CoFHCore";
            md.version = "000";
        }

        public boolean registerBus(EventBus bus, LoadController controller) {
            bus.register((Object)this);
            return true;
        }

        @Subscribe
        public void construction(FMLConstructionEvent evt) {
            ASM_DATA = evt.getASMHarvestedData();
            CoFHClassTransformer.scrapeData(ASM_DATA);
        }
    }
}

