/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.ASMCore;
import cofh.asm.repack.codechicken.lib.asm.ASMBlock;
import cofh.asm.repack.codechicken.lib.asm.ASMHelper;
import cofh.asm.repack.codechicken.lib.asm.ASMReader;
import cofh.asm.repack.codechicken.lib.asm.ModularASMTransformer;
import cofh.asm.repack.codechicken.lib.asm.ObfMapping;
import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CoFHClassTransformer
implements IClassTransformer {
    private static boolean scrappedData = false;
    private ModularASMTransformer transformer = new ModularASMTransformer();

    public CoFHClassTransformer() {
        ASMCore.init();
        this.loadTransformer();
    }

    public static void scrapeData(ASMDataTable table) {
        ASMCore.scrapeData(table);
        scrappedData = true;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (scrappedData && ASMCore.parsables.contains((Object)name)) {
            bytes = ASMCore.parse(name, transformedName, bytes);
        }
        bytes = this.transformer.transform(transformedName, bytes);
        return bytes;
    }

    private void loadTransformer() {
        Map<String, ASMBlock> blocks = ASMReader.loadResource("/assets/cofh/asm/hooks.asm");
        ObfMapping mapping = new ObfMapping("net/minecraft/client/renderer/EntityRenderer", "func_78466_h", "(F)V");
        this.transformer.add(new ModularASMTransformer.MethodInjector(mapping, blocks.get("n_fogColor"), blocks.get("i_fogColor"), true));
        this.loadWorldProxy();
    }

    private void loadWorldProxy() {
        String worldServer = "net/minecraft/world/WorldServer";
        String world = "net/minecraft/world/World";
        String sigBody = "Lnet/minecraft/world/storage/ISaveHandler;Lnet/minecraft/world/storage/WorldInfo;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/profiler/Profiler;Z";
        final String serverSig = "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Lnet/minecraft/world/storage/WorldInfo;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/profiler/Profiler;Z)V";
        final String worldSig = "(Lnet/minecraft/world/storage/ISaveHandler;Lnet/minecraft/world/storage/WorldInfo;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/profiler/Profiler;Z)V";
        ObfMapping serverMapping = new ObfMapping("net/minecraft/world/WorldServer", "<init>", serverSig);
        this.transformer.add(new ModularASMTransformer.MethodTransformer(serverMapping){

            @Override
            public void transform(ClassNode cnode) {
                MethodNode mv = ASMHelper.findMethod(this.method, cnode);
                if (mv != null) {
                    return;
                }
                ObfMapping mcServer = new ObfMapping("net/minecraft/world/WorldServer", "field_73061_a", "Lnet/minecraft/server/MinecraftServer;").toRuntime();
                ObfMapping[] nullFields = new ObfMapping[]{new ObfMapping("net/minecraft/world/WorldServer", "field_73062_L", "Lnet/minecraft/entity/EntityTracker;").toRuntime(), new ObfMapping("net/minecraft/world/WorldServer", "field_73063_M", "Lnet/minecraft/server/management/PlayerChunkMap;").toRuntime(), new ObfMapping("net/minecraft/world/WorldServer", "field_85177_Q", "Lnet/minecraft/world/Teleporter;").toRuntime()};
                MethodVisitor mv2 = cnode.visitMethod(1, "<init>", serverSig, null, null);
                mv2.visitCode();
                mv2.visitVarInsn(25, 0);
                mv2.visitVarInsn(25, 2);
                mv2.visitVarInsn(25, 3);
                mv2.visitVarInsn(25, 4);
                mv2.visitVarInsn(25, 5);
                mv2.visitVarInsn(21, 6);
                mv2.visitMethodInsn(183, "net/minecraft/world/World", "<init>", worldSig, false);
                mv2.visitVarInsn(25, 0);
                mv2.visitVarInsn(25, 1);
                mcServer.visitFieldInsn(mv2, 181);
                for (ObfMapping field : nullFields) {
                    mv2.visitVarInsn(25, 0);
                    mv2.visitInsn(1);
                    field.visitFieldInsn(mv2, 181);
                }
                mv2.visitInsn(177);
                mv2.visitMaxs(7, 7);
                mv2.visitEnd();
            }

            @Override
            public void transform(MethodNode mv) {
            }
        });
        this.transformer.add(new ModularASMTransformer.ClassNodeTransformer(){

            @Override
            public String className() {
                return "net/minecraft/world/WorldServer".replace('/', '.');
            }

            @Override
            public void transform(ClassNode cn) {
                for (MethodNode a : cn.methods) {
                    a.access = a.access & 0xFFFFFFE9 | 1;
                }
            }
        });
        this.transformer.add(new ModularASMTransformer.ClassNodeTransformer(){

            @Override
            public String className() {
                return "net/minecraft/world/World".replace('/', '.');
            }

            @Override
            public void transform(ClassNode cn) {
                for (MethodNode a : cn.methods) {
                    a.access = a.access & 0xFFFFFFE9 | 1;
                }
            }
        });
        this.transformer.add(new ModularASMTransformer.ClassNodeTransformer(){

            @Override
            public String className() {
                return "cofh.asmhooks.world.WorldProxy";
            }

            @Override
            public void transform(ClassNode cn) {
                Method[] worldMethods = null;
                try {
                    worldMethods = World.class.getDeclaredMethods();
                }
                catch (Throwable e) {
                    Throwables.propagate((Throwable)e);
                }
                for (Method m : worldMethods) {
                    if (Modifier.isStatic(m.getModifiers())) continue;
                    String desc = Type.getMethodDescriptor((Method)m);
                    Iterator i = cn.methods.iterator();
                    while (i.hasNext()) {
                        MethodNode m2 = (MethodNode)i.next();
                        if (!m2.name.equals(m.getName()) || !m2.desc.equals(desc)) continue;
                        i.remove();
                    }
                    MethodVisitor mv = cn.visitMethod(CoFHClassTransformer.getAccess(m), m.getName(), desc, null, CoFHClassTransformer.getExceptions(m));
                    mv.visitCode();
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, cn.name, "proxiedWorld", "Lnet/minecraft/world/World;");
                    Type[] types = Type.getArgumentTypes((Method)m);
                    int w = 1;
                    int e = types.length;
                    for (int i2 = 0; i2 < e; ++i2) {
                        mv.visitVarInsn(types[i2].getOpcode(21), w);
                        w += types[i2].getSize();
                    }
                    mv.visitMethodInsn(182, "net/minecraft/world/World", m.getName(), desc, false);
                    mv.visitInsn(Type.getReturnType((Method)m).getOpcode(172));
                    mv.visitMaxs(types.length, 1);
                    mv.visitEnd();
                }
            }
        });
        this.transformer.add(new ModularASMTransformer.ClassNodeTransformer(){

            @Override
            public String className() {
                return "cofh.asmhooks.world.WorldServerProxy";
            }

            @Override
            public void transform(ClassNode cn) {
                int i;
                int e;
                int w;
                Type[] types;
                MethodVisitor mv;
                MethodNode m2;
                Iterator i2;
                Method[] worldServerMethods = null;
                try {
                    worldServerMethods = WorldServer.class.getDeclaredMethods();
                }
                catch (Throwable e2) {
                    Throwables.propagate((Throwable)e2);
                }
                Method[] worldMethods = null;
                try {
                    worldMethods = World.class.getDeclaredMethods();
                }
                catch (Throwable e3) {
                    Throwables.propagate((Throwable)e3);
                }
                cn.superName = "net/minecraft/world/WorldServer";
                block4: for (MethodNode m : cn.methods) {
                    if (!"<init>".equals(m.name)) continue;
                    InsnList l = m.instructions;
                    int e4 = l.size();
                    for (int i3 = 0; i3 < e4; ++i3) {
                        MethodInsnNode mn;
                        AbstractInsnNode n = l.get(i3);
                        if (!(n instanceof MethodInsnNode) || (mn = (MethodInsnNode)n).getOpcode() != 183) continue;
                        mn.owner = cn.superName;
                        continue block4;
                    }
                }
                for (Method m : worldMethods) {
                    if (Modifier.isStatic(m.getModifiers())) continue;
                    String desc = Type.getMethodDescriptor((Method)m);
                    i2 = cn.methods.iterator();
                    while (i2.hasNext()) {
                        m2 = (MethodNode)i2.next();
                        if (!m2.name.equals(m.getName()) || !m2.desc.equals(desc)) continue;
                        i2.remove();
                    }
                    mv = cn.visitMethod(CoFHClassTransformer.getAccess(m), m.getName(), desc, null, CoFHClassTransformer.getExceptions(m));
                    mv.visitCode();
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, cn.name, "proxiedWorld", "Lnet/minecraft/world/WorldServer;");
                    types = Type.getArgumentTypes((Method)m);
                    w = 1;
                    e = types.length;
                    for (i = 0; i < e; ++i) {
                        mv.visitVarInsn(types[i].getOpcode(21), w);
                        w += types[i].getSize();
                    }
                    mv.visitMethodInsn(182, "net/minecraft/world/World", m.getName(), desc, false);
                    mv.visitInsn(Type.getReturnType((Method)m).getOpcode(172));
                    mv.visitMaxs(types.length + 1, types.length + 1);
                    mv.visitEnd();
                }
                for (Method m : worldServerMethods) {
                    if (Modifier.isStatic(m.getModifiers())) continue;
                    String desc = Type.getMethodDescriptor((Method)m);
                    i2 = cn.methods.iterator();
                    while (i2.hasNext()) {
                        m2 = (MethodNode)i2.next();
                        if (!m2.name.equals(m.getName()) || !m2.desc.equals(desc)) continue;
                        i2.remove();
                    }
                    mv = cn.visitMethod(CoFHClassTransformer.getAccess(m), m.getName(), desc, null, CoFHClassTransformer.getExceptions(m));
                    mv.visitCode();
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, cn.name, "proxiedWorld", "Lnet/minecraft/world/WorldServer;");
                    types = Type.getArgumentTypes((Method)m);
                    w = 1;
                    e = types.length;
                    for (i = 0; i < e; ++i) {
                        mv.visitVarInsn(types[i].getOpcode(21), w);
                        w += types[i].getSize();
                    }
                    mv.visitMethodInsn(182, "net/minecraft/world/WorldServer", m.getName(), desc, false);
                    mv.visitInsn(Type.getReturnType((Method)m).getOpcode(172));
                    mv.visitMaxs(types.length + 1, types.length + 1);
                    mv.visitEnd();
                }
            }
        });
    }

    private static int getAccess(Method m) {
        int r = m.getModifiers();
        r &= 0xFFFFFBA8;
        return r |= 0x1001;
    }

    private static String[] getExceptions(Method m) {
        Class<?>[] d = m.getExceptionTypes();
        if (d == null) {
            return null;
        }
        String[] r = new String[d.length];
        for (int i = 0; i < d.length; ++i) {
            r[i] = Type.getInternalName(d[i]);
        }
        return r;
    }
}

