/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.helpers;

import cofh.thermalexpansion.block.TileReconfigurable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ReconfigurableHelper {
    public static final byte DEFAULT_FACING = 3;
    public static final byte[] DEFAULT_SIDES = new byte[]{0, 0, 0, 0, 0, 0};

    private ReconfigurableHelper() {
    }

    public static NBTTagCompound setItemStackTagReconfig(NBTTagCompound tag, TileReconfigurable tile) {
        if (tile == null) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74774_a("Facing", (byte)tile.getFacing());
        tag.func_74773_a("SideCache", tile.sideCache);
        return tag;
    }

    public static byte getFacingFromNBT(NBTTagCompound tag) {
        return !tag.func_74764_b("Facing") ? (byte)3 : tag.func_74771_c("Facing");
    }

    public static byte[] getSideCacheFromNBT(NBTTagCompound tag, byte[] defaultSides) {
        if (tag == null) {
            return (byte[])defaultSides.clone();
        }
        byte[] retSides = tag.func_74770_j("SideCache");
        return retSides.length < 6 ? (byte[])defaultSides.clone() : retSides;
    }

    public static boolean hasReconfigInfo(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Facing") && stack.func_77978_p().func_74764_b("SideCache");
    }

    public static boolean setFacing(ItemStack stack, int facing) {
        if (facing < 0 || facing > 5) {
            return false;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74774_a("Facing", (byte)facing);
        return true;
    }

    public static boolean setSideCache(ItemStack stack, byte[] sideCache) {
        if (sideCache.length < 6) {
            return false;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74773_a("SideCache", sideCache);
        return true;
    }

    public static byte getFacing(ItemStack stack) {
        return stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("Facing") ? (byte)3 : stack.func_77978_p().func_74771_c("Facing");
    }

    public static byte[] getSideCache(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return (byte[])DEFAULT_SIDES.clone();
        }
        byte[] retSides = stack.func_77978_p().func_74770_j("SideCache");
        return retSides.length < 6 ? (byte[])DEFAULT_SIDES.clone() : retSides;
    }

    public static byte[] getSideCache(ItemStack stack, byte[] defaultSides) {
        if (stack.func_77978_p() == null) {
            return (byte[])defaultSides.clone();
        }
        byte[] retSides = stack.func_77978_p().func_74770_j("SideCache");
        return retSides.length < 6 ? (byte[])defaultSides.clone() : retSides;
    }
}

