/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.fuels.coolant;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.dynamo.TileDynamoCompression;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.fuels.BaseFuelWrapper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;

public class CoolantWrapper
extends BaseFuelWrapper {
    private static DecimalFormat decimalFormat = new DecimalFormat("##0.00");
    final List<List<FluidStack>> inputs;
    protected int factor;
    protected double overclock;
    protected IDrawableAnimated durationFill;

    public CoolantWrapper(IGuiHelper guiHelper, FluidStack fuel, int energy, int factor) {
        ArrayList<FluidStack> recipeInputs = new ArrayList<FluidStack>();
        recipeInputs.add(fuel);
        this.inputs = Collections.singletonList(recipeInputs);
        this.energy = energy;
        this.factor = factor;
        this.overclock = 100.0 / (double)factor;
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getScaleFill(10);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getCoolantFill();
        this.durationFill = guiHelper.createAnimatedDrawable(progressDrawable, energy / (TileDynamoCompression.basePower * 10), IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, energy / (TileDynamoCompression.basePower * 100), IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(FluidStack.class, this.inputs);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.durationFill.draw(minecraft, 34, 43);
        this.energyMeter.draw(minecraft, 71, 7);
        minecraft.field_71466_p.func_78276_b(StringHelper.formatNumber((long)this.energy) + " TC", 96, (recipeHeight - 9) / 2, 685776);
        minecraft.field_71466_p.func_78276_b(decimalFormat.format(this.overclock) + "%", 96, 10 + (recipeHeight - 9) / 2, 13657355);
    }

    @Override
    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return null;
    }
}

