/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.furnace;

import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.machine.TileFurnace;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class FurnaceRecipeWrapper
extends BaseRecipeWrapper {
    final List<List<ItemStack>> inputs;
    final List<ItemStack> outputs;
    final List<FluidStack> outputFluids;
    final IDrawableAnimated fluid;
    final IDrawableAnimated progress;
    final IDrawableAnimated speed;

    public FurnaceRecipeWrapper(IGuiHelper guiHelper, FurnaceManager.FurnaceRecipe recipe) {
        this(guiHelper, recipe, "thermalexpansion.furnace");
    }

    public FurnaceRecipeWrapper(IGuiHelper guiHelper, FurnaceManager.FurnaceRecipe recipe, String uIdIn) {
        this.uId = uIdIn;
        ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        int oreID = FurnaceManager.ComparableItemStackFurnace.getOreID(recipe.getInput());
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputs.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getInput().func_190916_E()));
            }
        } else {
            recipeInputs.add(recipe.getInput());
        }
        switch (this.uId) {
            case "thermalexpansion.furnace_food": 
            case "thermalexpansion.furnace_ore": {
                recipeOutputs.add(ItemHelper.cloneStack((ItemStack)recipe.getOutput(), (int)(recipe.getOutput().func_190916_E() + 1)));
                this.outputFluids = Collections.emptyList();
                this.energy = recipe.getEnergy() * 3 / 2;
                break;
            }
            case "thermalexpansion.furnace_pyrolysis": {
                recipeOutputs.add(recipe.getOutput());
                recipeOutputFluids.add(new FluidStack(TFFluids.fluidCreosote, recipe.getCreosote()));
                this.outputFluids = recipeOutputFluids;
                this.energy = recipe.getEnergy() * 3 / 2;
                break;
            }
            default: {
                recipeOutputs.add(recipe.getOutput());
                this.outputFluids = Collections.emptyList();
                this.energy = recipe.getEnergy();
            }
        }
        this.inputs = Collections.singletonList(recipeInputs);
        this.outputs = recipeOutputs;
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(1);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(this.uId.equals("thermalexpansion.furnace_pyrolysis") ? 1 : 0);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(4);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, this.energy / TileFurnace.basePower, IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileFurnace.basePower, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
        ingredients.setOutputs(FluidStack.class, this.outputFluids);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.uId.equals("thermalexpansion.furnace_pyrolysis")) {
            JEIPluginTE.drawFluid(69, 23, this.outputFluids.get(0), 24, 16);
            this.fluid.draw(minecraft, 69, 23);
        }
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 43, 33);
        this.energyMeter.draw(minecraft, 2, 8);
    }
}

