/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.crucible;

import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.machine.TileCrucible;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CrucibleRecipeWrapper
extends BaseRecipeWrapper {
    final List<List<ItemStack>> inputs;
    final List<FluidStack> outputFluids;
    final IDrawableAnimated fluid;
    final IDrawableAnimated progress;
    final IDrawableAnimated speed;

    public CrucibleRecipeWrapper(IGuiHelper guiHelper, CrucibleManager.CrucibleRecipe recipe) {
        ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
        int oreID = CrucibleManager.ComparableItemStackCrucible.getOreID(recipe.getInput());
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputs.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getInput().func_190916_E()));
            }
        } else {
            recipeInputs.add(recipe.getInput());
        }
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        recipeOutputFluids.add(recipe.getOutput());
        this.inputs = Collections.singletonList(recipeInputs);
        this.outputFluids = recipeOutputFluids;
        this.energy = recipe.getEnergy();
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(2);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(2);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(4);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, this.energy / TileCrucible.basePower, IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileCrucible.basePower, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutputs(FluidStack.class, this.outputFluids);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        JEIPluginTE.drawFluid(69, 23, this.outputFluids.get(0), 24, 16);
        this.fluid.draw(minecraft, 69, 23);
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 43, 33);
        this.energyMeter.draw(minecraft, 2, 8);
    }
}

