/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.crucible;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiCrucible;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.crafting.crucible.CrucibleRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CrucibleRecipeCategory
extends BaseRecipeCategory<CrucibleRecipeWrapper> {
    public static boolean enable = true;
    IDrawableStatic drop;
    IDrawableStatic tank;
    IDrawableStatic tankOverlay;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(CrucibleRecipeCategory.getRecipes(guiHelper), "thermalexpansion.crucible");
        registry.addRecipeClickArea(GuiCrucible.class, 103, 34, 24, 16, new String[]{"thermalexpansion.crucible"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineCrucible, new String[]{"thermalexpansion.crucible"});
    }

    public static List<CrucibleRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<CrucibleRecipeWrapper> recipes = new ArrayList<CrucibleRecipeWrapper>();
        for (CrucibleManager.CrucibleRecipe recipe : CrucibleManager.getRecipeList()) {
            recipes.add(new CrucibleRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public CrucibleRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiCrucible.TEXTURE, 26, 11, 72, 62, 0, 0, 16, 76);
        this.drop = Drawables.getDrawables(guiHelper).getProgress(2);
        this.tank = Drawables.getDrawables(guiHelper).getTank(0);
        this.tankOverlay = Drawables.getDrawables(guiHelper).getTankSmallOverlay(0);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.crucible.name");
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.crucible";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.drop.draw(minecraft, 69, 23);
        this.tank.draw(minecraft, 105, 0);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrucibleRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(FluidStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 42, 14);
        guiFluidStacks.init(0, false, 106, 1, 16, 60, 2000, false, (IDrawable)this.tankOverlay);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiFluidStacks.set(0, (List)outputs.get(0));
    }
}

