/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.centrifuge;

import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.machine.TileCentrifuge;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CentrifugeRecipeWrapper
extends BaseRecipeWrapper {
    final List<List<ItemStack>> inputs;
    final List<ItemStack> outputs;
    final List<FluidStack> outputFluids;
    final List<Integer> chance;
    final IDrawableAnimated progress;
    final IDrawableAnimated speed;

    public CentrifugeRecipeWrapper(IGuiHelper guiHelper, CentrifugeManager.CentrifugeRecipe recipe) {
        ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
        if (CentrifugeManager.ComparableItemStackCentrifuge.getOreID(recipe.getInput()) != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.getOreName((ItemStack)recipe.getInput()), (boolean)false)) {
                recipeInputs.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getInput().func_190916_E()));
            }
        } else {
            recipeInputs.add(recipe.getInput());
        }
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
        recipeOutputs.addAll(recipe.getOutput());
        ArrayList<FluidStack> recipeFluids = new ArrayList<FluidStack>();
        recipeFluids.add(recipe.getFluid());
        this.inputs = Collections.singletonList(recipeInputs);
        this.outputs = recipeOutputs;
        this.outputFluids = recipeFluids;
        this.chance = recipe.getChance();
        this.energy = recipe.getEnergy();
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(0);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(8);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileCentrifuge.basePower, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
        ingredients.setOutputs(FluidStack.class, this.outputFluids);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.progress.draw(minecraft, 62, 23);
        this.speed.draw(minecraft, 34, 32);
        this.energyMeter.draw(minecraft, 2, 8);
    }
}

